// ------------------------------------------------------------------------- //
// $Id: x11win.h,v 1.36 2004/01/06 19:45:45 weismann Exp $
// ------------------------------------------------------------------------- //

/*
 * Copyright (c) 2002 
 *				see AUTHORS list
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

// ------------------------------------------------------------------------- //

#ifndef _X11WIN_H_ 
#define _X11WIN_H_

#if HAVE_CONFIG_H
# include <config.h>
#endif

#if HAVE_GL_GLX_H
# include <GL/glx.h>
#endif

#if HAVE_XVIDMODE
# include <X11/extensions/xf86vmode.h>
#endif

#include "mainwindow.h"

// ------------------------------------------------------------------------- //

//! XWindow is a MainWindow implementation based on X11
class XWindow : public MainWindow {
public:
	XWindow();
	virtual ~XWindow();
	/*!
	 *  create an openGL aware window with the geometry passed
	 *  as a paramter
	 */
	void    create_window(WindowGeometry &geometry, bool fullscreen);
	void    swap_buffers(); 
	void    make_rasterfont(); 
	bool    event(bool block);
	void    toggle_fullscreen();
	std::string get_resolutions();
private:
	/*!
	 *  resize the window to specified parameters. 
	 */
	void    resize_window(int width, int height); 
	void	set_resolution(std::string r);
	std::string get_resolution();
	void    set_wm_hints(WindowGeometry &geometry);
	void    init(int, char**);
	void    keymap_init();
	void    X11_TranslateKey(XKeyEvent *xkey, KeyCode kc, KeyEvent& key_event);
	int     _x, _y;           ///< window position
	uint	_geo_width, _geo_height;
	Display *_display;
	Window _window;
	SDLKey  ODD_keymap[256];
	SDLKey  MISC_keymap[256];
	XSetWindowAttributes _attr;
#ifdef HAVE_XVIDMODE
	std::string _original_resolution;
	typedef std::map<std::string, XF86VidModeModeInfo*> _videomodes_;
	_videomodes_ _videomodes;
#endif
};

#endif	// _X11WIN_H_

// ------------------------------------------------------------------------- //

