// ------------------------------------------------------------------------- //
// $Id: group.cpp,v 1.27 2003/09/04 20:49:34 weismann Exp $
// ------------------------------------------------------------------------- //

/*
 * Copyright (c) 2002 
 *				see AUTHORS list
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

// ------------------------------------------------------------------------- //

#if HAVE_CONFIG_H
# include <config.h>
#endif

#if HAVE_ALGORITHM
# include <algorithm>
#endif

#include "group.h"
#include "primitive.h"

// ------------------------------------------------------------------------- //

Group::Group(const std::string& name) : Node(name)
{
}

Group::~Group()
{
	// FIXME call destructor of each node, why not _children.clean() ?
	for (child_iter i = _children.begin(); i != _children.end(); ++i) {
		delete (*i);
	}
}

void Group::add(Node* child)
{
	_children.push_back(child);
	child->_parent = this;
}

bool Group::remove(Node* child)
	// FIXME consider use of algorithm remove together with clean (josuttis 327, 378)
{
	child_iter i = std::find(_children.begin(), _children.end(), child);
	if (i == _children.end())
		return false;
	_children.erase(i);
	(*i)->_parent = 0;
	return true;
}

void Group::draw_prims(float alpha)
{
	if (!get_visible()) return;
	alpha *= _alpha;
	glPushMatrix();
	_load_GL_matrix();
	for (child_iter i = _children.begin(); i != _children.end(); ++i) {
		(*i)->draw_prims(alpha);
	}
	glPopMatrix();
}

void Group::frame_update()
{
	for (child_iter i = _children.begin(); i != _children.end(); ++i) {
		(*i)->frame_update();
	}
	Node::frame_update();
}

void Group::dump_tree(uint indent)
{
	Node::dump_tree(indent);
	for (child_iter i = _children.begin(); i != _children.end(); ++i) {
		(*i)->dump_tree(indent + 4);
	}
}

// ------------------------------------------------------------------------- //

