<?php
/**
 * German Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2005  Kurt Norgaz and Peter Pluntke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @author Norgaz Kurt
 * @author Peter Pluntke
 * @version $Id: configure_help.de.php,v 1.53.2.8 2006/01/04 12:58:46 canajun2eh Exp $
 */
if (preg_match("/configure_help\...\.php$/", $_SERVER["SCRIPT_NAME"])>0) {
        print "You cannot access a language file directly.";
        exit;
}
//-- CONFIGURE FILE MESSAGES
$pgv_lang["configure"]			= "PhpGedView konfigurieren";
$pgv_lang["standard_conf"]		= "Konfiguration Grundeinstellungen";
$pgv_lang["advanced_conf"]		= "Konfiguration erweiterte Einstellungen";
$pgv_lang["gedcom_conf"]		= "GEDCOM Grundlagen";
$pgv_lang["media_conf"]			= "Multimedia";
$pgv_lang["accpriv_conf"]		= "Zugang und Privatsphäre";
$pgv_lang["displ_conf"]			= "Bildschirm und Layout";
$pgv_lang["displ_names_conf"]	= "Namen";
$pgv_lang["displ_comsurn_conf"] = "Gemeinsamer Familienname";
$pgv_lang["displ_layout_conf"]	= "Layout<br />";
$pgv_lang["displ_hide_conf"]	= "Verbergen und Zeigen";
$pgv_lang["editopt_conf"]		= "Bearbeitungsoptionen";
$pgv_lang["useropt_conf"]		= "Benutzer Optionen";
$pgv_lang["contact_conf"]		= "Kontakt Information";
$pgv_lang["meta_conf"]			= "Konfiguration META Tags";
$pgv_lang["configure_head"]		= "PhpGedView Konfiguration";
$pgv_lang["gedconf_head"]		= "GEDCOM Konfiguration";
$pgv_lang["default_user"]		= "Erstellen Sie den Hauptadministrator.";
$pgv_lang["about_user"]			= "Sie müssen zunächst den Hauptadministrator erstellen. Dieser Benutzer wird das Recht erhalten, die Konfigurationsdateien zu verändern, private Daten zu sehen oder andere Benutzer zu erstellen.";
$pgv_lang["can_admin"]			= "darf verwalten";
$pgv_lang["can_edit"]			= "Zugriffsrechte";
$pgv_lang["access"]				= "Zugreifen";
$pgv_lang["sync_gedcom"]		= "Synchronisiere Benutzer Einstellungen mit den GEDCOM Daten";
$pgv_lang["add_user"]			= "Neuen Benutzer hinzufügen";
$pgv_lang["current_users"]		= "Liste vorhandener Benutzer";
$pgv_lang["leave_blank"]		= "Passwort leer lassen, um das aktuelle Passwort beizubehalten.";
$pgv_lang["other_theme"]		= "Anderes Darstellungsthema. Bitte Verzeichnis eingeben.";
$pgv_lang["performing_update"]		= "Update wird durchgeführt.";
$pgv_lang["config_file_read"]		= "Konfigurationsdatei wurde gelesen.";
$pgv_lang["does_not_exist"]		= "existiert nicht";
$pgv_lang["media_drive_letter"]		= "Der Pfad zur Media-Datei sollte keinen Laufwerksbuchstaben enthalten. Diese Datei kann sonst eventuell nicht angezeigt werden.";
$pgv_lang["pgv_config_write_error"]		= "Fehler!!! Die PhpGedView-Konfigurationsdatei kann nicht geschrieben werden. Bitte Lese- und Schreib-Berechtigungen überprüfen und neu versuchen.";
$pgv_lang["db_setup_bad"]		= "Ihre aktuelle Datenbank-Konfiguration ist unzulässig. Bitte überprüfen Sie ihre Datenbankverbindungsparameter und konfigurieren Sie diese neu.";
$pgv_lang["bad_host_user_pass"]	= "PhpGedView konnte keine Verbindung zu Ihrem Datenbank Host aufbauen. Überprüfen Sie bitte den Host, Benutzernamen und Passwort.";
$pgv_lang["bad_database_name"]	= "PhpGedView hat eine Verbindung zu Ihrem Datenbank Host hergestellt, konnte aber den von Ihnen angegebenen Datenbank Namen nicht verwenden. Bitte prüfen Sie, dass diese Datenbank existiert und dass der angegebene Benutzername die notwendigen Zugriffsrechte hat.";
$pgv_lang["click_here_to_continue"]	= "Hier klicken, um fortzufahren.";
$pgv_lang["config_help"]		= "Hilfe zur Konfiguration";
$pgv_lang["index"]			= "Index Dateien";
$pgv_lang["mysql"]			= "MySQL";
$pgv_lang["db"]				= "Datenbank";
$pgv_lang["dbase"]			= "dBase";
$pgv_lang["fbsql"]			= "FrontBase";
$pgv_lang["ibase"]			= "InterBase";
$pgv_lang["ifx"]			= "Informix";
$pgv_lang["msql"]			= "Mini SQL";
$pgv_lang["mssql"]			= "Microsoft SQL Server";
$pgv_lang["mysqli"]			= "MySQL 4.1+ and PHP 5";
$pgv_lang["oci8"]			= "Oracle 7+";
$pgv_lang["pgsql"]			= "PostgreSQL";
$pgv_lang["sqlite"]			= "SQLite";
$pgv_lang["sybase"]			= "Sybase";
$pgv_lang["admin_gedcoms"]		= "Hier klicken, um GEDCOMs zu verwalten.";
$pgv_lang["current_gedcoms"]		= "Vorhandene GEDCOMs";
$pgv_lang["gedcom_adm_head"]	= "GEDCOM Verwaltung";
$pgv_lang["ged_download"]		= "Download";
$pgv_lang["ged_gedcom"]			= "GEDCOM-Datei";
$pgv_lang["ged_title"]			= "GEDCOM Bezeichnung";
$pgv_lang["ged_config"]			= "Konfigurations-Datei";
$pgv_lang["ged_privacy"]		= "Datenschutzdatei";
$pgv_lang["show_phpinfo"]		= "PHPInfo-Seite anzeigen";
$pgv_lang["confirm_gedcom_delete"]	= "Wollen Sie diese GEDCOM Datei wirklich löschen";
$pgv_lang["gregorian"]			= "Gregorianisch";
$pgv_lang["julian"]			= "Julianisch";
$pgv_lang["config_french"]		= "Französisch";
$pgv_lang["jewish"]			= "Jüdisch";
$pgv_lang["config_hebrew"]		= "Hebräisch";
$pgv_lang["jewish_and_gregorian"]	= "Jüdisch and Gregorianisch";
$pgv_lang["hebrew_and_gregorian"]	= "Hebräisch and Gregorianisch";
$pgv_lang["hijri"]				= "Hijri";
$pgv_lang["arabic_cal"]				= "Arabisch";
$pgv_lang["disabled"]			= "Deaktiviert";
$pgv_lang["mouseover"]			= "Bei \"Mouse Over\"";
$pgv_lang["mousedown"]			= "Bei \"Mouse Down\"";
$pgv_lang["click"]			= "Bei \"Mouse Click\"";
$pgv_lang["mailto"]			= "E-Mail Verknüpfung";
$pgv_lang["messaging"]			= "Interne Nachrichten-Funktion von PhpGedView";
$pgv_lang["messaging2"]			= "Interne Nachrichten-Funktion und E-Mail Verknüpfung";
$pgv_lang["messaging3"]			= "PhpGedView sendet E-Mails ohne sie zu speichern";
$pgv_lang["no_messaging"]		= "keine Nachrichten-Funktion";
$pgv_lang["no_logs"]			= "Logging deaktivieren";
$pgv_lang["daily"]			= "Täglich";
$pgv_lang["weekly"]			= "Wöchentlich";
$pgv_lang["monthly"]			= "Monatlich";
$pgv_lang["yearly"]			= "Jährlich";
$pgv_lang["enter_db_pass"]		= "Aus Sicherheitsgründen müssen Sie einen Datanbank-Benutzernamen und ein Datenbank-Passwort eingeben, bevor Sie die Konfiguration verändern.";
$pgv_lang["config_still_writable"]	= "Für Ihre Datei config.php bestehen noch schreib-Rechte. Wenn die Konfiguration beendet ist, sollten Sie die Rechte sicherheitshalber wieder auf Nur-Lesen setzen.";
$pgv_lang["admin_verification_waiting"] = "Offene Anträge für Benutzerzugänge";
$pgv_lang["DEFAULT_GEDCOM"]		= "Standard GEDCOM";
$pgv_lang["privileges"]			= "Rechte";
$pgv_lang["date_registered"]	= "Datum der Registrierung";
$pgv_lang["last_login"]			= "Letzte Anmeldung";
$pgv_lang["server_url_note"]	= "Geben Sie die URL zu Ihrem PhpGedView-Ordner an. Sie sollten diesen Wert nur ändern, wenn Sie die Bedeutung verstehen. PhpGedView hat die SERVER_URL wie folgt ermittelt: #GUESS_URL#";

$pgv_lang["PGV_DATABASE"]		= "PhpGedView Daten-Speicher";
$pgv_lang["PGV_DATABASE_help"]		= "Die Art der Datenspeicherung, die Sie für Ihre GEDCOM Dateien wünschen. Wählen Sie \"Index Dateien\", um Index-Dateien im Index-Verzeichnis zu erstellen oder wählen Sie \"DB\", um eine Datenbank (z.B. MySQL) zu verwenden.<br />Diese Einstellung verändert die Variable \$PGV_DATABASE in der Datei \"config.php\".";
$pgv_lang["DBTYPE"]			= "Datenbank-Typ";
$pgv_lang["DBTYPE_help"]		= "Der Typ der Datenbank (PEAR-Unterstützung) die genutzt werden soll. Möglich sind: MySQL, PostgreSQL, Oracle und SQLite. Diese Einstellung ändert die Variable \$DBTYPE in der Datei config.php.";
$pgv_lang["DBHOST"]			= "Host für die Datenbank";
$pgv_lang["DBHOST_help"]		= "Die DNS- oder IP-Adresse Ihres Datenbank-Servers.<br />Diese Einstellung verändert die Variable \$DBHOST in der Datei \"config.php\".";
$pgv_lang["DBUSER"]			= "Benutzername für die Datenbank";
$pgv_lang["DBUSER_help"]		= "Der Benutzername der benötigt wird, um eine Verbindung zu Ihrer Datenbank herzustellen.<br />Diese Einstellung verändert die Variable \$DBUSER in der Datei \"config.php\".";
$pgv_lang["DBPASS"]			= "Passwort für die Datenbank";
$pgv_lang["DBPASS_help"]		= "Das Passwort das für den oben von Ihnen angegebenen Benutzernamen benötigt wird, um eine Verbindung zu Ihrer Datenbank herzustellen.<br />Diese Einstellung verändert die Variable \$DBPASS in der Datei \"config.php\".";
$pgv_lang["DBNAME"]			= "Name der Datenbank";
$pgv_lang["DBNAME_help"]		= "Die Datenbank auf Ihrem Server, die Sie mit PhpGedView nutzen möchten.<br /><br />Der Benutzername aus dem Benutzerfeld muss über Generierungs-, Einfügungs-, Update-, Lösch- und Auswahlrechte innerhalb dieser Datenbank verfügen.<br /><br />Diese Einstellung verändert die Variable \$DBNAME in der Datei \"config.php\".";
$pgv_lang["TBLPREFIX"]			= "Prefix der Datenbank Tabelle";
$pgv_lang["TBLPREFIX_help"]		= "Ein Prefix der an die Tabellen angehängt wird, die von PhpGedView erstellt werden. Durch Ändern dieses Wertes können Sie mehrere PhpGedView-Sites bestimmen, die die gleiche Datenbank jedoch unterschiedliche Tabellen benutzen.<br />Diese Einstellung verändert die Variable \$TBLPREFIX in der Datei \"config.php\".";
$pgv_lang["ALLOW_CHANGE_GEDCOM"]	= "Wechsel der GEDCOM-Datei erlauben";
$pgv_lang["ALLOW_CHANGE_GEDCOM_help"]	= "Die Einstellung <b>JA</b> erlaubt den Besuchern <b>und</b> angemeldeten Benutzern die verwendete GEDCOM-Datei selbst auszuwählen, sofern Ihre Konfiguration mehrere GEDCOM-Dateien enthält. <br /><br />Bei Einstellung <b>Nein</b>, können <b>weder</b> Besucher, <b>noch</b> angemeldete Benutzer die GEDCOM-Datei auswählen können.<br /><br />Diese Einstellung verändert die Variable \$ALLOW_CHANGE_GEDCOM in der Datei \"config.php\".";
$pgv_lang["GEDCOM"]			= "Pfad und Name der GEDCOM-Datei";
$pgv_lang["gedcom_path_help"]		= "Bitte speichern Sie Ihre GEDCOM-Datei zunächst an einer Stelle auf Ihrem Servers, auf die man mit PHP zugreifen kann. Dann geben Sie hier den Pfad und Dateinamen dieser Datei an: z.B.: <b>./index/name.ged</b>.</br></br>Für weitere Hilfe schauen Sie in die Datei <a href=\"readme.txt\">\"Readme.txt\"</a>";
$pgv_lang["CHARACTER_SET"]		= "Kodierung der Schriftzeichen";
$pgv_lang["CHARACTER_SET_help"]		= "Dies ist die Bezeichnung für die Kodierung, mit der Sie Ihre GEDCOM-Datei gespeichert haben. UTF-8 ist die Standardeinstellung  und sollte auf fast allen Websites funktionieren. Falls Sie ihre GEDCOM-Datei mit IBM-Windows Kodierung exportiert haben, sollten Sie hier WINDOWS angeben.<br /><br />Bitte beachten Sie: PHP unterstützt ->KEIN<- UNICODE (UTF-16)! Also versuchen Sie dies nicht und beschweren Sie sich bei den PHP-Machern :-)";
$pgv_lang["LANGUAGE"]			= "Sprache";
$pgv_lang["LANGUAGE_help"]		= "Bestimmen Sie die Standardsprache für Ausgaben auf dieser Site. Die Benutzer haben die Möglichkeit, diese Einstellung durch Konfiguration ihres Browsers oder durch Auswahl der Anzeigesprache im unteren Bereich der Seiten zu verändern, falls die Variable \$ENABLE_MULTI_LANGUAGE in der Datei \"config.php\" auf \"true\" steht.";
$pgv_lang["ENABLE_MULTI_LANGUAGE"]	= "Besuchern den Wechsel der Anzeige-Sprache erlauben";
$pgv_lang["ENABLE_MULTI_LANGUAGE_help"]	= "\"Ja\" wählen, um den Besuchern zu ermöglichen, eine andere Anzeigesprache aus einer Dropdown-Liste auszuwählen. Als Voreinstellung wird bei \"JA\" die Standardsprache ihres Browsers gewählt.";
$pgv_lang["CALENDAR_FORMAT"]		= "Kalender Format";
$pgv_lang["CALENDAR_FORMAT_help"]	= "Geben Sie das gewünschte Kalender-Format für diese GEDCOM-Datei an. Hebräisch entspricht dem Jüdischen Kalender aber mit Hebräischen Schriftzeichen. Bitte beachten: Die Werte für Jüdische und Hebräische Daten werden aus den Gegorianischen / Julianischen Daten berechnet. Da der Jüdische Kalendertag mit dem Abend beginnt, wird jedes Ereignis zwischen Abend und Mitternacht mit dem Datum einen Tag vor dem korrekten Jüdischen Datum angezeigt. Hebräische Darstellung kann bei einigen älteren Browsern zu Schwierigkeiten führen (Darstellung rückwärts oder gar keine Darstellung).";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS"]	= "Hebräische Tausender anzeigen";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS_help"]	= "Alafim in Hebräischen Kalendern anzeigen. Bei \"Ja\" wird das Jahr 1969 als <span lang=\"he-IL\" dir='rtl'>&#1492;'&#160;&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm; angezeigt, während es bei \"Nein\" als <span lang=\"he-IL\" dir='rtl'>&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm; angezeigt wird. Dies hat keinen Einfluss auf die Jüdische Jahreseinstellung. Das Jahr wird als 5729 angezeigt unabhängig von dieser Einstellung<br />Bitte beachten: Diese Einstellung entspricht der php 5.0 Kalender-Einstellung CAL_JEWISH_ADD_ALAFIM.<br />Diese Einstellung verändert die Variable \$DISPLAY_JEWISH_THOUSANDS in der Datei config.php.";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM"]		= "Hebräische Gershayim anzeigen";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM_help"]	= "Einfache und doppelte Hochkommata in Hebräischen Daten anzeigen. Bei \"Ja\" wird der 8. Februar 1969 als <span lang='he-IL' dir='rtl'>&#1499;'&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm; angezeigt, bei \"Nein\" als <span lang='he-IL' dir='rtl'>&#1499;&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&#1496;</span>&lrm;. Dies hat keinen Einfluss auf die Jüdische Jahreseinstellung, da Hochkommata bei der dortigen lateinischen Darstellung nicht genutzt werden.<br />Bitte beachten: Diese Einstellung entspricht den php 5.0 Kalender-Einstellungen CAL_JEWISH_ADD_ALAFIM_GERESH und CAL_JEWISH_ADD_GERESHAYIM und beeinflusst BEIDE Werte.<br />Diese Einstellung verändert die Variable \$DISPLAY_JEWISH_GERESHAYIM in der Datei config.php.";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION"]	= "Jüdische Ashkenaz Schreibweise";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION_help"]	= "Jüdische Ashkenazi Schreibweise benutzen.<br />Bei \"Ja\" werden die Monate Cheshvan und Teves in der Ashkenazi Schreibweise verwendet. Bei \"Nein\" werden die Monate als Hesvan und Tevet angezeigt. <br />Dies beeinflusst nur die Jüdische Einstellung. Im Hebräischen wird das Hebräische Alphabet benutzt.<br />Diese Einstellung verändert die Variable \$JEWISH_ASHKENAZ_PRONUNCIATION in der Datei config.php.";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS"]	= "Anzahl standardmäßig dargestellter Generationen in der Stammbaum-Darstellung";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS_help"]	= "Bestimmt die Anzahl standardmäßig dargestellter Generationen, die in der Stammbaumdarstellung gleichzeitig angezeigt werden.";
$pgv_lang["MAX_PEDIGREE_GENERATIONS"]		= "Maximale Anzahl Generationen im Stammbaum";
$pgv_lang["MAX_PEDIGREE_GENERATIONS_help"]	= "Verändert die Anzahl der Generationen, die maximal in der Stammbaum Ansicht angezeigt werden.";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS"]	= "Maximale Anzahl Generationen im Nachfahrenbaum";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS_help"]	= "Verändert die Anzahl der Generationen, die maximal im Nachfahrenbaum angezeigt werden.";
$pgv_lang["USE_RIN"]			= "RIN# anstelle von GEDCOM ID verwenden";
$pgv_lang["USE_RIN_help"]		= "Bei \"Ja\" wird die RIN Nummer anstelle der GEDCOM ID verwendet, wenn in Konfigurationen, Benutzer-Einstellungen und Diagrammen nach Personen gefragt wird. Dies ist hilfreich für Genealogie Software die GEDCOM-Dateien nicht mit einheitlichen IDs  aber immer mit den gleiche RIN für Personen exportiert.";
$pgv_lang["PEDIGREE_ROOT_ID"]		= "GEDCOM-Personennummer der standardmäßig ausgewählten Person für Stammbaum und Nachfahrenbaum";
$pgv_lang["PEDIGREE_ROOT_ID_help"]	= "Bestimmt die ID der Person, die standardmäßig als Startperson in der Stammbaum- und Nachfahrenbaum-Darstellung verwendet wird.";
$pgv_lang["GEDCOM_ID_PREFIX"]		= "GEDCOM ID Prefix";
$pgv_lang["GEDCOM_ID_PREFIX_help"]	= "In Stammbäumen, Nachfahrenbäumen, Verwandtschafts- und anderen Darstellungen wird dieses Prefix der ID vorangestellt, die der Besucher zur Personen-Auswahl eingeben kann, sofern er das Prefix nicht selbst voranstellt.";
$pgv_lang["PEDIGREE_FULL_DETAILS"]	= "Geburts- und Todesdetails im Stammbaum und Nachfahrenbaum anzeigen";
$pgv_lang["PEDIGREE_FULL_DETAILS_help"]	= "Dieses Feld bestimmt, ob die Einzelheiten der Geburts- und Sterbedaten von Personen standardmäßig dargestellt werden oder nicht.";
$pgv_lang["PEDIGREE_LAYOUT"]		= "Standard Stammbaum Layout";
$pgv_lang["PEDIGREE_LAYOUT_help"]	= "Hier stellen Sie ein, ob der Stammbaum im Hochformat oder Querformat generiert werden soll.";
$pgv_lang["SHOW_EMPTY_BOXES"]		= "Leere Boxen im Stammbaum anzeigen";
$pgv_lang["SHOW_EMPTY_BOXES_help"]	= "Gibt an, ob leere Boxen im Stammbaum angezeigt werden sollen.";
$pgv_lang["ZOOM_BOXES"]			= "Boxen in Diagrammen zoombar";
$pgv_lang["ZOOM_BOXES_help"]		= "Erlaubt dem Besucher in Boxen eines Diagramms für mehr Informationen hineinzuzoomen. Auf \"Deaktiviert\" stellen, um dieses Feature abzuschalten. Auf \"MouseOver\" stellen, um den Zoom beim Überfahren des Icons mit der Maus auszulösen. Auf \"Click\" stellen, um den Zoom durch Klick auf das Icon auszulösen.";
$pgv_lang["LINK_ICONS"]			= "PopUp Links in Diagrammen";
$pgv_lang["LINK_ICONS_help"]		= "Erlaubt die Auswahl von Links zu anderen Diagrammen und zu nahen Verwandten einer Person. Auf \"Deaktiviert\" stellen, um dieses Feature abzuschalten.Auf \"MouseOver\" stellen, um ein Popup-Fenster mit den Links anzuzeigen, wenn der Benutzer mit der Maus über das Symbol in der Personen-Box fährt. Auf  \"Click\" stellen, um das Popup-Fenster durch Klick auf das Symbol aufzurufen.";
$pgv_lang["ABBREVIATE_CHART_LABELS"]			= "Bezeichnungen in Diagrammen abkürzen";
$pgv_lang["ABBREVIATE_CHART_LABELS_help"]		= "Legt fest, ob in den Diagrammen Bezeichnungen wie 'Geburt' nur mit dem Anfangsbuchstaben ('G') abgekürzt werden.";
$pgv_lang["SHOW_PARENTS_AGE"]			= "Zeigt Alter der Eltern bei der nächsten Geburt eines Kindes";
$pgv_lang["AUTHENTICATION_MODULE"]	= "Dateiname der Authentifizierungs-Modul-Datei";
$pgv_lang["AUTHENTICATION_MODULE_help"]	= "In diesem Feld bestimmen Sie den Namen der Datei, aus der die Funktionen zur Authentifizierung gelesen werden, die Ihren Besuchern Zugriff auf bestimmte geschützte Personendaten innerhalb PhpGedView bieten. Durch hinzufügen von Funktionen in diese Datei können Sie andere Authentifizierungsmethoden und andere Datenbanken zur Speicherung von Besucher-Zugansdaten bestimmen, als diejenigen aus der Originaldatei, die mit PhpGedView standardmäßig ausgeliefert wird.<br /><br />In der Hoffnung, dass eines Tages Betreiber von PhpGedView-Sites, ihre selbsterstellten Authentifizierungsmodule, den anderen Betreibern von PhpGedView-Sites zur Einbindung in deren Websites zur Verfügung stellen werden.<br /><br />Dieses Feld definiert den Inhalt der Variable \$AUTHENTICATION_MODULE in der Datei \"config.php\".";
$pgv_lang["HIDE_LIVE_PEOPLE"]		= "Lebende Personen verbergen";
$pgv_lang["HIDE_LIVE_PEOPLE_help"]	= "Diese Option dient dazu, Daten von lebenden Personen vor den Augen \"gewöhnlicher\" Besucher zu verbergen. Lebende Personen sind für PhpGedView diejenigen, die Einträge in Ihrem Datensatz haben, die jünger sind, als das in der Variable \$MAX_ALIVE_AGE definierte Alter und keine Kinder haben, die vor mehr als in der Variable \$MAX_ALIVE_AGE angegebenen Jahren geboren wurden.";
$pgv_lang["REQUIRE_AUTHENTICATION"]	= "Besucher Login notwendig";
$pgv_lang["REQUIRE_AUTHENTICATION_help"]= "Wenn diese Einstellung aktiv ist, muss sich ein Besucher erst anmelden, bevor ihm irgendwelche Daten dieser Seite gezeigt werden.";
$pgv_lang["WELCOME_TEXT_AUTH_MODE"]	= "Willkommenstext auf der Login-Seite (Authentifizierungs-Modus)";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_help"]	= "Hier können Sie einen Text auswählen, der auf der Login-Seite erscheint, wenn der Authentifizierungs-Modus aktiviert ist. Bitte prüfen Sie welcher vordefinierte Text am geeignetsten ist.<br />Sie können auch Ihren eigenen Willkommens-Text erstellen, aber dieser wird nicht in die anderen Sprachen übersetzt!<br /><br />Die vordefinierten Texte lauten:<br /><br /><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT1]# :</b><br /><br />#pgv_lang[welcome_text_auth_mode_1]#<br /><br /><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT2]# :</b><br /><br />#pgv_lang[welcome_text_auth_mode_2]#<br /><br /><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT3]# :</b><br /><br />#pgv_lang[welcome_text_auth_mode_3]#";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT1"]	= "Vordefinierter Text, der besagt, dass alle Benutzer einen Zugang beantragen können";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT2"]	= "Vordefinierter Text, der besagt, dass der Administrator über den Zugangs-Antrag entscheidet";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT3"]	= "Vordefinierter Text, der besagt, dass nur Familienmitglieder einen Zugang beantragen können";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT4"]	= "Selbsterstellter Text wie unten angegeben (erscheint nur in der Originalsprache!)";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST"]	= "Selbsterstellter Text für den Authentifizierungs-Modus";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_help"]	= "Wenn Sie im vorigen Feld \"Selbsterstellter Text\" ausgewählt haben, können Sie hier diesen Text eingeben.<br />Der Text wird NICHT in andere Sprachen übersetzt sondern erscheint für alle Benutzer nur in der Sprache, in der Sie ihn eintragen.<br />Sie können im Text HTML-tags verwenden.";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_HEAD"] = "Standard Kopf für benutzerdefinierten Willkommens-Text";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_HEAD_help"] = "Wählen Sie, ob ein (mehrsprachiger) Kopf für Ihren selbsterstellten Willkommens-Text angezeigt werden soll.<br /><br />Wenn Sie 'JA' wählen, wird folgender Kopf angezeigt:<br /><br />#pgv_lang[welcome_text_cust_head]#";
$pgv_lang["CHECK_CHILD_DATES"]		= "Daten der Kinder überprüfen";
$pgv_lang["CHECK_CHILD_DATES_help"]	= "Überprüft die Daten der Kinder einer Person, um zu bestimmen, ob eine Person schon verstorben ist oder nicht. Falls sich Ihre Website auf einem älteren Server befindet und Sie eine große GEDCOM-Datenbanken nutzen, kann die Einstellung \"Ja\" bewirken, dass die Antwortzeit Ihres Servers verzögert wird.";
$pgv_lang["MAX_ALIVE_AGE"]		= "Alter, ab dem angenommen wird, dass eine Person verstorben ist";
$pgv_lang["MAX_ALIVE_AGE_help"]		= "Das maximale Alter einer Person, das maximale Alter eines persönlichen Eintrages einer Person oder das maxiamale Alter der Kinder dieser Person, damit angenommen wird, dass diese Person mittlerweile verstorben ist und ihr Datensatz nicht mehr dem Datenschutz unterliegt.";
$pgv_lang["SHOW_GEDCOM_RECORD"]		= "Besuchern erlauben die GEDCOM-Roh-Daten anzusehen";
$pgv_lang["SHOW_GEDCOM_RECORD_help"]	= "Bei \"Ja\" wird eine Verknüpfung auf den Seiten von Personen, Quellen und Familien eingefügt, die ein neues Fenster mit den jeweiligen Roh-Daten aus der GEDCOM-Datei öffnet.";
$pgv_lang["ALLOW_EDIT_GEDCOM"]		= "Online Editieren erlauben";
$pgv_lang["ALLOW_EDIT_GEDCOM_help"]	= "Ermöglich das Online Editieren für diese GEDCOM-Datei, mittels dessen Besucher mit Edit-Rechten die GEDCOM-Datei online verändern können.";
$pgv_lang["INDEX_DIRECTORY"]		= "Verzeichnis der Index-Dateien";
$pgv_lang["INDEX_DIRECTORY_help"]	= "Der Pfad zu einem Verzeichnis mit Lese- und Schreibrechten, in dem PhpGedView die Index-Dateien speichern soll (einschließlich des führenden \"/\").<br />Dieses Feld definiert den Inhalt der Variable \$INDEX_DIRECTORY in der Datei \"config.php\".";
$pgv_lang["ALPHA_INDEX_LISTS"]		= "Lange Namens-Listen in Anfangsbuchstaben-Listen aufteilen";
$pgv_lang["ALPHA_INDEX_LISTS_help"]	= "Für lange Listen von Personen und Familien bewirkt das Setzen dieses Feldes auf  \"Ja\", dass die Listen-Darstellung der Individuen und Familien in einzelne Seiten nach den Anfangsbuchstaben ihrer Nachnamen aufgepalten werden.";
$pgv_lang["NAME_FROM_GEDCOM"]		= "Angezeigten Namen aus GEDCOM verwenden";
$pgv_lang["NAME_FROM_GEDCOM_help"]	= "Normalerweise verwendet PhpGedView für Personen den Namen, der in der Index-Datei gespeichert wurde. Bei manchen GEDCOM-Formaten oder -Sprachen wird dieser Name aus der Index-Datei nicht korrekt angezeigt und der beste Weg für eine korrekte Darstellung wäre direkt aus der GEDCOM-Datei. Z.B. bestehen Spanische Nachnamen oft aus Vornamen - Nachname des Vaters - Nachname der Mutter. Bei Verwendung der Indexdateien würden die Nachnamen des Vaters und der Mutter vertauscht. Nur durch Auslesen des Namens aus der GEDCOM-Datei  würde dieser korrekt dargestellt. Allerdings wird das Programm und die Anzeige dadurch etwas langsamer.";
$pgv_lang["SHOW_ID_NUMBERS"]		= "ID Nummern bei Namen anzeigen";
$pgv_lang["SHOW_ID_NUMBERS_help"]	= "Anzeige der ID Nummern in Klammern hinter den Personen-Namen in den Diagrammen.";
$pgv_lang["SHOW_PEDIGREE_PLACES"]	= "Anzahl der angezeigten Ebenen der hierarchischen Orts-Angaben";
$pgv_lang["SHOW_PEDIGREE_PLACES_help"]	= "Hier stellen Sie ein, wie viele Informationen zu den Orts-Angaben in den Personen-Boxen im Diagramm angezeigt werden. Die Einstellung \"9\" sorgt für vollständige Orts-Angaben. Die Einstellung \"0\" unterdrückt die Orts-Angabe komplett. Die Einstellung \"1\" zeigt nur eine Ebene, die Einstellung \"2\" zeigt die ersten beiden Ebenen usw. (bezieht sich auf die Unterteilung durch Kommata, z.B. Bonn, Rheinland-Pfalz, Deutschland).";
$pgv_lang["MULTI_MEDIA"]		= "Multimediaunterstützung aktivieren";
$pgv_lang["MULTI_MEDIA_help"]		= "Die Spezifikation von GEDCOM 5.5 erlaubt Ihnen Fotos, Videos und andere Multimedia-Objekte in Ihre GEDCOM-Datenbank hinzuzufügen. Falls Sie keine Multimedia-Objekte in ihre GEDCOM-Datenbank hinzugefügt haben, können Sie die Multimedia-Unterstützung von PhpGedView durch Setzen dieses Feldes auf N(ein) abschalten.<br />Lesen Sie im Abschnitt \"multimedia\" der Datei <a href=\"readme.txt\">readme.txt</a>, um mehr darüber zu erfahren, wie Sie Multimedia-Dateien in Ihre Website einfügen können.";
$pgv_lang["MEDIA_EXTERNAL"]			= "Links beibehalten";
$pgv_lang["MEDIA_EXTERNAL_help"]	= "Ein vorkommender Multimedia-Link, der z.B. mit http://, ftp://, mms:// beginnt, wird nicht verändert, wenn Sie \"Links bebehalten\" auf JA setzen. Wenn Sie diesen Wert auf NEIN setzen, dann wird der Link wie ein Verweis auf die Multimedia-Daten behandelt und die Einstellung bezüglich Multimedie-Verzeichnis etc. werden berücksichtigt. z.B.: http://www.meinefamilie.de/foto/papa.jpg wird geändert zu .media/papa.jpg";
$pgv_lang["MEDIA_DIRECTORY"]		= "Verzeichnis der Multimedia-Dateien";
$pgv_lang["MEDIA_DIRECTORY_help"]	= "Der Pfad zu einem Verzeichnis mit Leserechten auf einem Server, in dem PhpGedView nach den Multimedia-Dateien suchen soll, die in den jeweiligen Datensätzen der enthaltenen Personen einer GEDCOM-Datenbank definiert wurden (einschließlich des führenden \"/\").";
$pgv_lang["MEDIA_DIRECTORY_LEVELS"]	= "Multimedia Verzeichnis-Tiefe";
$pgv_lang["MEDIA_DIRECTORY_LEVELS_help"]= "Ein Wert von 0 wird alle Unterverzeichniss im Verzeichnis für Multimedia-Objekte ignorieren. Ein Wert von 1 wird zusätzlich das erste Unterverzeichnis dieses Multimedia-Verzeichnisses beachten. Die Erhöhung dieser Zahl, wird die Anzahl der übergeordneten zu überwachenden Verzeichnisse dieses Pfades erhöhen.<br />Ein Beispiel: Wenn Sie innerhalb Ihrer GEDCOM-Datei auf ein Foto mit folgenden Pfad verlinken: C:\\Dokumente und Einstellungen\\BENUTZER\\Eigene Dateien\\Eigene Bilder\\Genealogie\\Nachname\\grossvater.jpg dann wird ein Wert von 0 diesen Pfad folgendermaßen interpretieren: ./media/grossvater.jpg. Ein Wert von 1 jedoch, wird diesen Pfad folgendermaßen interpretieren: ./media/Nachname/grossvater.jpg, usw. Den meisten Verwaltern von PhpGedView wird hier ein eingestellter Wert von 0 ausreichen. Es kann jedoch sein, dass einige Multimedia-Objekte den gleichen Namen haben können und sich somit gegenseitig aufheben. Dieses Wert ermöglicht Ihnen, Ihre Multimedia-Objekte zu verwalten, ohne einen Namenskonflikt zu erzeugen.";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES"]	= "Definierte Fotos in den Personenboxen anzeigen";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES_help"]	= "Falls Sie die Darstellung für Multimedia-Dateien auf Ihrer Website aktiviert haben, können Sie PhpGedView veranlassen, neben dem Namen der in den Boxen eines Stammbaumes oder Nachfahrenbaumes dargestellten Personen eine verkleinerte Darstellung eines Bildes (english Thumbnail) anzuzeigen.<br />Aktuell benutzt PhpGedView hierfür (highlighted image) das erste Multimedia-Objekt (Foto), das im GEDCOM-Datensatz der dargestellten Person vorkommt. Denjenigen, die mehrere Fotos als Multimedia-Objekte dem Datensatz einer Person hinzugefügt haben, sei empfohlen, die Liste der Multimedia-Objekte in einem Datensatz so anzuordnen, dass das darzustellende Foto an erster Stelle der Multimedia-Objekte der Person erscheint.<br />Für Benutzer von PAF 5.5 sei angemerkt, dass PhpGedView in der aktuellen Version die Definition des darzustellenden Fotos einer Person, die von PAF durch die Anweisung \"_PRIM\" definiert wird, unterstützt. Somit haben Sie innerhalb des Fensters \"Multimedia-Sammlung\" von PAF die Möglichkeit mehrere Fotos zu einer Person hinzuzuspeichern und durch die Anweisung \"festlegen\" das Foto zu bestimmen, das in der Stammbaum- oder Nachfahrenbaum-Darstellung und auch im jeweiligen persönlichen Datenblatt der jeweiligen Person angezeigt wird, zu bestimmen.<br />Lesen Sie im Abschnitt \"multimedia\" der Datei <a href=\"readme.txt\">readme.txt</a>, um mehr darüber zu erfahren, wie Sie Multimedia-Dateien in Ihre Website einfügen können.";
$pgv_lang["USE_THUMBS_MAIN"]	= "Thumbnails für Bild-Darstellung auf der Personen-Seite verwenden";
$pgv_lang["USE_THUMBS_MAIN_help"]	= "Je nachdem wie die Bilder gespeichert sind, kann es günstiger sein, die Thumbnails auf der Personen-Seite zu verwenden (anstelle der Bilder in Original-Größe). Wenn Ihre Bilder sehr groß sind, kann der Download entsprechend lange dauern und wenn die Thumbnails in guter Qualität vorliegen, können sie hier anstelle der großen Bilder verwendet werden. Bei \"Ja\" werden die Thumbnails benutzt, bei \"Nein\" die großen Bilder.";
$pgv_lang["ENABLE_CLIPPINGS_CART"]	= "Ausschnittssammelbehäter aktivieren";
$pgv_lang["ENABLE_CLIPPINGS_CART_help"]	= "Der Ausschnittssammelbehälter ermöglicht Besuchern Ihrer Website Datensätze zu ausgewählten Personen aus ihrer gesamten GEDCOM-Datenbank in eine neue GEDCOM-Datenbank zu exportieren, die diese dann als Datei auf ihren Computer übertragen (downloaden) können, um diese Datensätze in ihr eigenes Genealogie-Programm zu importieren.";
$pgv_lang["HIDE_GEDCOM_ERRORS"]		= "GEDCOM-Fehler verbergen";
$pgv_lang["HIDE_GEDCOM_ERRORS_help"]	= "Bei \"Ja\" werden alle Fehlermeldungen, die von PhpGedView verursacht werden, nicht dargestellt. Solche Fehler können dann entstehen, wenn PhpGedView eine Anweisung innerhalb der von Ihnen gewählten GEDCOM-Datenbank nicht interpretieren kann. PhpGedView wurde so programmiert, dass möglichst alle Anweisungen des GEDCOM 5.5 Standards unterstützt werden. Jedoch verwenden einige Genealogie-Programme ihre eigenen Anweisungen (TAGS). Schauen Sie in die Datei <a href=\"readme.txt\">readme.txt</a> um mehr hierüber zu erfahren.";
$pgv_lang["WORD_WRAPPED_NOTES"]		= "Leerzeichen an umgebrochene Notizinformationen anfügen";
$pgv_lang["WORD_WRAPPED_NOTES_help"]	= "Manche Genealogie-Programme kappen die Notizen zu Datensätzen am Ende von ganzen Wörtern, während andere an einer beliebigen Stelle des Textes einen Zeilenumbruch einfügen. Dies kann PhpGedView veranlassen, Wörter aneinander anzuhängen, ohne ein Leerzeichen zwischen diese zu setzen. Bei \"Ja\" wird PhpGedView bei der Ausgabe von Notizen ein Leerzeichen zwischen zwei Wörter einfügen, die durch einen Zeilenumbruch getrennt wurden.";
$pgv_lang["SHOW_CONTEXT_HELP"]		= "\"?\"-Hilfe-Links standardmäßig anzeigen";
$pgv_lang["SHOW_CONTEXT_HELP_help"]	= "Diese Option aktiviert Fragezeichen als Hilfe-Links auf den Seiten, auf die die Besucher klicken können, um einen Hilfe-Text für die jeweilige Funktion angezeigt zu bekommen.";
$pgv_lang["COMMON_NAMES_THRESHOLD"]	= "Mindestanzahl eines Nachnamens, der in der Liste der häufigsten Nachnamen erscheinen soll";
$pgv_lang["COMMON_NAMES_THRESHOLD_help"]	= "Dies ist die Anzahl, wie oft ein Nachname vorkommen muss, damit er in der Liste der häufigsten Nachnamen auf der Wilkommens-Seite genannt wird.";
$pgv_lang["COMMON_NAMES_ADD"]	= "Namen, die zu der Liste der häufigsten Nachnamen hinzugefügt werden sollen (durch Komma getrennt)";
$pgv_lang["COMMON_NAMES_ADD_help"]	= "Wenn ein Name nicht genügend oft vorkommt, erscheint er nicht in der Liste der häufigsten Nachnamen. Hier können solche Namen manuell zur Liste hinzufügen. Wenn Sie mehrere Namen angeben, trennen Sie diese jeweils durch ein Komma. Groß- und Kleinschreibung bitte beachten.";
$pgv_lang["COMMON_NAMES_REMOVE"]	= "Namen, die aus der Liste der häufigsten Nachnamen entfernt werden sollen (durch Komma getrennt)";
$pgv_lang["COMMON_NAMES_REMOVE_help"]	= "Wenn Sie einen Nachnamen aus der Liste der häufigsten Nachnamen entfernen möchten, ohne den Grenzwert für die Anzahl des Vorkommens verändern zu wollen, können Sie den Namen hier eingeben. Wenn Sie mehrere Namen angeben, trennen Sie diese jeweils durch ein Komma. Groß- und Kleinschreibung bitte beachten.";
$pgv_lang["HOME_SITE_URL"]		= "URL der Hauptseite der WebSite";
$pgv_lang["HOME_SITE_URL_help"]		= "Eine URL die in den Header des gewählten Darstellungsthemas hinzugefügt wird, um eine Verknüpfung zur Starseite Ihrer Homepage zu erstellen.";
$pgv_lang["HOME_SITE_TEXT"]		= "Text für Hauptseite der WebSite";
$pgv_lang["HOME_SITE_TEXT_help"]	= "Textausgabe für die Verknüpfung, die zur Startseite Ihrer Homepage verweist.";
$pgv_lang["CONTACT_EMAIL"]		= "Ihre Kontakt-Emailadresse für genealogische Fragen";
$pgv_lang["CONTACT_EMAIL_help"]		= "Die E-Mail-Adresse die Ihre Besucher kontaktieren sollen, falls sie Fragen zu den genealogischen Daten auf Ihrer Website haben.";
$pgv_lang["CONTACT_METHOD"]		= "Kontakt Methode (genealogische Fragen)";
$pgv_lang["CONTACT_METHOD_help"]	= "Die Methode, mit der die Kontakt-Links für genealogische Fragen arbeiten. Mit \"E-Mail\" wird eine Verknüfung eingefügt, mit der eine gewöhnliche E-Mail versendet werden kann. Mit \"interne Nachrichten-Funktion\" wird der in PhpGedView integrierte Nachrichten-Transfer benutzt und es wird keine gewöhnliche E-Mail Versendet. Bei \"interne Nachrichten und E-Mail\" werden beide vorgenannten Methoden parallel genutzt.  Mit \"PhpGedView sendet E-Mails ohne sie zu speichern\" werden die Nachrichten über PhpGedView abgewickelt und als E-Mail gesendet, aber sie werden nicht intern gespeichert. Mit \"keine Nachrichten-Funktion\" wird die Möglichkeit, dass Besucher Ihnen Nachrichten von diesen Seiten aus senden, unterbunden.";
$pgv_lang["WEBMASTER_EMAIL"]		= "Email-Adresse des Webmasters";
$pgv_lang["WEBMASTER_EMAIL_help"]	= "Die E-Mail- Adresse die Ihre Besucher kontaktieren sollen, falls sie technische Fragen haben oder Fehler auf Ihrer Website finden und diese Ihnen mitteilen möchten.";
$pgv_lang["SUPPORT_METHOD"]		= "Support Kontakt Methode";
$pgv_lang["SUPPORT_METHOD_help"]	= "Die Methode, mit der die Kontakt-Links für Support-Fragen arbeiten. Mit \"E-Mail\" wird eine Verknüfung eingefügt, mit der eine gewöhnliche E-Mail versendet werden kann. Mit \"interne Nachrichten-Funktion\" wird der in PhpGedView integrierte Nachrichten-Transfer benutzt und es wird keine gewöhnliche E-Mail Versendet. Bei \"interne Nachrichten und E-Mail\" werden beide vorgenannten Methoden parallel genutzt. Mit \"PhpGedView sendet E-Mails ohne sie zu speichern\" werden die Nachrichten über PhpGedView abgewickelt und als E-Mail gesendet, aber sie werden nicht intern gespeichert. Mit \"keine Nachrichten-Funktion\" wird die Möglichkeit, dass Besucher Ihnen Nachrichten von diesen Seiten aus senden, unterbunden.";
$pgv_lang["FAVICON"]			= "Pfad und Dateiname der FavIcon-Grafik";
$pgv_lang["FAVICON_help"]		= "Ändern Sie diesen Wert, um auf die ICON-Grafik zu verweisen, die in der Liste der Favoriten/Lesezeichen derjenigen erscheinen, die ihre Website zur Liste ihrer Favoriten/Lesezeichen hinzufügen.";
$pgv_lang["THEME_DIR"]			= "Themen Verzeichnis";
$pgv_lang["THEME_DIR_help"]		= "Das Verzeichnis in dem Ihr gewünschtes Darstellungsthema für PhpGedView-Seiten abgelegt ist. Sie können ein beliebiges Standardthema, das mit PhpGedView geliefert wurde, so anpassen, dass Ihre Website ein einzigartiges Erscheinungsbild abgibt. Lesen Sie im Abschnitt \"customization\" der Datei <a href=\"readme.txt\">readme.txt</a>, um mehr darüber zu erfahren.";
$pgv_lang["TIME_LIMIT"]			= "PHP Zeitlimit";
$pgv_lang["TIME_LIMIT_help"]		= "Die maximale Dauer in Sekunden die Sie PhpGedView zur Beendigung eines Prozesses zur Vefügung stellen möchten. Die Standardeinstellung beträgt 60 Sekunden. Abhängig von der Größe Ihrer GEDCOM-Datenbank müssen Sie diese Zeit vielleicht erhöhen, falls Sie die Index-Dateien neu erstellen sollten. Setzen Sie diesen Wert auf 0, falls PhpGedView unendlich lange laufen soll.<br />VORSICHT: Sollten Sie diesen Wert auf 0 oder zu hoch ansetzen, könnte dies das \"HÄNGEN\" Ihrer Website auf einigen Systemen bewirken, bis das Script endgültig fertiggestellt ist. Das Setzen dieses Wertes auf 0 bedeutet, dass das Script nie beendet wird, bis der Administrator Ihres Servers den Prozess manuell löscht oder den Servernn, indem er einen Stammbaum für 1000 Generationen aufruft.<br /><br />Diese Einstellung definiert den Wert der Variable \$TIME_LIMIT in der Datei \"config.php\".";
$pgv_lang["PGV_SESSION_SAVE_PATH"]	= "Pfad für die Session-Speicherung";
$pgv_lang["PGV_SESSION_SAVE_PATH_help"]	= "Der Pfad zum Speichern der \"Session\"-Dateien. Auf einigen Hosts ist PHP nicht sorgfältig konfiguriert und die Sitzungs-Daten werden zwischen den Seiten-Aufrugen nicht gespeichert. Hier können Sie die Standard-Einstellung überschreiben um ein eigenes lokales Verzeichnis zu verwenden. Ein geeignetes Verzeichnis wäre ./index/, falls eine Änderung notwendig ist. Normalerweise bleibt dieses Feld leer und es wird ein Pfad verwendet, der in der php.ini-Datei eingetragen ist.<br /><br />Diese Einstellung verändert die Variable \$PGV_SESSION_SAVE_PATH in der Datei config.php.";
$pgv_lang["SERVER_URL"]			= "PhpGedView URL";
$pgv_lang["SERVER_URL_help"]		= "Wenn Sie https oder einen anderen Port benutzen, müssen Sie hier die URL eingeben, über die Ihr Server erreicht werden kann.<br /><br />Diese Einstellung verändert die Variable \$SERVER_URL in der Datei config.php.";
$pgv_lang["LOGIN_URL"]			= "Login URL";
$pgv_lang["LOGIN_URL_help"]		= "Die Login URL muss nur dann angegeben werden, wenn Sie zu einer anderen Seite umleiten möchten, wenn die Benutzer sich anmelden. Dies ist dann sinnvoll, wenn Sie beim Benutzer-Login z.B. von http auf https wechseln möchten. Geben Sie die vollständige URL zur login.php-Datei an (z.B. https://www.ihrserber.de/phpgedview/login.pgp).";
$pgv_lang["PGV_SESSION_TIME"]		= "Session Timeout";
$pgv_lang["PGV_SESSION_TIME_help"]	= "Die Zeit nach der man sich für eine PhpGedView-Sitzung erneut anmelden muss (login). Der Standard-Wert ist 2 Stunden.<br /><br />Diese Einstellung verändert die Variable \$PGV_SESSION_TIME in der Datei config.php.";
$pgv_lang["SHOW_STATS"]			= "Aufruf-Statistik anzeigen";
$pgv_lang["SHOW_STATS_help"]		= "Ablauf-Statistiken und Datenbank-Abfragen am unteren Seitenrand aller Seiten einblenden.";
$pgv_lang["SHOW_COUNTER"]		= "Besucher-Zähler anzeigen";
$pgv_lang["SHOW_COUNTER_help"]		= "Den Besucher-Zähler auf der Portalseite und auf anderen Seiten anzeigen.";
$pgv_lang["USE_REGISTRATION_MODULE"]	= "Besuchern erlauben eine Registrierung anzufordern";
$pgv_lang["USE_REGISTRATION_MODULE_help"]	= "Erlaubt den Benutzern, sich selbst für einen Benutzerzugang zu diesen Seiten zu registrieren. <br /><br />Der Benutzer wird eine E-Mail erhalten mit einem Code zur Bestätigung der Anmeldung.<br />Danach muss der Administrator diese Registrierung freischalten, bevor sie aktiv wird<br /><br />Diese Einstellung verändert die Variable \$USE_REGISTRATION_MODULE in der Datei config.php.";
$pgv_lang["ALLOW_USER_THEMES"]		= "Besuchern die Auswahl eines Themes erlauben";
$pgv_lang["ALLOW_USER_THEMES_help"]	= "Erlaubt den Benutzern eigene Themes auszuwählen.<br /><br />Diese Einstellung verändert die Variable \$ALLOW_USER_THEMES in der Datei config.php.";
$pgv_lang["PGV_SIMPLE_MAIL"] = "Einfache Mail-Header bei E-Mails verwenden";
$pgv_lang["PGV_SIMPLE_MAIL_help"] = "Normalerweise enthält der Mail-Header die E-Mail-Adresse und den Namen des Absenders. Einige Mailsysteme akzeptieren diese Angaben nicht. Setzen Sie diesen Wert auf 'JA', damit nur die E-Mail-Adresse verwendet wird.<br /><br />Diese Einstellung verändert die Variable \$PGV_SIMPLE_MAIL in der Datei config.php.";
$pgv_lang["CREATE_GENDEX"]		= "Gendex Files erstellen";
$pgv_lang["CREATE_GENDEX_help"]		= "PhpGedView kann Gendex files erstellen, wenn eine GEDCOM-Datei importiert wird. Diese werden dann im Index-Verzeichnis gespeichert.";
$pgv_lang["gedcom_title_help"]		= "Geben Sie eine Bezeichnung ein, die erscheint, wenn Besucher zwischen mehreren GEDCOM-Dateien auf Ihrer Seite wählen.";
$pgv_lang["LOGFILE_CREATE"]		= "Log-Dateien erzeugen";
$pgv_lang["LOGFILE_CREATE_help"]	= "Bestimmt, in welchem Rhythmus eine neue Log-Datei erzeugt wird.<br /><br />Diese Einstellung verändert die Variable \$LOGFILE_CREATE in der Datei config.php.";
$pgv_lang["PGV_MEMORY_LIMIT"]		= "Max. Speicher Begrenzung";
$pgv_lang["PGV_MEMORY_LIMIT_help"]	= "Stellt die maximale Menge an Arbeitsspeicher ein, die den PhpGedView Scripts zur Verfügung steht. Standardwert ist 16MB.  Viele Host haben diese Option in der PHP-Konfiguration deaktiviert, so dass eine Veränderung dieses Wertes möglicherweise keinen Einfluss hat.<br /><br />Diese Einstellung verändert die Variable \$PGV_MEMORY_LIMIT in der Datei config.php.";
$pgv_lang["PGV_STORE_MESSAGES"]		= "Erlauben Nachrichten online zu speichern";
$pgv_lang["PGV_STORE_MESSAGES_help"]	= "Stellt eine, ob Nachrichten, die über PhpGedView gesendet werden, in der Datenbank gespeichert werden. Bei 'Ja' können Benutzer ihre Nachrichten wiederfinden, wenn sie sich bei PGV anmelden. Bei 'Nein'  werden die Nachrichten nur per E-Mail verschickt.<br /><br />Diese Einstellung verändert die Variable \$PGV_STORE_MESSAGES in der Datei config.php file.";
$pgv_lang["ALLOW_THEME_DROPDOWN"]		= "Theme-Dropdown-Auswahl zum Wechseln von Themes anzeigen";
$pgv_lang["ALLOW_THEME_DROPDOWN_help"]	= "Gibt Benutzern die Möglichkeit, Ihr eigenes Theme zu wählen.<br />(falls im Theme implementiert) von einem Drop-Down-Menü<br />Erfordert, dass auch die Variable ALLOW_USER_THEMES auf \"ja\" gesetzt ust.<br />Diese Einstellung verändert die Variable \$ALLOW_THEME_DROPDOWN in der Datei config.php.";

$pgv_lang["META_AUTHOR"]		= "META Tag Autor";
$pgv_lang["META_AUTHOR_help"]	= "Der Wert für das META Tag Feld \"Autor\" im HTML-Seiten-Kopf. Lassen Sie dieses Feld leer, um den vollständigen Namen der GEDCOM-Kontaktperson zu verwenden.<br />Diese Einstellung verändert die Variable \$META_AUTHOR in der Datei config.php.";
$pgv_lang["META_AUTHOR_descr"]	= "Lassen Sie dieses Feld leer, um den vollständigen Namen der GEDCOM-Kontaktperson zu verwenden.";
$pgv_lang["META_PUBLISHER"]		= "META Tag Publisher";
$pgv_lang["META_PUBLISHER_help"]	= "Der Wert für das META Tag Feld \"Publisher\" im HTML-Seiten-Kopf. Lassen Sie dieses Feld leer, um den vollständigen Namen der GEDCOM-Kontaktperson zu verwenden.<br />Diese Einstellung verändert die Variable \$META_PUBLISHER in der Datei config.php.";
$pgv_lang["META_PUBLISHER_descr"]	= "Lassen Sie dieses Feld leer, um den vollständigen Namen der GEDCOM-Kontaktperson zu verwenden.";
$pgv_lang["META_COPYRIGHT"]		= "META Tag Copyright";
$pgv_lang["META_COPYRIGHT_help"]	= "Der Wert für das META Tag Feld \"Copyright\" im HTML-Seiten-Kopf. Lassen Sie dieses Feld leer, um den vollständigen Namen der GEDCOM-Kontaktperson zu verwenden.<br />Diese Einstellung verändert die Variable \$META_COPYRIGHT in der Datei config.php.";
$pgv_lang["META_COPYRIGHT_descr"]	= "Lassen Sie dieses Feld leer, um den vollständigen Namen der GEDCOM-Kontaktperson zu verwenden.";
$pgv_lang["META_DESCRIPTION"]		= "META Tag Description";
$pgv_lang["META_DESCRIPTION_help"]	= "Der Wert für das META Tag Feld \"description\" im HTML-Seiten-Kopf. Lassen Sie dieses Feld leer, um den Titel der aktuellen GEDCOM-Datei zu verwenden.<br />Diese Einstellung verändert die Variable \$META_DESCRIPTION in der Datei config.php.";
$pgv_lang["META_DESCRIPTION_descr"]	= "Lassen Sie dieses Feld leer, um den Titel der aktiven GEDCOM-Datei zu verwenden.";
$pgv_lang["META_PAGE_TOPIC"]		= "META Tag Page-Topic";
$pgv_lang["META_PAGE_TOPIC_help"]	= "Der Wert für das META Tag Feld \"Page-Topic\" im HTML-Seiten-Kopf. Lassen Sie dieses Feld leer, um den Titel der aktuellen GEDCOM-Datei zu verwenden.<br />Diese Einstellung verändert die Variable \$META_PAGE_TOPIC in der Datei config.php.";
$pgv_lang["META_PAGE_TOPIC_descr"]	= "Lassen Sie dieses Feld leer, um den Titel der aktiven GEDCOM-Datei zu verwenden.";
$pgv_lang["META_AUDIENCE"]		= "META Tag Audience";
$pgv_lang["META_AUDIENCE_help"]	= "Der Wert für das META Tag Feld \"Audience\" im HTML-Seiten-Kopf.<br />Diese Einstellung verändert die Variable \$META_AUDIENCE in der Datei config.php.";
$pgv_lang["META_PAGE_TYPE"]		= "META Tag Page Type";
$pgv_lang["META_PAGE_TYPE_help"]	= "Der Wert für das META Tag Feld \"Page-Type\" im HTML-Seiten-Kopf.<br />Diese Einstellung verändert die Variable \$META_PAGE_TYPE in der Datei config.php.";
$pgv_lang["META_ROBOTS"]		= "META Tag Robots";
$pgv_lang["META_ROBOTS_help"]	= "Der Wert für das META Tag Feld \"Robots\" im HTML-Seiten-Kopf. Viele Robots und Crawler missachten diesen Wert.<br />Diese Einstellung verändert die Variable \$META_ROBOTS in der Datei config.php.";
$pgv_lang["META_REVISIT"]		= "Gibt an, wie oft crawler die META Tags untersuchen sollen";
$pgv_lang["META_REVISIT_help"]	= "Der Wert für das META Tag Feld \"Revisit\" im HTML-Seiten-Kopf. Viele Crawler missachten diesen Wert.<br />Diese Einstellung verändert die Variable \$META_REVISIT in der Datei config.php.";
$pgv_lang["META_KEYWORDS"]		= "META Tag Keywords";
$pgv_lang["META_KEYWORDS_help"]	= "Der Wert für das META Tag Feld \"Keywords\" im HTML-Seiten-Kopf. Viele Suchmaschinen nutzen die Keyword-Meta-Tags zur Indizierung von Webseiten. Ihre Angabe hier wird ergänzt durch die Liste der häufigsten Nachnamen, so wie sie auf der Willkommens-Seite erscheint.<br />Diese Einstellung verändert die Variable \$META_KEYWORDS in der Datei config.php.";
$pgv_lang["META_KEYWORDS_descr"]	= "Ihre Eingabe hier wird ergänzt durch die Liste der häufigsten Nachnamen, so wie sie auf der Willkommens-Seite erscheint.";
$pgv_lang["META_TITLE"]		= "Zu 'TITLE'-Kennung im Kopfbereich hinzufügen";
$pgv_lang["META_TITLE_help"]	=	"Was Sie hier eingeben wird in der TITLE-Kennung (title-tag) hinter dem regulären Seitentitel und vor dem PhpGedView-Hinweis eingefügt.<br />Diese Einstellung verändert die Variable \$META_TITLE in der Datei config.php.";
$pgv_lang["RSS_FORMAT"]				= "RSS Format";

$pgv_lang["welcome_new"]		= "Willkommen auf Ihrer neuen PhpGedView-Website. Da sie diese Seite angezeigt bekommen, haben Sie PhpGedView auf Ihrem Webserver schon erfolgreich installiert und sind nun bereit, es nach Ihren Vorstellungen zu konfigurieren.<br />";
$pgv_lang["welcome_new_help"]	= "Dieses Hilfe-Fenster wird Ihnen bei der Konfiguration zur Seite stehen. Wenn Sie das Eingabe-Feld wechseln erscheint hier jeweils ein Hilfetext zu dem Feld, in dem sie die Eingabemarke befindet. Sie können das Fenster schließen; um es wieder zu öffnen klicken Sie auf das \"?\" neben einem Eingabefeld.";
$pgv_lang["review_readme"]	= "Sie sollten zunächst die Datei <a href=\"readme.txt\" target=\"_blank\">readme.txt</a> durchlesen, bevor Sie die Konfiguration von PhpGedView fortsetzen.<br /><br />";
$pgv_lang["return_editconfig"]		= "Sie können jederzeit diese Konfigurationsseite aufrufen, indem Sie auf der <b>Administrationsseite</b> auf <b>Konfiguration</b> klicken (oder im Browser die Seite editconfig.php aufrufen ).<br />";
$pgv_lang["return_editconfig_gedcom"]	= "Sie können zu dieser Konfiguration jederzeit zurückkehren, indem Sie auf den Link <b>Bearbeiten</b> in der Tabelle <b>Vorhandene GEDCOMs</b> auf der Seite <b>GEDCOM Administration</b> klicken, oder indem Sie in Ihrem Browser die Datei editconfig_gedcom.php aufrufen.<br />";
$pgv_lang["save_config"]	= "Konfiguration speichern";
$pgv_lang["download_here"]	= "Hier Klicken, um die Datei herunterzuladen.";
$pgv_lang["download_gedconf"]	= "GEDCOM Konfiguration herunterladen.";
$pgv_lang["not_writable"]	= "Die Konfiguration lässt sich nicht speichern. Mit dem Download-Button können Sie Ihre Einstellungen in eine Datei speichern, die Sie anschließend manuell hochladen müssen.";
$pgv_lang["download_file"]	= "Datei Download";
$pgv_lang["upload_to_index"]	= "Datei kann anschließend auch manuell in Ihr Index-Verzeichnis hochgeladen werden: ";

//-- edit privacy messages
$pgv_lang["edit_privacy"]			= "Konfiguration der Datenschutzdatei";
$pgv_lang["edit_privacy_title"]			= "Konfiguration der Datenschutzdatei";
$pgv_lang["PRIV_PUBLIC"]			= "Allen Besuchern zeigen";
$pgv_lang["PRIV_USER"]				= "Nur angemeldeten Besuchern zeigen";
$pgv_lang["PRIV_NONE"]				= "Nur Administratoren zeigen";
$pgv_lang["PRIV_HIDE"]				= "Auch vor Administratoren verbergen";
$pgv_lang["save_changed_settings"]		= "Änderungen speichern";
$pgv_lang["add_new_pp_setting"]			= "Neue Einstellung für eine Person hinzufügen";
$pgv_lang["add_new_up_setting"]			= "Neue Einstellung für einen Benutzer hinzufügen";
$pgv_lang["add_new_gf_setting"]			= "Neue globale Einstellung hinzufügen";
$pgv_lang["add_new_pf_setting"]			= "Neue Einstellung für Ereignisse hinzufügen";
$pgv_lang["add_new_pf_setting_indi"]		= "Neue Einstellung für Ereignisse von Personen hinzufügen";
$pgv_lang["add_new_pf_setting_source"]		= "Neue Einstellung für Ereignisse von Quellen hinzufügen";
$pgv_lang["privacy_indi_id"]			= "Personen-ID";
$pgv_lang["privacy_source_id"]			= "Quellen-ID";
$pgv_lang["privacy_indi_source"]		= "Person / Quelle";
$pgv_lang["privacy_indi"]			= "Person";
$pgv_lang["privacy_source"]			= "Quelle";
$pgv_lang["file_read_error"]			= "F E H L E R !!! Die Datenschutz-Datei konnte nicht gelesen werden!";
$pgv_lang["general_settings"]			= "Allgemeine Datenschutz-Einstellungen";
$pgv_lang["person_privacy_settings"]		= "Personen-Einstellungen";
$pgv_lang["edit_exist_person_privacy_settings"]	= "Vorhandene Einstellungen für Personen bearbeiten";
$pgv_lang["user_privacy_settings"]		= "Benutzer-Einstellungen";
$pgv_lang["edit_exist_user_privacy_settings"]	= "Vorhandene Einstellungen für Benutzer bearbeiten";
$pgv_lang["global_facts_settings"]		= "Globale Einstellungen";
$pgv_lang["edit_exist_global_facts_settings"]	= "Vorhandene globale Einstellungen bearbeiten";
$pgv_lang["person_facts_settings"]		= "Personen-Einstellungen";
$pgv_lang["edit_exist_person_facts_settings"]	= "Vorhandene Ereignis-Einstellungen bearbeiten";
$pgv_lang["general_privacy"]			= "Allgemeine Privatsphären Einstellungen";
$pgv_lang["general_privacy_help"]		= "<b>#pgv_lang[general_settings]#</b><br /> Diese Einstellungen sind die Grundeinstellungen für die jeweilige GEDCOM-Datei.<br />Prüfen Sie, ob Sie die richtige GEDCOM-Datei bearbeiten, den Namen finden Sie unter der Überschrift.<br /><br />Sie können also für jede GEDCOM-Datei (sofern Sie mehrere auf Ihrer Seite haben) eigene Einstellungen vornehmen.<br /><br />Sie können diese Grundeinstellungen überschreiben, indem Sie die anderen Bereiche auf der Seite \"#pgv_lang[edit_privacy_title]#\" benutzen.<br />#pgv_lang[more_config_help]#";
$pgv_lang["person_privacy"]				= "Privatsphären Einstellungen der Person";
$pgv_lang["person_privacy_help"]		= "<b>#pgv_lang[person_privacy_settings]#</b><br />Diese Einstellung ermöglicht dem Administrator, voreingestellte Datenschutz-Einstellungen für Personen aus der GEDCOM-Datenbank zu überschreiben.<br /><br />Wenn z.B. einer Person in der Datenbank ein Kind zugeordnet ist, das im Kleinkindalter verstarb, dann werden normalerweise die Daten dieses Kindes allen (auch nichteingetragenen) Besuchern der Website angezeigt, da es schon verstorben ist.<br />Aber die Daten der Eltern sind nicht öffentlich zugänglich, da diese noch leben.<br />Nun möchten Sie den Sterbe-Eintrag dieses Kindes nicht aus der Datenbank entfernen, jedoch alle Daten dieses Kindes unter Datenschutz stellen.<br /><br />Hat dieses Kind z.B. die ID 100, dann geben Sie auf dieser Seite zur Bearbeitung der Datenschutz-Einstellungen folgendes ein:<br /><br />Identifikationsnummer: I100<br />Wem zeigen: \"Nur angemeldeten Benutzern anzeigen\"<br /><br />Dann bekommen nur registrierte Besucher der Website, nach einem Login, die Daten dieses Kindes zu sehen.<br /><br />Dies funktioniert natürlich auch anders herum:<br /><br />Um alle Daten einer Person (ID 101), die z.B. nicht mehr lebt aber deren Sterbedaten unbekannt sind, dennoch für alle Benutzer sichtbar zu machen, bearbeiten Sie die Datenschutz-Einstellungen wie folgt:<br /><br />Identifikationsnummer: I101<br />Wem zeigen: \"Allen Besuchern anzeigen\"<br /><br />Dann bekommen ALLE Besucher der Website die Daten dieser Person zu sehen.<br /><br />Diese Einstellung verändert die Variablen \$person_privacy in der gewählten Datenschutz-Datei.";
$pgv_lang["user_privacy"]				= "Privatsphären Einstellungen des Benutzers";
$pgv_lang["user_privacy_help"]			= "<b>#pgv_lang[user_privacy_settings]#</b><br />Diese Einstellung ermöglicht dem Administrator, voreingestellte Datenschutz-Einstellungen zur Anzeige der Daten von Personen für ausgewählte registrierte Besucher zu verändern.<br /><br />Wenn z.B. ein registierter Benutzer mit dem Benutzernamen \"John\" nach seinem Login die Daten einer bestimmten Person (z.B. ID 100) nicht sehen können soll, dann geben Sie auf der Seite zur Bearbeitung der Datenschutz-Einstellungen folgendes ein:<br /><br />Benutzername: John<br />Identifikationsnummer: I100<br />Anzeigen?: \"Verbergen\"<br /><br />Dadurch erreichen Sie, dass alle Details der Person mit der ID 100 NUR vor den Augen des Besuchers \"John\" verborgen werden.<br /><br />Dies funktioniert natürlich auch anders herum:<br /><br />Um alle Daten einer Person (ID 101), die normalerweise verborgen blieben (Person lebt noch oder Verwandschaftsgrad zu gering), dennoch für Benutzer \"John\" sichtbar zu machen, bearbeiten Sie die Datenschutz-Einstellungen wie folgt:<br /><br />Benutzername: John<br />Identifikationsnummer: I101<br />Anzeigen?: \"Anzeigen\"<br /><br />Dann werden alle Details der Person mit der ID 101 dem Besucher \"John\" angezeigt.<br /><br />Diese Einstellung verändert die Variablen \$user_privacy in der gewählten Datenschutz-Datei.";
$pgv_lang["global_facts"]				= "Globale Einstellungen für Privatsphären Ereignisse";
$pgv_lang["global_facts_help"]			= "<b>#pgv_lang[global_facts_settings]#</b><br />Diese Einstellung ermöglicht dem Administrator, voreingestellte Datenschutz-Einstellungen zur Anzeige von Ereignissen GLOBAL zu verändern.<br /><br />Die Einstellung [\"Ereignis-Bezeichnung\"] legt fest, welches Ereignis angezeigt/unterdrückt werden soll.<br />Die Einstellung [\"Auswahl\"] legt fest, ob Sie das Ereignis selbst, oder zusätzlich gespeicherte Daten meinen.<br />Die Einstellung [\"Wem zeigen ?\"] legt fest, wem die Details des Ereignisses angezeigt werden.<br /><br />Diese Einstellungen sind hauptsächlich vorgesehen, um bestimmte Ereignisse lebender und verstorbener Personen aus der GEDCOM-Datenbank grundsätzlich zu verbergen.<br />Standardmäßig ist die Unterdrückung der SSN (Sozialversicherungsnummer-vor allem in den USA relevant) voreingestellt.<br />Falls Sie z.B. alle Eheschließungen innerhalb der GEDCOM-Datenbank vor nicht authentifizierten Besuchern verbergen möchten, könnten Sie folgende Eingaben auf der Seite zur Bearbeitung der Datenschutz-Einstellungen machen:<br /><br />Ereignis-Bezeichnung: (MARR) - Heirat<br />Auswahl: \"Ereignis zeigen\"<br />Wem zeigen?: \"Nur angemeldeten Besuchern zeigen\"<br /><br />Ereignis-Bezeichnung: (MARR) - Heirat<br />Auswahl: \"Ereignis-Details zeigen\"<br />Wem zeigen?: \"Nur angemeldeten Besuchern zeigen\"<br /><br />Dann werden alle Eheschließungen inklusive ihrer Details nur den Besuchern angezeigt, die authentifiziert (eingeloggt) sind.<br /><br />Unter \"global_facts\" können Sie - im Gegensatz zu den übrigen Einstellungen - bestimmte Ereignisse sogar vor dem Administrator verbergen. Dies dient dazu überflüssige Angaben komplett zu unterdrücken.<br /><br />Diese Einstellung verändert die Variablen \$global_facts in der gewählten Datenschutz-Datei.";
$pgv_lang["person_facts"]				= "Privatsphären Einstellungen für Personen Ereignisse";
$pgv_lang["person_facts_help"]			= "<b>#pgv_lang[person_facts_settings]#</b><br />Diese Einstellung ermöglicht dem Administrator, voreingestellte Datenschutz-Einstellungen zur Anzeige von personenbezogenen Ereignissen zu verändern.<br /><br />Das erste Element ist die ID der Person, das Zweite ist das Ereignis.<br />Die Einstellung [\"Auswahl\"] legt fest, ob Sie das Ereignis selbst, oder zusätzlich gespeicherte Daten meinen.<br />Die Einstellung [\"Wem zeigen ?\"] legt fest, wem das Ereignis angezeigt wird.<br /><br />Die \$person_facts-Einstellung funktioniert genauso, wie die \$global_facts-Einstellung nur mit dem Unterschied, dass Sie zusätzlich die ID-Nummer der Person aus der GEDCOM-Datenbank auswählen müssen, deren Ereignisse Sie verbergen oder zeigen möchten.<br />Das Eheschließungs-Ereignis (einschließlich Details) der Person mit der ID-Nummer 100 verbergen Sie z.B. vor nicht authentifizierten (nicht eingeloggten) Besuchern durch:<br /><br />Identifikationsnummer: I100<br />Ereignis-Bezeichnung: (MARR) - Heirat<br />Auswahl: \"Ereignis zeigen\"<br />Wem zeigen?: \"Nur angemeldeten Besuchern zeigen\"<br /><br />Identifikationsnummer: I100<br />Ereignis-Bezeichnung: (MARR) - Heirat<br />Auswahl: \"Ereignis-Details zeigen\"<br />Wem zeigen?: \"Nur angemeldeten Besuchern zeigen\"<br /><br />Diese Einstellung verändert die Variablen \$person_facts in der gewählten Datenschutz-Datei.";
$pgv_lang["accessible_by"]			= "Wem zeigen?";
$pgv_lang["hide"]				= "Verbergen";
$pgv_lang["show_question"]			= "Anzeigen?";
$pgv_lang["user_name"]				= "Benutzername";
$pgv_lang["name_of_fact"]			= "Ereignis-Bezeichnung";
$pgv_lang["choice"]				= "Auswahl";
$pgv_lang["fact_show"]				= "Ereignis zeigen";
$pgv_lang["fact_details"]			= "Ereignis-Details zeigen";
$pgv_lang["privacy_header"]			= "Datenschutz-Einstellungen bearbeiten in";
$pgv_lang["unable_to_find_privacy_indi"]	= "Zu folgender ID kann keine Person gefunden werden:";
$pgv_lang["save_and_import"]			= "Nach dem Speichern dieser GEDCOM Konfiguration müssen Sie die Daten importieren, indem  Sie auf den <strong>\"Diese GEDCOM-Datei importieren\"</strong> Button klicken oder über fogende Menüpunkte: <strong>Verwalten->GEDCOM Datei Management->GEDCOM Import</strong>";
$pgv_lang["SHOW_LIVING_NAMES"]			= "Namen lebender Personen anzeigen";
$pgv_lang["USE_RELATIONSHIP_PRIVACY"]		= "Verwandtschafts-Datenschutz einschalten";
$pgv_lang["MAX_RELATION_PATH_LENGTH"]		= "Max. Länge der Verwandtschaft";
$pgv_lang["CHECK_MARRIAGE_RELATIONS"]		= "Verwandtschaft anhand von Eheschließungen überprüfen";
$pgv_lang["SHOW_DEAD_PEOPLE"]			= "Verstorbene Personen anzeigen";
$pgv_lang["help_info"]				= "Hilfe erhalten Sie, wenn Sie auf das jeweilige rote Fragezeichen (?) hinter der Einstellungsbezeichnung klicken.";
$pgv_lang["SHOW_LIVING_NAMES_help"]		= "Namen lebender Personen anzeigen<br /><br />Mit dieser Einstellung können Sie definieren, wem die Namen lebender Personen angezeigt werden.<br />Üblicherweise sollte diese Variable die Einstellung \"Nur angemeldeten Benutzern zeigen\" haben. Dies dient dem Datenschutz lebender Personen, die in Ihrer GEDCOM-Datenbank enthalten sind, denn Sie können selber bestimmen, wem Sie den allgemeinen Zugriff auf Ihre Ahnenforschungsdaten geben.<br />Die Einstellung \"Nur Administratoren zeigen\" verhindert die Anzeige der Namen lebender Personen auch für angemeldete Besucher, die jedoch keinen Administratorenstatus haben.<br /><br />Diese Einstellung verändert die Variable \$SHOW_LIVING_NAMES in der gewählten Datenschutz-Datei.";
$pgv_lang["USE_RELATIONSHIP_PRIVACY_help"]	= "Verwandtschafts-Datenschutz einschalten.<br /><br />\"Nein\" bedeutet, dass alle authentifizierten Benutzer alle Daten lebender Personen zu sehen bekommen.<br /><br />\"Ja\" bedeutet, dass authentifizierte Benutzer nur die Daten lebender Personen zu sehen bekommen, mit denen sie verwandt sind.<br />Der Verwandtschaftsgrad wird mit der Einstellung \"Max. Länge der Verwandtschaft\" eingestellt.<br /><br />Diese Einstellung verändert die Variable \$USE_RELATIONSHIP_PRIVACY in der gewählten Datenschutz-Datei.";
$pgv_lang["MAX_RELATION_PATH_LENGTH_help"]	= "Maximalen Verwandtschaftsgrad einstellen<br /><br />Diese Einstellung verändert die Variable \$MAX_RELATION_PATH_LENGTH in der gewählten Datenschutz-Datei.<br /><br />Wenn '#pgv_lang[USE_RELATIONSHIP_PRIVACY]#' aktiv ist, können angemeldete Benutzer nur die Daten lebender Personen bis zu diesem Verwandschaftsgrad ansehen oder bearbeiten.";
$pgv_lang["CHECK_MARRIAGE_RELATIONS_help"]	= "Verwandtschaft anhand von Eheschließungen überprüfen<br /><br />Soll der Verwandtschaftsgrad auch durch Zurhilfenahme von Eheschließungsdaten geprüft werden?<br /><br />Diese Einstellung verändert die Variable \$CHECK_MARRIAGE_RELATIONS in der gewählten Datenschutz-Datei.";
$pgv_lang["SHOW_DEAD_PEOPLE_help"]		= "Verstorbene Personen anzeigen<br /><br />Setzt die Datenschutz-Einstellungen für alle verstorbenen Personen.";
$pgv_lang["select_privacyfile_button"]		= "Datenschutzdatei auswählen";
$pgv_lang["PRIVACY_BY_YEAR"]		= "Datenschutz mittels Alter eines Ereignisses begrenzen";
$pgv_lang["PRIVACY_BY_YEAR_help"]	= "Wenn Sie den Datenschutz mittels des Alters eines Ereignisses begrenzen, werden Details von Personen angezeigt oder verborgen in Abhängigkeit davon, wie alt die Person zum Zeitpunkt des Ereinisses war (unabhängig davon, ob die Person noch lebt oder inzwischen verstorben ist). Verwenden Sie diese Einstellung in Verbindung mit \"Alter, ab dem angenommen wird, dass eine Person verstorben ist\". Wenn Sie z.B. den Alters-Wert auf 100 einstellen und die eben genannte Option auf \"Ja\", werden alle Personen (lebend oder verstorben), die vor weniger als 100 Jahren geboren wurden, als privat behandelt. Personen, die vor weniger als 85 Jahren geheiratet haben und Personen, die vor weniger als 75 Jahren verstorben sind, werden ebenfalls als privat behandelt. Beachten Sie bitte, dass diese Option den Seitenaufbau etwas verlangsamt.<br /><br />Diese Einstellung verändert die Variable \$PRIVACY_BY_YEAR in der Datenschutzdatei.";
$pgv_lang["enable_disable_lang"]	= "Einstellungen für unterstützte Sprachen";
$pgv_lang["translator_tools"]	= "Übersetzungstool";

//-- language edit utility
$pgv_lang["edit_langdiff"]		= "Sprach-Dateien bearbeiten und konfigurieren";
$pgv_lang["bom_check"]		= "Sprach-Datei BOM-Test";
$pgv_lang["bom_check_help"]		= "Dieser Test untersucht die Sprach-Datei auf eine BOM (Byte Order Mark: Kennzeichnung von ANSI-Dateien, die aber den PHP-Interpreter stört). Gegebenenfalls wird die BOM entfernt.";
$pgv_lang["bom_not_found"]		= "Es wurde keine BOM gefunden.";
$pgv_lang["bom_found"]			= "BOM wurde gefunden in ";
$pgv_lang["edit_lang_utility"]		= "Bearbeitungsmodul für Sprach-Dateien";
$pgv_lang["edit_lang_utility_help"]	= "Dieses Modul dient zum Bearbeiten der Sprachdateien.<br />Es zeigt den Inhalt der englischen Original-Datei und den Inhalt der ausgewählten Sprachdatei an.<br />Durch einen Klick auf den Inhalt der ausgewählten Datei öffnet sich ein neues Fenster, in dem die Übersetzung geschrieben oder der vorhandene Text bearbeitet und anschließend gespeichert werden kann.";
$pgv_lang["edit_lang_utility_warning"]	= "ACHTUNG!<br /><br />Wenn Sie den Button >#close_window_without_refresh#< benutzen, werden Sie die Ihre Änderungen nicht sehen, es sei denn, Sie laden die Seite manuell neu. Außerdem kann die Sprachdatei zerstört werden, wenn Sie dann eine Nachricht hinzufügen, die noch nicht existiert hat, oder wenn Sie eine unmittelbar zuvor geänderte Nachricht erneut ändern!<br /><br />Dieser Button ist also nur für fortgeschrittene Anwender, die genau wissen, was sie tun.";
$pgv_lang["language_to_edit"]		= "Zu bearbeitende Sprache";
$pgv_lang["file_to_edit"]		= "Zu bearbeitende Sprachdatei";
$pgv_lang["check"]			= "Prüfen";
$pgv_lang["lang_save"]			= "Speichern";
$pgv_lang["contents"]			= "Inhalt";
$pgv_lang["listing"]			= "Eintragung";
$pgv_lang["no_content"]			= "kein Inhalt";
$pgv_lang["editlang"]			= "Bearbeite";
$pgv_lang["editlang_help"]		= "Sprachdatei bearbeiten";
$pgv_lang["cancel"]			= "Abbrechen";
$pgv_lang["savelang"]			= "speichern";
$pgv_lang["savelang_help"]		= "Änderung speichern";
$pgv_lang["original_message"]		= "Original Inhalt";
$pgv_lang["message_to_edit"]		= "Zu ändernder Inhalt";
$pgv_lang["changed_message"]		= "Geänderter Inhalt";
$pgv_lang["message_empty_warning"]	= "-&gt; Achtung!!! Diese Nachricht ist in der Datei [#LANGUAGE_FILE#] leer &lt;-";
$pgv_lang["language_to_export"]		= "Zu exportierende Sprache";
$pgv_lang["export_lang_utility"]	= "Exportmodul für Sprach-Dateien";
$pgv_lang["export"]			= "Exportieren";
$pgv_lang["export_lang_utility_help"]	= "Mit diesem Modul können Sie eine Sprache auswählen und auf den Export-Button klicken, um die Hilfetexte der gewählten 'configuration_help' Sprachdatei zwecks Erstellung einer Anleitung in Ihrer Sprache zu exportieren.";
$pgv_lang["export_ok"]			= "Die Hilfetexte wurden exportiert";
$pgv_lang["compare_lang_utility"]	= "Vergleichsmodul für Sprach-Dateien";
$pgv_lang["compare_lang_utility_help"]	= "Dieses Modul vergleicht zwei Sprachdateien und zeigt die Unterschiede an.<br /><br />Beachten Sie auch die Datei [<a href=\"languages/LANG_CHANGELOG.txt\" target=\"_blank\">LANG_CHANGELOG.txt</a>], bezüglich weiterer Änderungen.";
$pgv_lang["new_language"]		= "Referenz-Sprache";
$pgv_lang["old_language"]		= "Zweite Sprache";
$pgv_lang["compare"]			= "Vergleichen";
$pgv_lang["comparing"]			= "Die Sprach-Dateien werden verglichen";
$pgv_lang["additions"]			= "Ergänzungen";
$pgv_lang["no_additions"]		= "Keine Ergänzungen";
$pgv_lang["subtractions"]		= "Entfernte Teile";
$pgv_lang["no_subtractions"]		= "Keine entfernten Teile";
$pgv_lang["config_lang_utility"]	= "Konfiguration der unterstützten Sprachen";
$pgv_lang["config_lang_utility_help"]	= "Dieses Modul hilft Ihnen die Sprachen-spezifischen Einstellungen in PhpGedView vorzunehmen.<br />Bitte beachten: Wenn Sie die Grundeinstellungen für Sprachen in PhpGedView verändern, wird eine neue Datei (#INDEX_DIRECTORY#lang_settings.php) im #INDEX_DIRECTORY#-Verzeichnis erstellt.<br />Alle weiteren Änderungen werden in dieser Datei gespeichert und PhpGedView wird auch nur noch DIESE Datei verwenden.<br />Wenn Sie also Schwierigkeiten mit den Spracheinstellungen haben, so teilen Sie dem Support bitte auch unbedingt mit, wenn diese neue Datei in Ihrem #INDEX_DIRECTORY#-Verzeichnis existiert!";
$pgv_lang["active"]			= "Aktiviert";
$pgv_lang["active_help"]		= "Erlauben Sie den Besuchern, diese Sprache auszuwählen, sofern der Sprachwechsel generell erlaubt ist.";
$pgv_lang["edit_settings"]		= "Einstellungen bearbeiten";
$pgv_lang["lang_edit"]			= "Bearbeiten";
$pgv_lang["lang_language"]		= "Sprache";
$pgv_lang["export_filename"]		= "Name der Datei, welche die exportierten Daten enthält:";
$pgv_lang["lang_back"]			= "Zurück zum Hauptmenu, um die Sprach-Dateien zu bearbeiten und zu konfigurieren";
$pgv_lang["lang_back_admin"]		= "Zurück zum Verwaltungsmenü";
$pgv_lang["lang_back_manage_gedcoms"]	= "Zurück zum GEDCOM Management Menü";
$pgv_lang["lang_name_czech"]		= "Tschechisch";
$pgv_lang["lang_name_chinese"]		= "Chinesisch";
$pgv_lang["lang_name_danish"]		= "Dänisch";
$pgv_lang["lang_name_dutch"]		= "Holländisch";
$pgv_lang["lang_name_english"]		= "Englisch";
$pgv_lang["lang_name_finnish"]		= "Finnisch";
$pgv_lang["lang_name_french"]		= "Französisch";
$pgv_lang["lang_name_german"]		= "Deutsch";
$pgv_lang["lang_name_hebrew"]		= "Hebräisch";
$pgv_lang["lang_name_hungarian"]	= "Ungarisch";
$pgv_lang["lang_name_italian"]		= "Italienisch";
$pgv_lang["lang_name_norwegian"]	= "Norwegisch";
$pgv_lang["lang_name_polish"]		= "Polnisch";
$pgv_lang["lang_name_portuguese"]	= "Portugiesisch";
$pgv_lang["lang_name_portuguese-br"]	= "Portugiesisch (Brasilien)";
$pgv_lang["lang_name_russian"]		= "Russisch";
$pgv_lang["lang_name_spanish"]		= "Spanisch";
$pgv_lang["lang_name_spanish-ar"]	= "Spanisch (Latein-Amerika)";
$pgv_lang["lang_name_swedish"]		= "Schwedisch";
$pgv_lang["lang_name_turkish"]		= "Türkisch";
$pgv_lang["lang_name_greek"]		= "Griechisch";
$pgv_lang["lang_name_arabic"]		= "Arabisch";
$pgv_lang["lang_name_lithuanian"]	= "Litauisch";
$pgv_lang["lang_name_vietnamese"]	= "Vietnamesisch";
$pgv_lang["lang_new_language"]		= "Neue Sprache";
$pgv_lang["original_lang_name"]		= "Original-Name der Sprache auf #D_LANGNAME#";
$pgv_lang["original_lang_name_help"]	= "Wie heißt die Sprache in dieser Sprache ?<br /><br />Englisch heißt in Englisch: English<br />Deutsch heißt in Deutsch: Deutsch<br />Niederländisch heißt in Niederländisch: Nederlands<br />etc.";
$pgv_lang["lang_shortcut"]		= "Abkürzung für Sprachdateien";
$pgv_lang["lang_shortcut_help"]		= "Dieses Kürzel wird verwendet, um die Sprachdateien dieser Sprache in PhpGedView zu benennen.<br />Normalerweise ist dies der selbe Code, wie der erste unter 'Sprachen Kenncodes' genannte, der im nächsten Feld definiert werden kann.";
$pgv_lang["lang_langcode"]		= "Sprachen Kenncodes";
$pgv_lang["lang_langcode_help"]		= "Diese Codes ermöglichen es PhpGedView, die Spracheinstellung des Browsers zu erkennen, mit dem ein Besucher Ihre PhpGedView Seiten betrachtet. Die Codes müssen mit Semikolons ';' getrennt werden";
$pgv_lang["lang_filenames"]		= "Sprach-Datei";
$pgv_lang["lang_filename"]		= "Sprachdatei";
$pgv_lang["lang_filename_help"]		= "Name und Pfad der Datei mit den allgemeinen Übersetzungen.";
$pgv_lang["config_filename"]		= "Konfigurations-Sprachdatei";
$pgv_lang["config_filename_help"]	= "Name und Pfad der Datei mit den Übersetzungen für die Konfiguration.";
$pgv_lang["facts_filename"]		= "Ereignisdatei";
$pgv_lang["facts_filename_help"]	= "Name und Pfad der Datei mit den Übersetzungen für die GEDCOM-Ereignisse.";
$pgv_lang["help_filename"]		= "Dateiname der Hilfedatei";
$pgv_lang["help_filename_help"]		= "Name und PFad der Datei mit den Übersetzungen der Hilfe-Texte.";
$pgv_lang["flagsfile"]			= "Flaggendatei";
$pgv_lang["flagsfile_help"]		= "Name und Pfad der Bilddatei für die Nationalflagge der ausgewählten Sprache.";
$pgv_lang["text_direction"]		= "Schreibrichtung";
$pgv_lang["text_direction_help"]	= "Gibt an, in welcher Richtung der Text in der gewählten Sprache ausgegeben wird.<br /><br />Die Westlichen Sprachen nutzen normalerweise die Richung 'von links nach rechts'.<br />In Arabischen Sprachen oder z.B. Hebräisch wird aber 'von rechts nach links' geschrieben und gelesen.";
$pgv_lang["date_format"]			= "Datumsformat";
$pgv_lang["date_format_help"]		= "Dieses Feld definiert das Datumsformat für genealogische Angaben dieser Sprache.<br /><br />Folgende Variablen können genutzt werden:<br />D für Tag (day)<br />M für Monat (month)<br />Y für Jahr (year).<br /><br />Sie können die Reihenfolge dieser Variablen ändern und  Trennzeichen hinzufügen.<br /><br />Der Standardwert für Englisch ist 'D M Y', so dass folgendes Datum aus einer GEDCOM-Datei: 'DATE 20 Nov 1965', in PhpGedView als '20 November 1965' angezeigt wird.<br /><br />Für Deutsch hat dieses Feld den Wert 'D. M Y', so dass das gleiche Datum dann als '20. November 1965' angezeigt wird.<br /><br />Als weiteres Beispiel Ungarisch, wo das Datum mit 'Y. M D.' definiert ist und als '1965. November 20.' angezeigt wird. (angenommen \"November\" wäre der Name des 11. Monat in Ungarisch)<br />Ein weiteres Beispiel ist Finnisch, wo Daten mit 'D. M#ta# Y' definiert sind. Diese Definition bedeutet, dass alle Daten in Finnisch als 20. Novemberta 1965 angezeigt werden (sofern \"November\" der Name des 11. Monats in Finisch wäre).";
$pgv_lang["time_format"]		= "Uhrzeitformat";
$pgv_lang["time_format_help"]		= "Dieses Feld definiert das Uhrzeitformat, das in der ausgewählten Sprache benutzt wird.<br /><br />Variablen, die Sie in diesem Feld benutzen können:<br />a - Kleingeschrieben: Ante meridiem und Post meridiem (am oder pm)<br />A - Großgeschrieben: Ante meridiem und Post meridiem (AM oder PM)<br />B - Swatch-Internet-Zeit (000 bis 999)<br />c - ISO 8601 Datum (hinzugefügt in PHP 5) 2004-02-12T15:19:21+00:00<br />d - Tag des Monats, 2-stellig mit führender Null (01 bis 31)<br />D - Tag der Woche als mit drei Buchstaben (Mon bis Sun)<br />F - Monat als ganzes Wort, wie January oder March (January bis December)<br />g - 12-Stunden-Format, ohne führende Nullen (1 bis 12)<br />G - 24-Stunden-Format, ohne führende Nullen (0 bis 23)<br />h - 12-Stunden-Format, mit führenden Nullen (01 bis 12)<br />H - 24-Stunden-Format, mit führenden Nullen (00 bis 23)<br />i - Minuten mit führenden Nullen (00 bis 59)<br />I - (großes i) Fällt ein Datum in die Sommerzeit (1 bei Sommerzeit, ansonsten 0)<br />j - Tag des Monats ohne führende Nullen (1 bis 31)<br />l - (kleines 'L') Ausgeschriebener Tag der Woche (Sunday bis Saturday)<br />L - Schaltjahr oder nicht (1 für ein Schaltjahr, ansonsten 0)<br />m - Monat als Zahl, mit führenden Nullen (01 bis 12)<br />M - Monatsname mit drei Buchstaben (Jan bis Dec)<br />n - Monatszahl, ohne führende Nullen (1 bis 12)<br />O - Zeitunterschied zur Greenwich time (GMT) in Stunden (Beispiel: +0200)<br />r - RFC 2822 formatiertes Datum (Beispiel: Thu, 21 Dec 2000 16:01:07 +0200)<br />s - Sekunden, mit führenden Nullen (00 bis 59)<br />S - Anhang der englischen Aufzählung für einen Monatstag, zwei Zeichen (st, nd, rd oder th. Zur Verwendung mit j empfohlen)<br />t - Anzahl der Tage des angegebenen Monats (28 bis 31)<br />T - Zeitzoneneinstellung des Rechners (Beispiele: CEST, EST, MDT ...)<br />U - Sekunden seit Beginn der UNIX-Epoche - January 1 1970 00:00:00 GMT)<br />w - Numerischer Tag einer Woche (0 - für Sonntag bis 6 - für Samstag)<br />W - ISO-8601 Wochennummer des Jahres, die Woche beginnt am Montag (hinzugefügt in PHP 4.1.0) (Beispiel: 42 - die 42 Woche im Jahr)<br />Y - Vierstellige Jahreszahl (Beispiel: 1999 oder 2003)<br />y - Jahreszahl, zweistellig (Beispiele: 99 oder 03)<br />z - Der Tag eines Jahres (0 bis 365)<br />Z - Offset der Zeitzone in Sekunden. Der Offset für Zeitzone West nach UTC ist immer negativ und für Zeitzone Ost nach UTC immer positiv. (-43200 bis 43200)<br /><br />Sie können die Reihenfolge dieser Variablen ändern und auch Trennungszeichen einfügen.<br />Z.B. hat das Feld in der deutschen Sprache standardmäßig folgenden Inhalt: 'H:i:s' welches folgende Ausgabe erzeugt: '09:01:25'.<br />In Englisch is die Standard-Definition in diesem Feld: 'g:i:sa' welches folgende Ausgabe erzeugt: '9:01:25am'.";
$pgv_lang["week_start"]			= "1. Tag der Woche";
$pgv_lang["week_start_help"]		= "Der Tag der Woche, mit dem in diesem Sprachraum eine neue Woche beginnt. In vielen Sprachen beginnt die Woche Sonntags, aber in anderen auch am Montag oder an anderen Tagen.";
$pgv_lang["name_reverse"]		= "Nachname zuerst";
$pgv_lang["name_reverse_help"]		= "In einigen Sprachen wird üblicherweise der Nachname vor den Vornamen gestellt, währen er normalerweise hinten steht. Wählen Sie diese Option, um den Nachnamen zuerst anzuzeigen.";
$pgv_lang["ltr"]			= "Links nach rechts";
$pgv_lang["rtl"]			= "Rechts nach links";
$pgv_lang["file_does_not_exist"]	= "FEHLER! Diese Datei existiert nicht...";
$pgv_lang["alphabet_upper"]		= "Alphabet Großbuchstaben";
$pgv_lang["alphabet_upper_help"]	= "Großbuchstaben-Alphabet. Dieses Alphabet wird benutzt, um die groß geschriebenen Namen in den Namen-Listen von PhpGedView zu sortieren (in der gewählte Sprache).";
$pgv_lang["alphabet_lower"]		= "Alphabet Kleinbuchstaben";
$pgv_lang["alphabet_lower_help"]	= "Kleinbuchstaben-Alphabet. Dieses Alphabet wird benutzt, um die klein geschriebenen Namen in den Namen-Listen von PhpGedView zu sortieren (in der gewählte Sprache).";
$pgv_lang["lang_config_write_error"]	= "Fehler beim Versuch, die Spracheinstellungen in die Datei [language_settings.php] zu schreiben. Prüfen Sie die Zugriffsrechte und probieren Sie es erneut.";
$pgv_lang["lang_save_success"]		= "Die Änderungen für #PGV_LANG# wurden erfolgreich gespeichert.";
$pgv_lang["translation_forum"]		= "Link zum PhpGedView Übersetzungs-Forum bei SourceForge.net";
$pgv_lang["translation_forum_help"]	= "Dieser link öffnet ein neues Browserfenster, in dem Sie zum Übersetzungs-Forum von PhpGedView (http://sourceforge.net/forum/forum.php?forum_id=294245) geleitet werden, wo Probleme bezüglich der Übersetzung von PhpGedView besprochen werden können.";
$pgv_lang["system_time"]		= "Aktuelle System-Zeit:";
$pgv_lang["gedcom_not_imported"]	= "Diese GEDCOM-Datei wurde noch nicht importiert.";
$pgv_lang["lang_set_file_read_error"]	= "F E H L E R !!! Die Datei [language_settings.php] konnte nicht gelesen werden!";
$pgv_lang["add_new_language"]		= "Dateien und Einstellungen für eine neue Sprache hinzufügen";
$pgv_lang["add_new_language_help"]	= "Hiermit können Sie neue Sprachdateien (für eine bisher nicht unterstützte Sprache) zu PhpGedView hinzufügen.<br />Bitte füllen Sie alle erforderlichen Felder im folgenden Fenster aus.<br />Sobald diese neuen Dateien erstellt sind, können Sie die Texte für diese Sprache ändern.";
$pgv_lang["add_new_lang_button"]	= "Neue Sprache hinzufügen";
$pgv_lang["hide_translated"]		= "Übersetzte verstecken";
$pgv_lang["lang_file_write_error"]	= "F E H L E R !!!<br /><br />Die Änderungen können nicht in die gewählte Sprachdatei geschrieben werden!<br />Prüfen Sie die Schreibrechte für (#lang_filename#).";
$pgv_lang["no_open"]	= "F E H L E R !!!<br /><br />Die Datei #lang_filename# kann nicht geöffnet werden.";
$pgv_lang["never"]					= "Nie";
$pgv_lang["users_total"]			= "Gesamtanzahl der Benutzer";
$pgv_lang["users_admin"]			= "Verwalter der Seite";
$pgv_lang["users_unver"]			= "Durch Benutzer noch nicht bestätigt";
$pgv_lang["users_unver_admin"]		= "Durch Verwalter noch nicht bestätigt";
$pgv_lang["users_langs"]			= "Sprache des Benutzers";
$pgv_lang["warn_users"]				= "Verwarnte Benutzer";
$pgv_lang["users_gedadmin"]			= "GEDCOM Verwalter";
$pgv_lang["cleanup_users"]			= "Bereinigte Benutzer";
$pgv_lang["usr_no_cleanup"]			= "Nichts zum Bereinigen gefunden";
$pgv_lang["del_proceed"]			= "Weiter";
$pgv_lang["usr_deleted"]			= "Gelöschter Benutzer:";
$pgv_lang["configured_languages"]	= "Benutzte Sprachen";
$pgv_lang["message_to_all"]			= "Sende zu allen Benutzern eine Nachricht";
$pgv_lang["ip_address"]				= "IP Adresse";
$pgv_lang["date_time"]				= "Datum und Zeit";
$pgv_lang["message"]				= "Mitteilung";
$pgv_lang["searchtype"]				= "Art der Suche";
$pgv_lang["type"]					= "Typ";
$pgv_lang["query"]					= "Abfrage";

//-- User Migration Tool messages
$pgv_lang["um_header"] = "Benutzerdaten Migrations-Tool";
$pgv_lang["um_proceed"] = "Mit Export der Benutzerdaten fortfahren ?<br /><br />";
$pgv_lang["um_creating"] = "Erstellen";
$pgv_lang["um_sql_index1"] = "Dieses Tool erstellt die .dat-Dateien in Ihrem Index-Verzeichnis:";
$pgv_lang["um_sql_index2"] = "Wenn die Dateien erfolgreich erstellt wurden, können Sie in den Index-Modus wechseln, wobei alle Benutzer und deren Nachrichten, Lesezeichen, Neuigkeiten und MeinGedView-Ansichten erhalten bleiben.<br />Anmerkung: Wenn Sie in den Index-Modus wechseln, müssen Sie anschließend zuerst die GEDCOM-Datei(en) neu importieren.<br /><br />";
$pgv_lang["um_file_create_fail1"] = "Die neue Datei konnte nicht erstellt werden, weil eine Datei mit gleichem Namen bereits existiert:";
$pgv_lang["um_file_create_fail2"] = "Erstellen fehlgeschlagen";
$pgv_lang["um_file_create_fail3"] = "Prüfen Sie die Zugriffsrechte für dieses Verzeichnis.";
$pgv_lang["um_file_create_succ1"] = "Erstellen der neuen Datei abgeschlossen:";
$pgv_lang["um_file_not_created"] = "Datei wurde nicht erstellt.";
$pgv_lang["um_nomsg"] = "Es liegen keine Nachrichten vor.";
$pgv_lang["um_nofav"] = "Es sind keine Lesezeichen vorhanden.";
$pgv_lang["um_nonews"] = "Es liegen keine Neuigkeiten vor.";
$pgv_lang["um_noblocks"] = "Es sind keine Blöcke vorhanden.";
$pgv_lang["um_import"] = "Import";
$pgv_lang["um_export"] = "Export";
$pgv_lang["um_imp_users"] = "Importierte Benutzer";
$pgv_lang["um_imp_blocks"] = "Importierter Block";
$pgv_lang["um_imp_favorites"] = "Importierte Lesezeichen";
$pgv_lang["um_imp_messages"] = "Importierte Mitteilung";
$pgv_lang["um_imp_news"] = "Importierte Nachrichten";
$pgv_lang["um_imp_succ"] = "Import erfolgreich";
$pgv_lang["um_imp_fail"] = "Import gescheitert";
$pgv_lang["um_backup"] = "Backup";
$pgv_lang["um_bu_config"] = "PhpGedView Konfigurationsdatei";
$pgv_lang["um_bu_gedcoms"] = "GEDCOM Dateien";
$pgv_lang["um_mk_bu"] = "Erstelle Backup";
$pgv_lang["um_nofiles"] = "Keine Dateien für Backup gefunden.";
$pgv_lang["um_results"]		= "Ergebnis";
$pgv_lang["type_audio"] = "Audio";
$pgv_lang["type_book"] = "Buch";
$pgv_lang["type_card"] = "Karte";
$pgv_lang["type_electronic"] = "elektronisch";
$pgv_lang["type_fiche"] = "Fiche";
$pgv_lang["type_film"] = "Film";
$pgv_lang["type_magazine"] = "Zeitschrift";
$pgv_lang["type_manuscript"] = "Manuskript";
$pgv_lang["type_map"] = "Landkarte";
$pgv_lang["type_newspaper"] = "Zeitung";
$pgv_lang["type_photo"] = "Photo";
$pgv_lang["type_tombstone"] = "Grabstein";
$pgv_lang["type_video"] = "Video";
$pgv_lang["um_index_sql1"] = "Dieses Tool erstellt SQL-Abfragen in Ihrem Index-Verzeichnis:";
$pgv_lang["um_index_sql2"] = "Diese Dateien können als SQL-Befehle für Ihre Datenbank gestartet werden, nachdem Sie die SQL-Version von PhpGedView installiert oder gestartet haben.<br /><br />Wenn Sie zum SQL-Modus wechseln, müssen Sie anschließend die GEDCOM-Datei(en) erneut importieren.";
$pgv_lang["um_query_not_created"] = "Abfragen nicht erstellt.";
$pgv_lang["THUMBNAIL_WIDTH"]			= "Breite der erstellten Miniaturansicht";
$pgv_lang["SHOW_SOURCES"]			= "Zeige Quellen";
$pgv_lang["SPLIT_PLACES"]		= "Teile Orte im Bearbeitungsmodus";
$pgv_lang["UNDERLINE_NAME_QUOTES"]		= "Unterstreiche Namen zwischen Anführungszeichen";
$pgv_lang["SHOW_MARRIED_NAMES"]			= "Zeigt Ehenamen in der Personen Liste";
$pgv_lang["FAM_FACTS_ADD"] 			= "Familien Ereignis hinzufügen";
$pgv_lang["FAM_FACTS_UNIQUE"] 			= "Einzigartiges Familien Ereignis";
$pgv_lang["SOUR_FACTS_ADD"] 			= "Quellen Ereignis hinzufügen";
$pgv_lang["SOUR_FACTS_UNIQUE"] 			= "Einzigartiges Quellen Ereignis";
$pgv_lang["REPO_FACTS_ADD"] 			= "Archiv Ereignis hinzufügen";
$pgv_lang["REPO_FACTS_UNIQUE"] 			= "Einzigartiges Archiv Ereignis";
$pgv_lang["AUTO_GENERATE_THUMBS"]			= "Automatisch erstellte Miniaturansichten";
$pgv_lang["INDI_FACTS_ADD"] 			= "Personen Ereignis hinzufügen";
$pgv_lang["INDI_FACTS_UNIQUE"] 			= "Einzigartiges Personen Ereignis";
$pgv_lang["DBPERSIST"]					= "Benutze konstante Datenbank Verbindung";

?>