<?php
/**
 * Unit test class for DocCommentSniff.
 *
 * PHP version 5
 *
 * @category  PHP
 * @package   PHP_CodeSniffer
 * @author    Greg Sherwood <gsherwood@squiz.net>
 * @copyright 2006-2012 Squiz Pty Ltd (ABN 77 084 670 600)
 * @license   https://github.com/squizlabs/PHP_CodeSniffer/blob/master/licence.txt BSD Licence
 * @link      http://pear.php.net/package/PHP_CodeSniffer
 */

/**
 * Unit test class for DocCommentSniff.
 *
 * @category  PHP
 * @package   PHP_CodeSniffer
 * @author    Greg Sherwood <gsherwood@squiz.net>
 * @copyright 2006-2012 Squiz Pty Ltd (ABN 77 084 670 600)
 * @license   https://github.com/squizlabs/PHP_CodeSniffer/blob/master/licence.txt BSD Licence
 * @version   Release: 2.7.1
 * @link      http://pear.php.net/package/PHP_CodeSniffer
 */
class Generic_Tests_Commenting_DocCommentUnitTest extends AbstractSniffUnitTest
{


    /**
     * Returns the lines where errors should occur.
     *
     * The key of the array should represent the line number and the value
     * should represent the number of errors that should occur on that line.
     *
     * @return array(int => int)
     */
    public function getErrorList()
    {
        return array(
                14  => 1,
                16  => 1,
                18  => 1,
                23  => 1,
                26  => 1,
                30  => 1,
                32  => 1,
                38  => 2,
                40  => 1,
                41  => 1,
                51  => 1,
                54  => 1,
                58  => 1,
                60  => 2,
                67  => 1,
                69  => 2,
                80  => 1,
                81  => 2,
                88  => 1,
                91  => 1,
                95  => 1,
                156 => 1,
                158 => 1,
                170 => 3,
                171 => 3,
                179 => 1,
                183 => 1,
                184 => 1,
                185 => 2,
                186 => 1,
                187 => 2,
                191 => 1,
               );

    }//end getErrorList()


    /**
     * Returns the lines where warnings should occur.
     *
     * The key of the array should represent the line number and the value
     * should represent the number of warnings that should occur on that line.
     *
     * @return array(int => int)
     */
    public function getWarningList()
    {
        return array();

    }//end getWarningList()


}//end class

?>
