//
// C++ Interface: debtagshelper
//
// Description: 
//
//
// Author: Benjamin Mesing <bensmail@gmx.net>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//

#ifndef __NUTIL_DEBTAGSHELPER_H_2005_09_24
#define __NUTIL_DEBTAGSHELPER_H_2005_09_24

#include <string>

#include <ept/debtags/tag.h>
#include <ept/apt/apt.h>

using namespace std;

namespace ept {
	namespace debtags {
		class Debtags;
		class Vocabulary;
	}
	namespace apt {
		class Apt;
	}
}

namespace NUtil
{

typedef std::string Package;
typedef ept::debtags::Tag Tag;
typedef ept::debtags::Debtags Debtags;
typedef ept::debtags::Vocabulary Vocabulary;


/** Returns the names of all the packages from <em>packages</em>. */
inline std::set<string> packagesToStrings(const set<Package>& packages)
{
	/*
	std::set<string> result;
	for (set<Package>::const_iterator it = packages.begin(); it != packages.end(); ++it)
	{
		result.insert(*it);
	}
	return result;
	*/
	return packages;
}


/** Returns the names of all the tags from <em>tags</em>.
  *
  * Tag names are of the form facet::tagname.
  */
inline std::set<string> tagsToStrings(const set<Tag>& tags)
{
	std::set<string> result;
	for (set<Tag>::const_iterator it = tags.begin(); it != tags.end(); ++it)
	{
		result.insert(it->fullname());
	}
	return result;
}

/** Collects the tags from the given vocabulary 
  * which match the given names.
  *
  * ?Tag names must be given in the form facet::tagname? (verify this)
  */
std::set<Tag> stringsToTags(const set<string>& tags, const Vocabulary& vocabulary);

/** Returns the entity::Package with the given name.
  *
  * @param string the name of the target package
  * @param apt a reference to the apt-object
   */
inline Package getPackageByName(const string& package, const ept::apt::Apt& apt)
{
	return apt.validate(package);
}


}

#endif //  __NUTIL_DEBTAGSHELPER_H_2005_09_24
