//
// C++ Implementation: singleton
//
// Description: 
//
//
// Author: Benjamin Mesing <bensmail@gmx.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "aggregator.h"

#include <ept/apt/apt.h>
#include <ept/debtags/debtags.h>
#include <ept/textsearch/textsearch.h>

namespace ept {

Aggregator::Aggregator()
	: m_apt(0), m_debtags(0), m_textsearch()
{
	invalidate();
}
Aggregator::~Aggregator()
{
	if (m_debtags) delete m_debtags;
	if (m_apt) delete m_apt;
}
void Aggregator::invalidate()
{
	if (m_debtags) delete m_debtags;
	if (m_apt) delete m_apt;
	if (m_textsearch) delete m_textsearch;
	m_apt = new apt::Apt;
	m_debtags = new debtags::Debtags;
	m_textsearch = new textsearch::TextSearch;
}

ept::debtags::Vocabulary& Aggregator::vocabulary()
{
	return m_debtags->vocabulary();
}
const ept::debtags::Vocabulary& Aggregator::vocabulary() const
{
	return m_debtags->vocabulary();
}

}
