#
# Script by Noam Rathaus
#
# From: "DarkBicho" <darkbicho@fastmail.fm>
# Subject: Cross-Site Scripting CuteNews
# Date: 28.6.2004 03:39

if(description)
{
 script_id(12291);
 script_bugtraq_id(10620, 10750);
 script_version("$Revision: 1.5 $");
 
 name["english"] = "CuteNews show_news.php XSS";

 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is using CuteNews - a news management system written in PHP.

There is a bug in this software which makes it vulnerable to cross site 
scripting attacks.

An attacker may use this bug to steal the credentials of the legitimate users
of this site.

Solution : Upgrade to the latest version of this software
Risk factor: Medium";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the presence of an XSS bug in CuteNews";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 script_copyright(english:"This script is Copyright (C) 2004 Noam Rathaus");
 family["english"] = "CGI abuses : XSS";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes", "cross_site_scripting.nasl", "http_version.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#


include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port))exit(0);
if (  get_kb_item(string("www/", port, "/generic_xss")) ) exit(0);


function check(loc)
{
 req = http_get(item:string(loc, "/cutenews/show_news.php?subaction=showcomments&id=%3Cscript%3Efoo%3C/script%3E&archive=&start_from=&ucat="),
 		port:port);
 r = http_keepalive_send_recv(port:port, data:req, bodyonly:1);
 if( r == NULL )exit(0);
 if(egrep(pattern:"<script>foo</script>", string:r))
 {
 	security_warning(port);
	exit(0);
 }
}

check(loc:"/");
foreach dir (make_list("/cutenews.1.3", cgi_dirs()))
{
 check(loc:dir);
}

