
/*
 * @(#)mimepurl.c 1.3 01/01/25
 * 
 * Copyright (c) Mikael Cam. All rights reserved.
 * 
 * This software is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.
 * 
 * You should have received a copy of the GNU Library General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "../../common/option.h"

static int _TRACE = 0;

#define MIMEPOUT   "MIMEPOUT"
#define MIMEPBOUND "MIMEPBOUND"
#define MIMEPRULEH "MIMEPRULEH"

#define bool       int
#define EOS        '\0'
#define False      0
#define True       1
#define DEFAULTB   "default"
#define FFLUSH     (void) fflush
#define NOB        "none"
#define MESSAGE    "Rfrence a un document distant :"
#define ACCESSTYPE "TYPE D'ACCES :"
#define SITE       "SITE :"
#define DIRECTORY  "REPERTOIRE :"
#define NAME       "NOM DU DOCUMENT :"

static char *specar[] = {
    "$", "\\$",
    "&", "\\&",
    "%", "\\%",
    "#", "\\#",
    "_", "\\_",
    "{", "\\{",
    "}", "\\}",
    "\\", "$\\backslash$",
    "|", "$|$",
    "<", "$<$",
    ">", "$>$",
    "~", "$\\sim$",
    "^", "$\\wedge$",
    NULL, NULL
};


static char *
text2latex(char *src_str)
{
    char *tgt_str;
    int i, k, length;
    bool trouve;
    char carcour;

    if (!src_str) {
        return(NULL);
    }
    tgt_str = (char *) malloc(sizeof(char) * 1024);
    tgt_str[0] = EOS;

    for (i = 0; i < strlen(src_str); i++) {
        k = 0;
        trouve = False;
        carcour = src_str[i];

        while ((specar[k]) && (!trouve)) {
            if (((char) *specar[k] == carcour) && (specar[k + 1])) {
                STRCAT(tgt_str, specar[k + 1]);
                trouve = True;
            }
            if (!trouve) {
                k += 2;
            }
        }
        if (!trouve) {
            length = strlen(tgt_str);
            tgt_str[length] = carcour;
            tgt_str[length + 1] = EOS;
        }
    }

    return(tgt_str);
}


int
main(int argc, char **argv)
{

    char *ERR[] =
    {
        "Impossible de lire la variable MIMEPOUT...\n",
        "Erreur lors de l'ouverture du fichier cible...\n"
    };

    char *mimepout, *boundary, *RULEH;
    FILE *mimepfp, *fp;

    if (_TRACE) {
        FPRINTF(stderr, "MIMEPURL execute!\n");
    }

    if (!(mimepout = getenv(MIMEPOUT))) {
        FPRINTF(stderr, ERR[0]);
        exit(1);
    }
    if (!(mimepfp = fopen(mimepout, "a"))) {
        FPRINTF(stderr, "%s", ERR[1]);
        exit(1);
    }
    FPRINTF(mimepfp, "%s\\newline\n", text2latex(MESSAGE));

    if (argc > 1) {
        FPRINTF(mimepfp, "%s %s\\newline\n", text2latex(ACCESSTYPE), 
                         text2latex(argv[1]));
    }
    if (argc > 2) {
        FPRINTF(mimepfp, "%s %s\\newline\n", text2latex(SITE), 
                         text2latex(argv[2]));
    }
    if (argc > 3) {
        FPRINTF(mimepfp, "%s %s\\newline\n", text2latex(DIRECTORY), 
                         text2latex(argv[3]));
    }
    if (argc > 4) {
        FPRINTF(mimepfp, "%s %s\\newline\n", text2latex(NAME), 
                         text2latex(argv[4]));
    }

    if ((boundary = getenv(MIMEPBOUND))) {
        if (strcmp(boundary, NOB)) {
            if (!strcmp(boundary, DEFAULTB)) {
                if ((RULEH = getenv(MIMEPRULEH))) {
                    FPRINTF(mimepfp, 
                           "\\centerline{\\rule{\\textwidth}{%spt}}\n", RULEH);
                } else if ((fp = fopen(boundary, "r"))) {
                    FCLOSE(fp);
                    FPRINTF(mimepfp, "\\centerline{\\includegraphics{%s}}\n", 
                            boundary);
                }
            }
        }
    }
    FFLUSH(mimepfp);
    FCLOSE(mimepfp);

    return(0);
}
