"""
Render to gtk from agg
"""
from __future__ import division
import os

import matplotlib
from matplotlib.figure import Figure
from backend_agg import FigureCanvasAgg
from backend_gtk import gtk, FigureManagerGTK, FigureCanvasGTK,\
     show, draw_if_interactive,\
     error_msg_gtk, NavigationToolbar, PIXELS_PER_INCH, backend_version, \
     NavigationToolbar2GTK
from _gtkagg import agg_to_gtk_drawable


DEBUG = False

class NavigationToolbar2GTKAgg(NavigationToolbar2GTK):
    def _get_canvas(self, fig):
        return FigureCanvasGTKAgg(fig)
    

class FigureManagerGTKAgg(FigureManagerGTK):
    def _get_toolbar(self, canvas):
        # must be inited after the window, drawingArea and figure
        # attrs are set
        if matplotlib.rcParams['toolbar']=='classic':
            toolbar = NavigationToolbar (canvas, self.window)
        elif matplotlib.rcParams['toolbar']=='toolbar2':
            toolbar = NavigationToolbar2GTKAgg (canvas, self.window)
        else:
            toolbar = None
        return toolbar
    
def new_figure_manager(num, *args, **kwargs):
    """
    Create a new figure manager instance
    """
    if DEBUG: print 'backend_gtkagg.new_figure_manager'
    FigureClass = kwargs.pop('FigureClass', Figure)
    thisFig = FigureClass(*args, **kwargs)
    canvas = FigureCanvasGTKAgg(thisFig)
    return FigureManagerGTKAgg(canvas, num)
    if DEBUG: print 'backend_gtkagg.new_figure_manager done'

class FigureCanvasGTKAgg(FigureCanvasGTK, FigureCanvasAgg):

    def configure_event(self, widget, event=None):

        if DEBUG: print 'FigureCanvasGTKAgg.configure_event'
        if widget.window is None:
            return 
        try:
            del self.renderer
        except AttributeError:
            pass
        w,h = widget.window.get_size()
        if w==1 or h==1: return # empty fig

        # compute desired figure size in inches
        dpival = self.figure.dpi.get()
        winch = w/dpival
        hinch = h/dpival
        self.figure.set_size_inches(winch, hinch)
        self._need_redraw = True
        self.resize_event()
        if DEBUG: print 'FigureCanvasGTKAgg.configure_event end'        
        return True
    
    def _render_figure(self, pixmap, width, height):
        if DEBUG: print 'FigureCanvasGTKAgg.render_figure'
        FigureCanvasAgg.draw(self)
        if DEBUG: print 'FigureCanvasGTKAgg.render_figure pixmap', pixmap
        #agg_to_gtk_drawable(pixmap, self.renderer._renderer, None)

        buf = self.buffer_rgba(0,0)
        ren = self.get_renderer()
        w = int(ren.width)
        h = int(ren.height)
        pixbuf = gtk.gdk.pixbuf_new_from_data(
            buf, gtk.gdk.COLORSPACE_RGB,  True, 8, w, h, w*4)
        pixmap.draw_pixbuf(pixmap.new_gc(), pixbuf, 0, 0, 0, 0, w, h,
                           gtk.gdk.RGB_DITHER_NONE, 0, 0)
        if DEBUG: print 'FigureCanvasGTKAgg.render_figure done'

    def blit(self, bbox=None):
        if DEBUG: print 'FigureCanvasGTKAgg.blit'
        if DEBUG: print 'FigureCanvasGTKAgg.blit', self._pixmap
        agg_to_gtk_drawable(self._pixmap, self.renderer._renderer, bbox)

        x, y, w, h = self.allocation

        self.window.draw_drawable (self.style.fg_gc[self.state], self._pixmap,
                                   0, 0, 0, 0, w, h)
        if DEBUG: print 'FigureCanvasGTKAgg.done'

    def print_figure(self, filename, dpi=None, facecolor='w', edgecolor='w',
                     orientation='portrait', **kwargs):
        if DEBUG: print 'FigureCanvasGTKAgg.print_figure'
        # delete the renderer to prevent improper blitting after print

        if dpi is None: dpi = matplotlib.rcParams['savefig.dpi']
        root, ext = os.path.splitext(filename)       
        ext = ext.lower()[1:]
        if ext == 'jpg':
            FigureCanvasGTK.print_figure(self, filename, dpi, facecolor, 
                                         edgecolor, orientation, **kwargs)
            
        else:
            agg = self.switch_backends(FigureCanvasAgg)
            try:
                agg.print_figure(filename, dpi, facecolor, edgecolor,
                                 orientation, **kwargs)
            except IOError, msg:
                error_msg_gtk('Failed to save\nError message: %s'%(msg,), self)

        self.figure.set_canvas(self)
        if DEBUG: print 'FigureCanvasGTKAgg.print_figure done'



"""\
Traceback (most recent call last):
  File "/home/titan/johnh/local/lib/python2.3/site-packages/matplotlib/backends/backend_gtk.py", line 304, in expose_event
    self._render_figure(self._pixmap, w, h)
  File "/home/titan/johnh/local/lib/python2.3/site-packages/matplotlib/backends/backend_gtkagg.py", line 77, in _render_figure
    pixbuf = gtk.gdk.pixbuf_new_from_data(
ValueError: data length (3156672) is less then required by the other parameters (3160608)
"""
