/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.reader;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import org.dita.dost.module.Content;
import org.dita.dost.module.ContentImpl;
import org.dita.dost.reader.AbstractReader;
import org.dita.dost.util.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class MapIndexReader
extends AbstractReader
implements ContentHandler,
LexicalHandler {
    private ArrayList matchList;
    private ArrayList ancestorList;
    private String last;
    private String first;
    private int level;
    private boolean match;
    private boolean needResolveEntity;
    private String topicFileName;
    private XMLReader reader;
    private String indexEntries;
    private HashMap map = new HashMap();
    private File inputFile;
    private String filePath = null;
    private String filePathName = null;

    public MapIndexReader() {
        this.ancestorList = new ArrayList();
        this.matchList = new ArrayList();
        try {
            if (System.getProperty("org.xml.sax.driver") == null) {
                System.setProperty("org.xml.sax.driver", "org.apache.xerces.parsers.SAXParser");
            }
            this.reader = XMLReaderFactory.createXMLReader();
            this.reader.setContentHandler(this);
            this.reader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public void setMatch(String match) {
        int index = 0;
        this.first = match.indexOf(47) != -1 ? match.substring(0, match.indexOf(47)) : match;
        while (index != -1) {
            int end = match.indexOf(47, index);
            if (end == -1) {
                this.matchList.add(match.substring(index));
                this.last = match.substring(index);
                index = end;
                continue;
            }
            this.matchList.add(match.substring(index, end));
            index = end + 1;
        }
    }

    private boolean checkMatch() {
        int matchSize = this.matchList.size();
        int ancestorSize = this.ancestorList.size();
        ListIterator matchIterator = this.matchList.listIterator();
        ListIterator ancestorIterator = this.ancestorList.listIterator(ancestorSize - matchSize);
        while (matchIterator.hasNext()) {
            String ancestor;
            String match = (String)matchIterator.next();
            if (match.equals(ancestor = (String)ancestorIterator.next())) continue;
            return false;
        }
        return true;
    }

    private boolean check(String str) {
        int end;
        if (str == null) {
            return false;
        }
        int start = str.indexOf(62);
        String temp = str.substring(start + 1, end = str.lastIndexOf(60));
        return temp.trim().length() != 0;
    }

    public void read(String filename) {
        if (!this.matchList.isEmpty()) {
            this.match = false;
            this.needResolveEntity = true;
            this.inputFile = new File(filename);
            this.filePath = this.inputFile.getParent();
            this.filePathName = this.inputFile.getPath();
            this.indexEntries = null;
            try {
                this.reader.parse(filename);
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        } else {
            System.out.println("Set the match list with match string first.");
        }
    }

    public Content getContent() {
        ContentImpl result = new ContentImpl();
        result.setCollection(this.map.entrySet());
        return result;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.match && this.needResolveEntity) {
            String temp = new String(ch, start, length);
            this.indexEntries = this.indexEntries != null ? this.indexEntries + temp : temp;
        }
    }

    public void endDocument() throws SAXException {
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.match) {
            this.indexEntries = this.indexEntries + "</";
            this.indexEntries = this.indexEntries + qName;
            this.indexEntries = this.indexEntries + ">";
            --this.level;
        }
        if (qName.equals(this.last) && this.level == 0 && this.match) {
            this.match = false;
        }
        if (!this.match) {
            this.ancestorList.remove(this.ancestorList.size() - 1);
        }
        if (qName.equals(this.first) && this.check(this.indexEntries) && this.topicFileName != null) {
            String origin = (String)this.map.get(this.topicFileName);
            if (origin != null) {
                this.map.put(this.topicFileName, origin + this.indexEntries);
            } else {
                this.map.put(this.topicFileName, this.indexEntries);
            }
            this.indexEntries = null;
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.match) {
            String temp = new String(ch, start, length);
            this.indexEntries = this.indexEntries != null ? this.indexEntries + temp : temp;
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startDocument() throws SAXException {
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (qName.equals(this.first)) {
            String hrefValue = atts.getValue("href");
            this.topicFileName = hrefValue != null && hrefValue.indexOf("://") == -1 ? StringUtils.resolveDirectory(this.filePath, atts.getValue("href")) : null;
        }
        if (!this.match) {
            this.ancestorList.add(qName);
            if (qName.equals(this.last) && this.checkMatch()) {
                this.match = true;
                this.level = 0;
            }
        }
        if (this.match) {
            this.indexEntries = this.indexEntries != null ? this.indexEntries + "<" : "<";
            this.indexEntries = this.indexEntries + qName;
            this.indexEntries = this.indexEntries + " ";
            int i = 0;
            while (i < atts.getLength()) {
                this.indexEntries = this.indexEntries + atts.getQName(i);
                this.indexEntries = this.indexEntries + "=\"";
                this.indexEntries = this.indexEntries + atts.getValue(i);
                this.indexEntries = this.indexEntries + "\" ";
                ++i;
            }
            this.indexEntries = this.indexEntries + ">";
            ++this.level;
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
    }

    public void endCDATA() throws SAXException {
        this.indexEntries = this.indexEntries != null ? this.indexEntries + "]]>" : "]]>";
    }

    public void endDTD() throws SAXException {
    }

    public void endEntity(String name) throws SAXException {
        if (!this.needResolveEntity) {
            this.needResolveEntity = true;
        }
    }

    public void startCDATA() throws SAXException {
        this.indexEntries = this.indexEntries != null ? this.indexEntries + "<![CDATA[" : "<![CDATA[";
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    public void startEntity(String name) throws SAXException {
        this.needResolveEntity = StringUtils.checkEntity(name);
        if (this.match && !this.needResolveEntity) {
            this.indexEntries = this.indexEntries != null ? this.indexEntries + StringUtils.getEntity(name) : StringUtils.getEntity(name);
        }
    }
}

