/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Path;

public class ANTLR
extends Task {
    private CommandlineJava commandline = new CommandlineJava();
    private File target;
    private File outputDirectory;
    private String superGrammar;
    private boolean debug;
    private boolean html;
    private boolean diagnostic;
    private boolean trace;
    private boolean traceParser;
    private boolean traceLexer;
    private boolean traceTreeWalker;
    private final boolean fork = true;
    private File workingdir = null;

    public ANTLR() {
        this.commandline.setVm("java");
        this.commandline.setClassname("antlr.Tool");
    }

    public void setTarget(File target) {
        this.log("Setting target to: " + target.toString(), 3);
        this.target = target;
    }

    public void setOutputdirectory(File outputDirectory) {
        this.log("Setting output directory to: " + outputDirectory.toString(), 3);
        this.outputDirectory = outputDirectory;
    }

    public void setGlib(String superGrammar) {
        this.superGrammar = superGrammar;
    }

    public void setDebug(boolean enable) {
        this.debug = enable;
    }

    public void setHtml(boolean enable) {
        this.html = enable;
    }

    public void setDiagnostic(boolean enable) {
        this.diagnostic = enable;
    }

    public void setTrace(boolean enable) {
        this.trace = enable;
    }

    public void setTraceParser(boolean enable) {
        this.traceParser = enable;
    }

    public void setTraceLexer(boolean enable) {
        this.traceLexer = enable;
    }

    public void setTraceTreeWalker(boolean enable) {
        this.traceTreeWalker = enable;
    }

    public void setFork(boolean s) {
    }

    public void setDir(File d) {
        this.workingdir = d;
    }

    public Path createClasspath() {
        return this.commandline.createClasspath(((ProjectComponent)this).project).createPath();
    }

    public Commandline.Argument createJvmarg() {
        return this.commandline.createVmArgument();
    }

    public void init() throws BuildException {
        this.addClasspathEntry("/antlr/Tool.class");
    }

    protected void addClasspathEntry(String resource) {
        URL url = ((Object)((Object)this)).getClass().getResource(resource);
        if (url != null) {
            String u = url.toString();
            if (u.startsWith("jar:file:")) {
                int pling = u.indexOf("!");
                String jarName = u.substring(9, pling);
                this.log("Implicitly adding " + jarName + " to classpath", 4);
                this.createClasspath().setLocation(new File(new File(jarName).getAbsolutePath()));
            } else if (u.startsWith("file:")) {
                int tail = u.indexOf(resource);
                String dirName = u.substring(5, tail);
                this.log("Implicitly adding " + dirName + " to classpath", 4);
                this.createClasspath().setLocation(new File(new File(dirName).getAbsolutePath()));
            } else {
                this.log("Don't know how to handle resource URL " + u, 4);
            }
        } else {
            this.log("Couldn't find " + resource, 4);
        }
    }

    public void execute() throws BuildException {
        this.validateAttributes();
        if (this.target.lastModified() > this.getGeneratedFile().lastModified()) {
            this.populateAttributes();
            this.commandline.createArgument().setValue(this.target.toString());
            this.log(this.commandline.describeCommand(), 3);
            int err = this.run(this.commandline.getCommandline());
            if (err == 1) {
                throw new BuildException("ANTLR returned: " + err, this.location);
            }
        } else {
            this.log("Skipped grammar file. Generated file is newer.", 3);
        }
    }

    private void populateAttributes() {
        this.commandline.createArgument().setValue("-o");
        this.commandline.createArgument().setValue(this.outputDirectory.toString());
        if (this.superGrammar != null) {
            this.commandline.createArgument().setValue("-glib");
            this.commandline.createArgument().setValue(this.superGrammar);
        }
        if (this.html) {
            this.commandline.createArgument().setValue("-html");
        }
        if (this.diagnostic) {
            this.commandline.createArgument().setValue("-diagnostic");
        }
        if (this.trace) {
            this.commandline.createArgument().setValue("-trace");
        }
        if (this.traceParser) {
            this.commandline.createArgument().setValue("-traceParser");
        }
        if (this.traceLexer) {
            this.commandline.createArgument().setValue("-traceLexer");
        }
        if (this.traceTreeWalker) {
            this.commandline.createArgument().setValue("-traceTreeWalker");
        }
    }

    private void validateAttributes() throws BuildException {
        if (this.target == null || !this.target.isFile()) {
            throw new BuildException("Invalid target: " + this.target);
        }
        if (this.superGrammar != null && !new File(this.superGrammar).isFile()) {
            throw new BuildException("Invalid super grammar file: " + this.superGrammar);
        }
        if (this.outputDirectory == null) {
            String fileName = this.target.toString();
            this.setOutputdirectory(new File(this.target.getParent()));
        }
        if (!this.outputDirectory.isDirectory()) {
            throw new BuildException("Invalid output directory: " + this.outputDirectory);
        }
    }

    /*
     * WARNING - void declaration
     */
    private File getGeneratedFile() throws BuildException {
        String generatedFileName = null;
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(this.target));
            while ((line = in.readLine()) != null) {
                void var3_4;
                int extendsIndex = var3_4.indexOf(" extends ");
                if (!var3_4.startsWith("class ") || extendsIndex <= -1) continue;
                generatedFileName = var3_4.substring(6, extendsIndex).trim();
                break;
            }
            in.close();
        }
        catch (Exception e) {
            throw new BuildException("Unable to determine generated class", (Throwable)e);
        }
        if (generatedFileName == null) {
            throw new BuildException("Unable to determine generated class");
        }
        return new File(this.outputDirectory, generatedFileName + ".java");
    }

    private int run(String[] command) throws BuildException {
        Execute exe = new Execute((ExecuteStreamHandler)new LogStreamHandler((Task)this, 2, 1), null);
        exe.setAntRun(((ProjectComponent)this).project);
        if (this.workingdir != null) {
            exe.setWorkingDirectory(this.workingdir);
        }
        exe.setCommandline(command);
        try {
            return exe.execute();
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e, this.location);
        }
    }
}

