#
# ruby extconf.rb
#         --with-perl-enc-map[=/path/to/enc-map]
#         --with-xmltok-lib[=/path/to/xmltok/lib]
#         --with-xmltok-include[=/path/to/xmltok/include]
#         --with-xmlparse-lib[=/path/to/xmlparse/lib]
#         --with-xmlparse-include[=/path/to/xmlparse/include]
#
require 'mkmf'

cwd=`pwd`.chomp!

## Encoding maps may be stored in $perl_archlib/XML/Parser/Encodins/
#perl_archlib = '/usr/lib/perl5/site_perl/5.005/i586-linux'
#perl_archlib = '/usr/local/lib'
perl_archlib = `perl -e 'use Config; print $Config{"archlib"}'`
xml_enc_path = with_config("perl-enc-map")
if xml_enc_path && xml_enc_path == true
  xml_enc_path = perl_archlib + "/XML/Parser/Encodings"
end

##$CFLAGS="-I#{cwd}/expat/xmlparse -I#{cwd}/expat/xmltok" +
##  ' -DXML_ENC_PATH=getenv\(\"XML_ENC_PATH\"\)' +
##  " -DNEW_EXPAT"
$CFLAGS = "-I#{cwd}/expat/xmlparse -I#{cwd}/expat/xmltok"
$LDFLAGS = "-L#{cwd}/expat/xmlparse"
dir_config("xmltok")
dir_config("xmlparse")
if xml_enc_path
  $CFLAGS += " -DXML_ENC_PATH=\\\"#{xml_enc_path}\\\""
end

if have_header("xmlparse.h") || have_header("expat.h")
  if have_library("expat", "XML_ParserCreate") ||
      have_library("xmltok", "XML_ParserCreate")
    if have_func("XML_SetNotStandaloneHandler")
      $CFLAGS += " -DNEW_EXPAT"
    end
    if have_func("XML_SetParamEntityParsing")
      $CFLAGS += " -DXML_DTD"
    end
    if have_func("XML_SetExternalParsedEntityDeclHandler")
      $CFLAGS += " -DEXPAT_1_2"
    end
    have_func("XML_SetDoctypeDeclHandler")
    have_library("socket", "ntohl")
    create_makefile("xmlparser")
  end
end
