/*  xfce4
 *  Copyright (C) 2002 Olivier Fourdan (fourdan@xfce.org)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gdk/gdk.h>
#include <gtk/gtktogglebutton.h>

/* needed so --enable-debug=full doesn't fail */
#ifdef XFCE_DISABLE_DEPRECATED
#undef XFCE_DISABLE_DEPRECATED
#endif
#include "xfce_decortoggle.h"

#include "xfce_togglebutton.h"

/* Forward declarations */

static void xfce_togglebutton_class_init (XfceTogglebuttonClass * class);
static void xfce_togglebutton_init (XfceTogglebutton * togglebutton);
static void xfce_togglebutton_toggle (GtkWidget * widget,
				      XfceTogglebutton * togglebutton);

/* Local data */

static GtkWidgetClass *parent_class = NULL;

GtkType
xfce_togglebutton_get_type (void)
{
    static GtkType togglebutton_type = 0;

    if (!togglebutton_type)
    {
	static const GTypeInfo togglebutton_info = {
	    sizeof (XfceTogglebuttonClass),
	    NULL,		/* base_init */
	    NULL,		/* base_finalize */
	    (GClassInitFunc) xfce_togglebutton_class_init,
	    NULL,		/* class_finalize */
	    NULL,		/* class_data */
	    sizeof (XfceTogglebutton),
	    0,			/* n_preallocs */
	    (GInstanceInitFunc) xfce_togglebutton_init,
	    NULL		/* value_table */
	};

	togglebutton_type =
	    g_type_register_static (GTK_TYPE_TOGGLE_BUTTON,
				    "XfceTogglebutton", &togglebutton_info,
				    0);
    }

    return togglebutton_type;
}

static void
xfce_togglebutton_class_init (XfceTogglebuttonClass * class)
{
    GObjectClass *gobject_class = G_OBJECT_CLASS (class);
    GtkObjectClass *object_class;
    GtkWidgetClass *widget_class;

    object_class = (GtkObjectClass *) class;
    widget_class = (GtkWidgetClass *) class;
    gobject_class = G_OBJECT_CLASS (class);

    parent_class = gtk_type_class (gtk_toggle_button_get_type ());
}

static void
xfce_togglebutton_init (XfceTogglebutton * togglebutton)
{
    togglebutton->decortoggle = xfce_decortoggle_new (GTK_ARROW_LEFT);
    gtk_widget_show (togglebutton->decortoggle);
    gtk_container_add (GTK_CONTAINER (togglebutton),
		       togglebutton->decortoggle);
    g_signal_connect (G_OBJECT (togglebutton), "toggled",
		      G_CALLBACK (xfce_togglebutton_toggle), togglebutton);
}

GtkWidget *
xfce_togglebutton_new (GtkArrowType arrow_type)
{
    XfceTogglebutton *togglebutton;

    togglebutton = g_object_new (xfce_togglebutton_get_type (), NULL);
    xfce_decortoggle_set_arrow_type (XFCE_DECORTOGGLE
				     (togglebutton->decortoggle), arrow_type);
    return GTK_WIDGET (togglebutton);
}

static void
xfce_togglebutton_toggle (GtkWidget * widget, XfceTogglebutton * togglebutton)
{
    g_return_if_fail (togglebutton != NULL);
    g_return_if_fail (XFCE_IS_TOGGLEBUTTON (togglebutton));

    xfce_decortoggle_toggled (XFCE_DECORTOGGLE (togglebutton->decortoggle));
}

void
xfce_togglebutton_set_arrow_type (XfceTogglebutton * togglebutton,
				  GtkArrowType arrow_type)
{
    g_return_if_fail (togglebutton != NULL);
    g_return_if_fail (XFCE_IS_TOGGLEBUTTON (togglebutton));

    xfce_decortoggle_set_arrow_type (XFCE_DECORTOGGLE
				     (togglebutton->decortoggle), arrow_type);
}

GtkArrowType
xfce_togglebutton_get_arrow_type (XfceTogglebutton * togglebutton)
{
    g_return_val_if_fail (togglebutton != NULL, GTK_ARROW_LEFT);
    g_return_val_if_fail (XFCE_IS_TOGGLEBUTTON (togglebutton),
			  GTK_ARROW_LEFT);

    return
	xfce_decortoggle_get_arrow_type (XFCE_DECORTOGGLE
					 (togglebutton->decortoggle));
}
