/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*- */
/* libwpd
 * Copyright (C) 2003 William Lachance (wrlach@gmail.com)
 * Copyright (C) 2003 Marc Maurer (uwog@uwog.net)
 * Copyright (C) 2005-2007 Fridrich Strba (fridrich.strba@bluewin.ch)
 * Copyright (C) 2007 Novell, Inc. (http://www.novell.com)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * For further information visit http://libwpd.sourceforge.net
 */

/* "This product is not manufactured, approved, or supported by
 * Corel Corporation or Corel Corporation Limited."
 */

#ifndef WP5FILESTRUCTURE_H
#define WP5FILESTRUCTURE_H

/* size of the fixed length functiongroups 0xC0 to 0xCF */
extern int WP5_FIXED_LENGTH_FUNCTION_GROUP_SIZE[16];

#define WP5_ATTRIBUTE_EXTRA_LARGE 0x00
#define WP5_ATTRIBUTE_VERY_LARGE 0x01
#define WP5_ATTRIBUTE_LARGE 0x02
#define WP5_ATTRIBUTE_SMALL_PRINT 0x03
#define WP5_ATTRIBUTE_FINE_PRINT 0x04
#define WP5_ATTRIBUTE_SUPERSCRIPT 0x05
#define WP5_ATTRIBUTE_SUBSCRIPT 0x06
#define WP5_ATTRIBUTE_OUTLINE 0x07
#define WP5_ATTRIBUTE_ITALICS 0x08
#define WP5_ATTRIBUTE_SHADOW 0x09
#define WP5_ATTRIBUTE_REDLINE 0x0A
#define WP5_ATTRIBUTE_DOUBLE_UNDERLINE 0xB
#define WP5_ATTRIBUTE_BOLD 0x0C
#define WP5_ATTRIBUTE_STRIKE_OUT 0x0D
#define WP5_ATTRIBUTE_UNDERLINE 0x0E
#define WP5_ATTRIBUTE_SMALL_CAPS 0x0F

/* Genearal data packet list */
#define WP50_LIST_FONTS_USED_PACKET 0x02
#define WP5_FONT_NAME_STRING_POOL_PACKET 0x07
#define WP5_GRAPHICS_INFORMATION_PACKET 0x08
#define WP51_LIST_FONTS_USED_PACKET 0x0F

/* Main function group list  */
#define WP5_TOP_EXTENDED_CHARACTER 0xC0
#define WP5_TOP_TAB_GROUP 0xC1
#define WP5_TOP_INDENT_GROUP 0xC2
#define WP5_TOP_ATTRIBUTE_ON 0xC3
#define WP5_TOP_ATTRIBUTE_OFF 0xC4
#define WP5_TOP_PAGE_FORMAT_GROUP 0xD0
#define WP5_TOP_FONT_GROUP 0xD1
#define WP5_TOP_DEFINITION_GROUP 0xD2
#define WP5_TOP_FORMAT_GROUP 0xD4
#define WP5_TOP_HEADER_FOOTER_GROUP 0xD5
#define WP5_TOP_FOOTNOTE_ENDNOTE_GROUP 0xD6
#define WP5_TOP_BOX_GROUP 0xDA
#define WP5_TOP_TABLE_EOL_GROUP 0xDC
#define WP5_TOP_TABLE_EOP_GROUP 0xDD

/* Page Format Group */
#define WP5_TOP_PAGE_FORMAT_GROUP_LEFT_RIGHT_MARGIN_SET 0x01
#define WP5_TOP_PAGE_FORMAT_GROUP_SPACING_SET 0x02
#define WP5_TOP_PAGE_FORMAT_GROUP_TAB_SET 0x04
#define WP5_TOP_PAGE_FORMAT_GROUP_TOP_BOTTOM_MARGIN_SET 0x05
#define WP5_TOP_PAGE_FORMAT_GROUP_JUSTIFICATION 0x06
#define WP5_TOP_PAGE_FORMAT_GROUP_SUPPRESS_PAGE_CHARACTERISTICS 0x07
#define WP5_TOP_PAGE_FORMAT_GROUP_FORM 0x0B

#define WP5_PAGE_GROUP_SUPPRESS_PAGE_NUMBER 0x01
#define WP5_PAGE_GROUP_PAGE_NUMBER_TO_BOTTOM 0x02
#define WP5_PAGE_GROUP_SUPPRESS_HEADER_A 0x04
#define WP5_PAGE_GROUP_SUPPRESS_HEADER_B 0x08
#define WP5_PAGE_GROUP_SUPPRESS_FOOTER_A 0x10
#define WP5_PAGE_GROUP_SUPPRESS_FOOTER_B 0x20
#define WP5_PAGE_GROUP_SUPPRESS_CODE_NOT_AT_TOP_OF_PAGE 0x80

/* Font Group */
#define WP5_TOP_FONT_GROUP_COLOR 0x00
#define WP5_TOP_FONT_GROUP_FONT_CHANGE 0x01

/* Header Footer Group */
#define WP5_HEADER_FOOTER_GROUP_HEADER_A 0x00
#define WP5_HEADER_FOOTER_GROUP_HEADER_B 0x01
#define WP5_HEADER_FOOTER_GROUP_FOOTER_A 0x02
#define WP5_HEADER_FOOTER_GROUP_FOOTER_B 0x03

#define WP5_HEADER_FOOTER_GROUP_ALL_BIT 0x01
#define WP5_HEADER_FOOTER_GROUP_ODD_BIT 0x02
#define WP5_HEADER_FOOTER_GROUP_EVEN_BIT 0x04

/* Format Group */
#define WP5_FORMAT_GROUP_END_OF_PAGE 0x00

/* Footnote Endnote Group */
#define WP5_FOOTNOTE_ENDNOTE_GROUP_FOOTNOTE 0x00
#define WP5_FOOTNOTE_ENDNOTE_GROUP_ENDNOTE 0x01

/* Box Group */
#define WP5_TOP_BOX_GROUP_FIGURE 0x00
#define WP5_TOP_BOX_GROUP_TABLE 0x01
#define WP5_TOP_BOX_GROUP_TEXT_BOX 0x02
#define WP5_TOP_BOX_GROUP_USER_DEFINED_BOX 0x03
#define WP5_TOP_BOX_GROUP_EQUATION 0x04
#define WP5_TOP_BOX_GROUP_HORIZONTAL_LINE 0x05
#define WP5_TOP_BOX_GROUP_VERTICAL_LINE 0x06

/* Definition Group */
#define WP5_TOP_DEFINITION_GROUP_DEFINE_TABLES 0x0B

/* Table EOL Group */
#define WP5_TABLE_EOL_GROUP_BEGINNING_OF_COLUMN_AT_EOL 0x00
#define WP5_TABLE_EOL_GROUP_BEGINNING_OF_ROW_AT_EOL 0x01
#define WP5_TABLE_EOL_GROUP_TABLE_OFF_AT_EOL 0x02

/* Table EOP Group */
#define WP5_TABLE_EOP_GROUP_BEGINNING_OF_ROW_AT_EOP 0x01
#define WP5_TABLE_EOP_GROUP_TABLE_OFF_AT_EOP 0x02
#define WP5_TABLE_EOP_GROUP_BEGINNING_OF_ROW_AT_HARD_EOP 0x03

/* Extended Character */
#define WP5_INTERNATIONAL_1_CHARACTER_SET 1
#define WP5_INTERNATIONAL_2_CHARACTER_SET 2
#define WP5_BOX_DRAWING_CHARACTER_SET 3
#define WP5_TYPOGRAPHIC_SYMBOL_CHARACTER_SET 4
#define WP5_ICONIC_SYMBOL_CHARACTER_SET 5
#define WP5_MATH_SCIENTIFIC_CHARACTER_SET 6
#define WP5_MATH_SCIENTIFIC_EXTENDED_CHARACTER_SET 7
#define WP5_GREEK_CHARACTER_SET 8
#define WP5_HEBREW_CHARACTER_SET 9
#define WP5_CYRILLIC_CHARACTER_SET 10
#define WP5_JAPANESE_CHARACTER_SET 11
#define WP5_ARABIC_CHARACTER_SET 13
#define WP5_ARABIC_SCRIPT_CHARACTER_SET 14

/* Tab Group */
#define WP5_TAB_GROUP_LEFT_TAB 0x00
#define WP5_TAB_GROUP_DECIMAL_TAB 0x08
#define WP5_TAB_GROUP_RIGHT_TAB 0x09
#define WP5_TAB_GROUP_FLUSH_RIGHT 0x0C
#define WP5_TAB_GROUP_BACK_TAB 0x10
#define WP5_TAB_GROUP_CENTER_ON_CURRENT_POSITION 0x18
#define WP5_TAB_GROUP_CENTER_TAB 0x19
#define WP5_TAB_GROUP_CENTER_ON_MARGINS 0x1C

/* Indent Group */
#define WP5_INDENT_GROUP_LEFT_INDENT 0x00
#define WP5_INDENT_GROUP_LEFT_RIGHT_INDENT 0x01


#endif /* WP5FILESTRUCTURE_H */
/* vim:set shiftwidth=4 softtabstop=4 noexpandtab: */
