#! /usr/bin/perl

#    Copyright (C) 1998, 1999 Tom Tromey

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2, or (at your option)
#    any later version.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
#    02111-1307, USA.

# gen-iso.pl - Convert an ISO 8859-X table into a C table we can use.
# Usage: perl gen-iso.pl NUMBER FILE
# E.g.: perl gen-iso.pl 2 /home/tromey/8859-2.TXT
# The tables are available from ftp.unicode.org.
# We are prohibited from redistributing them.

# I consider the output of this program to be unrestricted.  Use it as
# you will.

open (INPUT, "< $ARGV[1]") || exit 1;

# For now we fill in holes in the mapping with the identity mapping.
# FIXME: this is probably wrong.
for ($i = 127; $i >= 0; --$i)
{
    $output[$i] = 128 + $i;
}

$ok = 1;
while (<INPUT>)
{
    if (/Unicode version: +([0-9.]+)/)
    {
	$UNICODE_VERSIOn = $1;
    }
    elsif (/Table version: +([0-9.]+)/)
    {
	$TABLE_VERSION = $1;
    }

    s/\#.*$//;
    next if $_ eq '';

    @pair = split ("\t", $_);

    $isoc = hex (substr ($pair[0], 2));
    $unic = hex (substr ($pair[1], 2));

    if ($isoc < 0x80 && $isoc != $unic)
    {
	if ($ARGV[0] eq '6'
	    && $isoc >= 0x30
	    && $isoc <= 0x39)
	{
	    # A special case.
	    next;
	}
	print STDERR "Entry for $pair[0] in ISO 8859-$ARGV[0] violates 0x80 assumption\n";
	$ok = 0;
    }

    next if $isoc < 0x80;

    $output[$isoc - 0x80] = $unic;
}

exit 1 if ! $ok;

-d 'iso' || mkdir 'iso', 0755;
open (OUTPUT, "> iso/iso8859-$ARGV[0].h") || exit 1;

print OUTPUT "/* This file is automatically generated.  DO NOT EDIT.  */\n\n";
print OUTPUT "#ifndef ISO8859_$ARGV[0]\n";
print OUTPUT "#define ISO8859_$ARGV[0]\n";

print OUTPUT "\n";

if ($ARGV[0] eq '6')
{
    # In ISO 8859-6, the digits starting at 0x30 are mapped to the
    # digits starting at 0x0660.  We special-case this in iso8859.c.
    print OUTPUT "#define ISO6_DIGIT_ZERO 0x0660\n\n";
}

# FIXME: type
printf OUTPUT "static unsigned short iso8859_%d_table[128] = {\n  ", $ARGV[0];

$column = 2;
for ($i = 0; $i < 128; ++$i)
{
    print OUTPUT ", " if $i > 0;
    $text = sprintf ("0x%04x", $output[$i]);
    if (length ($text) + $column + 2 > 78)
    {
	print OUTPUT "\n  ";
	$column = 2;
    }
    print OUTPUT $text;
    $column += length ($text) + 2;
}
print OUTPUT "\n};\n\n";

print OUTPUT "#endif /* ISO8859_$ARGV[0] */\n";
