 program test_libticables;
{$APPTYPE CONSOLE}
uses
  sysutils,
  libTI_cables in 'libTI_cables.pas';
var
 lc: TLinkCable;
 cable: PLinkCable;
 err: Integer;
 data: Byte;
  max_cnt: Word;
  sum: Word;
  checksum: Word;
  i: Integer;
  start, stop: TDateTime;
  Hour, Min, Sec, MSec: Word;

type
  PPByte = ^PByte;

procedure print_lc_error(errnum: Integer);
var
  msg: PChar;
begin
  msg := 'No error -> bug !\n';

  ticable_get_error(errnum, msg);
  writeln('Link cable error: ', errnum, ':', msg, '\n');
end;

procedure ti92_screendump();
begin
{  lc.OpenPort();}
  sum := 0;
  writeln('Request screendump.\n');
  lc.put($09);
  lc.put($6D);
  lc.put($00);
  lc.put($00);

  err:=lc.Get(@data);
  writeln('Data: ', data);
  err:=lc.Get(@data);
  writeln('Data: ', data);
  err:=lc.Get(@data);
  writeln('Data: ', data);
  err:=lc.Get(@data);
  writeln('Data: ', data);
  Writeln('The calculator seems to reply OK.\n');

  lc.get(@data);
  lc.get(@data);
  lc.get(@data);
  max_cnt := data;
  lc.get(@data);
  max_cnt := max_cnt + (data shl 8);
  writeln(max_cnt, ' bytes to receive\n');
  writeln('Screendump in progress...\n');

  start := Time;
  for i:=0 to max_cnt do
  begin
    lc.get(@data);
    {writeln('data: ', data);}
    sum := sum + data;
  end;
  stop := Time;
  DecodeTime(stop-start, Hour, Min, Sec, MSec);
  Writeln('Time: ', Sec, 's', MSec);

  lc.get(@data);
  checksum :=data;
  lc.get(@data);
  checksum := checksum + (data shl 8);

  lc.put($09);
  lc.put($56);
  lc.put($00);
  lc.put($00);
  writeln('PC reply OK.\n');
  writeln('\n');
{  lc.ClosePort();}
end;

begin
  // Insrer le code utilisateur ici
  writeln('Salut !');
  writeln('libti_cables version: ', ticable_get_version);

  ticable_set_timeout(DFLT_TIMEOUT); // Setup the timeout
  ticable_set_delay(DFLT_DELAY);     // Setup the inter-bit delay
  ticable_set_io_address(LPT2);		// Setup the address
  ticable_set_io_device(TTY3);		// Setup the device
  ticable_set_cable(LINK_PAR, @lc);  // Setup the link cable type

  // Init port
  err := lc.InitPort();
  if(err > 0)
  then print_lc_error(err);

  // Open port
  err := lc.OpenPort();
  if( err > 0 )
  then print_lc_error(err);

  // Do a simple test with a TI92: check if calc is ready
  writeln('Chech if ready ...');
  err:=lc.Put($09);
    if( err > 0 )
  then print_lc_error(err);
  err:=lc.Put($68);
    if( err > 0 )
  then print_lc_error(err);
  err:=lc.Put($00);
    if( err > 0 )
  then print_lc_error(err);
  err:=lc.Put($00);
    if( err > 0 )
  then print_lc_error(err);

  err:=lc.Get(@data);
  writeln('Data: ', data);
  err:=lc.Get(@data);
  writeln('Data: ', data);
  err:=lc.Get(@data);
  writeln('Data: ', data);
  err:=lc.Get(@data);
  writeln('Data: ', data);
  Writeln('The calculator seems to reply OK.\n');

   ti92_screendump();

  // Close port
  err:=lc.ClosePort();
  if( err > 0 ) then print_lc_error(err);
  err:=lc.TermPort();
  if( err > 0 ) then print_lc_error(err);

  writeln('Waiting...');
  {while(true) do;}
end.