/*
 * libsysactivity
 * http://sourceforge.net/projects/libsysactivity/
 * Copyright (c) 2009, 2010 Carlos Olmedo Escobar <carlos.olmedo.e@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <sys/param.h>
#include <sys/sysctl.h>
#include <pthread.h>
#include <stdlib.h>
#include <errno.h>
#include <unistd.h>
#include <sys/swap.h>
#include <string.h>

#include "../OpenBSD/utils.h"

int sa_get_memory(struct sa_memory* dst) {
	if (dst == NULL)
		return EINVAL;

	size_t val;
	int mib[] = { CTL_HW, HW_PHYSMEM };
	size_t len = sizeof val;
	if (sysctl(mib, sizeof(mib) / sizeof(int), &val, &len, NULL, 0) == -1)
		return ENOSYS;
	dst->total = (uint64_t) val;

	mib[0] = CTL_VM;
	mib[1] = VM_UVMEXP2;
	struct uvmexp_sysctl uvmexp;
	len = sizeof uvmexp;
	if (sysctl(mib, sizeof(mib) / sizeof(int), &uvmexp, &len, NULL, 0) == -1)
		return ENOSYS;

	dst->free = (uint64_t) uvmexp.free * uvmexp.pagesize;
	dst->active = (uint64_t) uvmexp.active * uvmexp.pagesize;
	dst->inactive = (uint64_t) uvmexp.inactive * uvmexp.pagesize;
	dst->swap_total = (uint64_t) uvmexp.swpages * uvmexp.pagesize;
	dst->swap_free = (uint64_t) (uvmexp.swpages - uvmexp.swpginuse) * uvmexp.pagesize;
	dst->wired = (uint64_t) uvmexp.wired * uvmexp.pagesize;
	dst->executable = (uint64_t) uvmexp.execpages * uvmexp.pagesize;
	dst->files = (uint64_t) uvmexp.filepages * uvmexp.pagesize;
	return 0;
}
