/* ClasspathURLConnection.java
 * =========================================================================
 * This file is part of the SWIRL Library - http://swirl-lib.sourceforge.net
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 * 
 */

package be.ugent.caagt.swirl.protocol.classpath;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

/**
 * Represents a URL connection to a class path resource
 */
class ClasspathURLConnection extends URLConnection {
    
    //
    private final String path;

    @Override
    public String getContentType() {
        return guessContentTypeFromName( path );
    }
    
    public ClasspathURLConnection(URL u) throws MalformedURLException {
        super (u);
        if (u.getPort() >= 0) {
            throw new MalformedURLException("'classpath:'-URL should not use a port");
        }
        if (u.getHost() != null && u.getHost().length() > 0) {
            throw new MalformedURLException("'classpath:'-URL does not allow a 'host' part");
        }
        if (u.getQuery() != null) {
            throw new MalformedURLException("'classpath:'-URL does not allow a query string");
        }
        if (u.getUserInfo() != null) {
            throw new MalformedURLException("'classpath:'-URL does not allow a 'userinfo' part");
        }
        this.path = u.getPath();
    }

    @Override
    public void connect() {
        // do nothing
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return getClass().getResourceAsStream(path);
    }

}
