/*
  File autogenerated by gengetopt version 2.21
  generated with the following command:
  gengetopt --unamed-opts 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "getopt.h"

#include "cmdline.h"

const char *gengetopt_args_info_purpose = "prints to stdout the created OFX file based on the options you pass it. \ncurrently it will only create a statement request file.  you can POST this to \nan OFX server to request a statement from that financial institution for that \naccount.";

const char *gengetopt_args_info_usage = "Usage: " CMDLINE_PARSER_PACKAGE " [OPTIONS]... [FILES]...";

const char *gengetopt_args_info_description = "";

const char *gengetopt_args_info_help[] = {
  "  -h, --help                Print help and exit",
  "  -V, --version             Print version and exit",
  "      --fipid=STRING        FI partner identifier (looks up fid, org & url from \n                              partner server)",
  "      --fid=STRING          FI identifier",
  "      --org=STRING          FI org tag",
  "      --bank=STRING         IBAN bank identifier",
  "      --broker=STRING       Broker identifier",
  "      --user=STRING         User name",
  "      --pass=STRING         Password",
  "      --acct=STRING         Account ID",
  "      --type=INT            Account Type 1=checking 2=invest 3=ccard",
  "      --past=LONG           How far back to look from today (in days)",
  "      --url=STRING          Url to POST the data to (otherwise goes to stdout)",
  "      --trid=INT            Transaction id",
  "\n Group: command",
  "  -s, --statement-req       Request for a statement",
  "  -a, --accountinfo-req     Request for a list of accounts",
  "  -p, --payment-req         Request to make a payment",
  "  -i, --paymentinquiry-req  Request to inquire about the status of a payment",
  "  -b, --bank-list           List all known banks",
  "  -f, --bank-fipid          List all fipids for a given bank",
  "  -v, --bank-services       List supported services for a given fipid",
  "      --allsupport          List all banks which support online banking",
    0
};

static
void clear_given (struct gengetopt_args_info *args_info);
static
void clear_args (struct gengetopt_args_info *args_info);

static int
cmdline_parser_internal (int argc, char * const *argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error);


static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct gengetopt_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->fipid_given = 0 ;
  args_info->fid_given = 0 ;
  args_info->org_given = 0 ;
  args_info->bank_given = 0 ;
  args_info->broker_given = 0 ;
  args_info->user_given = 0 ;
  args_info->pass_given = 0 ;
  args_info->acct_given = 0 ;
  args_info->type_given = 0 ;
  args_info->past_given = 0 ;
  args_info->url_given = 0 ;
  args_info->trid_given = 0 ;
  args_info->statement_req_given = 0 ;
  args_info->accountinfo_req_given = 0 ;
  args_info->payment_req_given = 0 ;
  args_info->paymentinquiry_req_given = 0 ;
  args_info->bank_list_given = 0 ;
  args_info->bank_fipid_given = 0 ;
  args_info->bank_services_given = 0 ;
  args_info->allsupport_given = 0 ;
  args_info->command_group_counter = 0 ;
}

static
void clear_args (struct gengetopt_args_info *args_info)
{
  args_info->fipid_arg = NULL;
  args_info->fipid_orig = NULL;
  args_info->fid_arg = NULL;
  args_info->fid_orig = NULL;
  args_info->org_arg = NULL;
  args_info->org_orig = NULL;
  args_info->bank_arg = NULL;
  args_info->bank_orig = NULL;
  args_info->broker_arg = NULL;
  args_info->broker_orig = NULL;
  args_info->user_arg = NULL;
  args_info->user_orig = NULL;
  args_info->pass_arg = NULL;
  args_info->pass_orig = NULL;
  args_info->acct_arg = NULL;
  args_info->acct_orig = NULL;
  args_info->type_orig = NULL;
  args_info->past_orig = NULL;
  args_info->url_arg = NULL;
  args_info->url_orig = NULL;
  args_info->trid_orig = NULL;
  
}

static
void init_args_info(struct gengetopt_args_info *args_info)
{
  args_info->help_help = gengetopt_args_info_help[0] ;
  args_info->version_help = gengetopt_args_info_help[1] ;
  args_info->fipid_help = gengetopt_args_info_help[2] ;
  args_info->fid_help = gengetopt_args_info_help[3] ;
  args_info->org_help = gengetopt_args_info_help[4] ;
  args_info->bank_help = gengetopt_args_info_help[5] ;
  args_info->broker_help = gengetopt_args_info_help[6] ;
  args_info->user_help = gengetopt_args_info_help[7] ;
  args_info->pass_help = gengetopt_args_info_help[8] ;
  args_info->acct_help = gengetopt_args_info_help[9] ;
  args_info->type_help = gengetopt_args_info_help[10] ;
  args_info->past_help = gengetopt_args_info_help[11] ;
  args_info->url_help = gengetopt_args_info_help[12] ;
  args_info->trid_help = gengetopt_args_info_help[13] ;
  args_info->statement_req_help = gengetopt_args_info_help[14] ;
  args_info->accountinfo_req_help = gengetopt_args_info_help[15] ;
  args_info->payment_req_help = gengetopt_args_info_help[16] ;
  args_info->paymentinquiry_req_help = gengetopt_args_info_help[17] ;
  args_info->bank_list_help = gengetopt_args_info_help[18] ;
  args_info->bank_fipid_help = gengetopt_args_info_help[19] ;
  args_info->bank_services_help = gengetopt_args_info_help[20] ;
  args_info->allsupport_help = gengetopt_args_info_help[21] ;
  
}

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n", CMDLINE_PARSER_PACKAGE, CMDLINE_PARSER_VERSION);
}

void
cmdline_parser_print_help (void)
{
  int i = 0;
  cmdline_parser_print_version ();

  if (strlen(gengetopt_args_info_purpose) > 0)
    printf("\n%s\n", gengetopt_args_info_purpose);

  printf("\n%s\n\n", gengetopt_args_info_usage);

  if (strlen(gengetopt_args_info_description) > 0)
    printf("%s\n", gengetopt_args_info_description);

  while (gengetopt_args_info_help[i])
    printf("%s\n", gengetopt_args_info_help[i++]);
}

void
cmdline_parser_init (struct gengetopt_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);
  init_args_info (args_info);

  args_info->inputs = NULL;
  args_info->inputs_num = 0;
}

struct cmdline_parser_params *
cmdline_parser_params_init()
{
  struct cmdline_parser_params *params = 
    (struct cmdline_parser_params *)malloc(sizeof(struct cmdline_parser_params));

  if (params)
    { 
      params->override = 0;
      params->initialize = 0;
      params->check_required = 0;
      params->check_ambiguity = 0;
    }
    
  return params;
}

static void
cmdline_parser_release (struct gengetopt_args_info *args_info)
{
  
  unsigned int i;
  if (args_info->fipid_arg)
    {
      free (args_info->fipid_arg); /* free previous argument */
      args_info->fipid_arg = 0;
    }
  if (args_info->fipid_orig)
    {
      free (args_info->fipid_orig); /* free previous argument */
      args_info->fipid_orig = 0;
    }
  if (args_info->fid_arg)
    {
      free (args_info->fid_arg); /* free previous argument */
      args_info->fid_arg = 0;
    }
  if (args_info->fid_orig)
    {
      free (args_info->fid_orig); /* free previous argument */
      args_info->fid_orig = 0;
    }
  if (args_info->org_arg)
    {
      free (args_info->org_arg); /* free previous argument */
      args_info->org_arg = 0;
    }
  if (args_info->org_orig)
    {
      free (args_info->org_orig); /* free previous argument */
      args_info->org_orig = 0;
    }
  if (args_info->bank_arg)
    {
      free (args_info->bank_arg); /* free previous argument */
      args_info->bank_arg = 0;
    }
  if (args_info->bank_orig)
    {
      free (args_info->bank_orig); /* free previous argument */
      args_info->bank_orig = 0;
    }
  if (args_info->broker_arg)
    {
      free (args_info->broker_arg); /* free previous argument */
      args_info->broker_arg = 0;
    }
  if (args_info->broker_orig)
    {
      free (args_info->broker_orig); /* free previous argument */
      args_info->broker_orig = 0;
    }
  if (args_info->user_arg)
    {
      free (args_info->user_arg); /* free previous argument */
      args_info->user_arg = 0;
    }
  if (args_info->user_orig)
    {
      free (args_info->user_orig); /* free previous argument */
      args_info->user_orig = 0;
    }
  if (args_info->pass_arg)
    {
      free (args_info->pass_arg); /* free previous argument */
      args_info->pass_arg = 0;
    }
  if (args_info->pass_orig)
    {
      free (args_info->pass_orig); /* free previous argument */
      args_info->pass_orig = 0;
    }
  if (args_info->acct_arg)
    {
      free (args_info->acct_arg); /* free previous argument */
      args_info->acct_arg = 0;
    }
  if (args_info->acct_orig)
    {
      free (args_info->acct_orig); /* free previous argument */
      args_info->acct_orig = 0;
    }
  if (args_info->type_orig)
    {
      free (args_info->type_orig); /* free previous argument */
      args_info->type_orig = 0;
    }
  if (args_info->past_orig)
    {
      free (args_info->past_orig); /* free previous argument */
      args_info->past_orig = 0;
    }
  if (args_info->url_arg)
    {
      free (args_info->url_arg); /* free previous argument */
      args_info->url_arg = 0;
    }
  if (args_info->url_orig)
    {
      free (args_info->url_orig); /* free previous argument */
      args_info->url_orig = 0;
    }
  if (args_info->trid_orig)
    {
      free (args_info->trid_orig); /* free previous argument */
      args_info->trid_orig = 0;
    }
  
  for (i = 0; i < args_info->inputs_num; ++i)
    free (args_info->inputs [i]);
  
  if (args_info->inputs_num)
    free (args_info->inputs);
  
  clear_given (args_info);
}

int
cmdline_parser_file_save(const char *filename, struct gengetopt_args_info *args_info)
{
  FILE *outfile;
  int i = 0;

  outfile = fopen(filename, "w");

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot open file for writing: %s\n", CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  if (args_info->help_given) {
    fprintf(outfile, "%s\n", "help");
  }
  if (args_info->version_given) {
    fprintf(outfile, "%s\n", "version");
  }
  if (args_info->fipid_given) {
    if (args_info->fipid_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "fipid", args_info->fipid_orig);
    } else {
      fprintf(outfile, "%s\n", "fipid");
    }
  }
  if (args_info->fid_given) {
    if (args_info->fid_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "fid", args_info->fid_orig);
    } else {
      fprintf(outfile, "%s\n", "fid");
    }
  }
  if (args_info->org_given) {
    if (args_info->org_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "org", args_info->org_orig);
    } else {
      fprintf(outfile, "%s\n", "org");
    }
  }
  if (args_info->bank_given) {
    if (args_info->bank_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "bank", args_info->bank_orig);
    } else {
      fprintf(outfile, "%s\n", "bank");
    }
  }
  if (args_info->broker_given) {
    if (args_info->broker_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "broker", args_info->broker_orig);
    } else {
      fprintf(outfile, "%s\n", "broker");
    }
  }
  if (args_info->user_given) {
    if (args_info->user_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "user", args_info->user_orig);
    } else {
      fprintf(outfile, "%s\n", "user");
    }
  }
  if (args_info->pass_given) {
    if (args_info->pass_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "pass", args_info->pass_orig);
    } else {
      fprintf(outfile, "%s\n", "pass");
    }
  }
  if (args_info->acct_given) {
    if (args_info->acct_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "acct", args_info->acct_orig);
    } else {
      fprintf(outfile, "%s\n", "acct");
    }
  }
  if (args_info->type_given) {
    if (args_info->type_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "type", args_info->type_orig);
    } else {
      fprintf(outfile, "%s\n", "type");
    }
  }
  if (args_info->past_given) {
    if (args_info->past_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "past", args_info->past_orig);
    } else {
      fprintf(outfile, "%s\n", "past");
    }
  }
  if (args_info->url_given) {
    if (args_info->url_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "url", args_info->url_orig);
    } else {
      fprintf(outfile, "%s\n", "url");
    }
  }
  if (args_info->trid_given) {
    if (args_info->trid_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "trid", args_info->trid_orig);
    } else {
      fprintf(outfile, "%s\n", "trid");
    }
  }
  if (args_info->statement_req_given) {
    fprintf(outfile, "%s\n", "statement-req");
  }
  if (args_info->accountinfo_req_given) {
    fprintf(outfile, "%s\n", "accountinfo-req");
  }
  if (args_info->payment_req_given) {
    fprintf(outfile, "%s\n", "payment-req");
  }
  if (args_info->paymentinquiry_req_given) {
    fprintf(outfile, "%s\n", "paymentinquiry-req");
  }
  if (args_info->bank_list_given) {
    fprintf(outfile, "%s\n", "bank-list");
  }
  if (args_info->bank_fipid_given) {
    fprintf(outfile, "%s\n", "bank-fipid");
  }
  if (args_info->bank_services_given) {
    fprintf(outfile, "%s\n", "bank-services");
  }
  if (args_info->allsupport_given) {
    fprintf(outfile, "%s\n", "allsupport");
  }
  
  fclose (outfile);

  i = EXIT_SUCCESS;
  return i;
}

void
cmdline_parser_free (struct gengetopt_args_info *args_info)
{
  cmdline_parser_release (args_info);
}


/* gengetopt_strdup() */
/* strdup.c replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = NULL;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

static void
reset_group_command(struct gengetopt_args_info *args_info);

static void
reset_group_command(struct gengetopt_args_info *args_info)
{
  if (! args_info->command_group_counter)
    return;
  
  args_info->statement_req_given = 0 ;
  args_info->accountinfo_req_given = 0 ;
  args_info->payment_req_given = 0 ;
  args_info->paymentinquiry_req_given = 0 ;
  args_info->bank_list_given = 0 ;
  args_info->bank_fipid_given = 0 ;
  args_info->bank_services_given = 0 ;
  args_info->allsupport_given = 0 ;

  args_info->command_group_counter = 0;
}

int
cmdline_parser (int argc, char * const *argv, struct gengetopt_args_info *args_info)
{
  return cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
cmdline_parser_ext (int argc, char * const *argv, struct gengetopt_args_info *args_info,
                   struct cmdline_parser_params *params)
{
  int result;
  result = cmdline_parser_internal (argc, argv, args_info, params, NULL);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser2 (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required)
{
  int result;
  struct cmdline_parser_params params;
  
  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;

  result = cmdline_parser_internal (argc, argv, args_info, &params, NULL);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser_required (struct gengetopt_args_info *args_info, const char *prog_name)
{
  return EXIT_SUCCESS;
}

int
cmdline_parser_internal (int argc, char * const *argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  int error = 0;
  struct gengetopt_args_info local_args_info;
  
  int override;
  int initialize;
  int check_required;
  int check_ambiguity;
  
  override = params->override;
  initialize = params->initialize;
  check_required = params->check_required;
  check_ambiguity = params->check_ambiguity;

  if (initialize)
    cmdline_parser_init (args_info);

  cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 0;
  opterr = 1;
  optopt = '?';

  while (1)
    {
      int option_index = 0;
      char *stop_char;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "fipid",	1, NULL, 0 },
        { "fid",	1, NULL, 0 },
        { "org",	1, NULL, 0 },
        { "bank",	1, NULL, 0 },
        { "broker",	1, NULL, 0 },
        { "user",	1, NULL, 0 },
        { "pass",	1, NULL, 0 },
        { "acct",	1, NULL, 0 },
        { "type",	1, NULL, 0 },
        { "past",	1, NULL, 0 },
        { "url",	1, NULL, 0 },
        { "trid",	1, NULL, 0 },
        { "statement-req",	0, NULL, 's' },
        { "accountinfo-req",	0, NULL, 'a' },
        { "payment-req",	0, NULL, 'p' },
        { "paymentinquiry-req",	0, NULL, 'i' },
        { "bank-list",	0, NULL, 'b' },
        { "bank-fipid",	0, NULL, 'f' },
        { "bank-services",	0, NULL, 'v' },
        { "allsupport",	0, NULL, 0 },
        { NULL,	0, NULL, 0 }
      };

      stop_char = 0;
      c = getopt_long (argc, argv, "hVsapibfv", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          cmdline_parser_print_help ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          cmdline_parser_print_version ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 's':	/* Request for a statement.  */
          if (local_args_info.statement_req_given || (check_ambiguity && args_info->statement_req_given))
            {
              fprintf (stderr, "%s: `--statement-req' (`-s') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->statement_req_given && ! override)
            continue;
          local_args_info.statement_req_given = 1;
          args_info->statement_req_given = 1;
          if (args_info->command_group_counter && override)
            reset_group_command (args_info);
          args_info->command_group_counter += 1;
          break;

        case 'a':	/* Request for a list of accounts.  */
          if (local_args_info.accountinfo_req_given || (check_ambiguity && args_info->accountinfo_req_given))
            {
              fprintf (stderr, "%s: `--accountinfo-req' (`-a') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->accountinfo_req_given && ! override)
            continue;
          local_args_info.accountinfo_req_given = 1;
          args_info->accountinfo_req_given = 1;
          if (args_info->command_group_counter && override)
            reset_group_command (args_info);
          args_info->command_group_counter += 1;
          break;

        case 'p':	/* Request to make a payment.  */
          if (local_args_info.payment_req_given || (check_ambiguity && args_info->payment_req_given))
            {
              fprintf (stderr, "%s: `--payment-req' (`-p') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->payment_req_given && ! override)
            continue;
          local_args_info.payment_req_given = 1;
          args_info->payment_req_given = 1;
          if (args_info->command_group_counter && override)
            reset_group_command (args_info);
          args_info->command_group_counter += 1;
          break;

        case 'i':	/* Request to inquire about the status of a payment.  */
          if (local_args_info.paymentinquiry_req_given || (check_ambiguity && args_info->paymentinquiry_req_given))
            {
              fprintf (stderr, "%s: `--paymentinquiry-req' (`-i') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->paymentinquiry_req_given && ! override)
            continue;
          local_args_info.paymentinquiry_req_given = 1;
          args_info->paymentinquiry_req_given = 1;
          if (args_info->command_group_counter && override)
            reset_group_command (args_info);
          args_info->command_group_counter += 1;
          break;

        case 'b':	/* List all known banks.  */
          if (local_args_info.bank_list_given || (check_ambiguity && args_info->bank_list_given))
            {
              fprintf (stderr, "%s: `--bank-list' (`-b') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->bank_list_given && ! override)
            continue;
          local_args_info.bank_list_given = 1;
          args_info->bank_list_given = 1;
          if (args_info->command_group_counter && override)
            reset_group_command (args_info);
          args_info->command_group_counter += 1;
          break;

        case 'f':	/* List all fipids for a given bank.  */
          if (local_args_info.bank_fipid_given || (check_ambiguity && args_info->bank_fipid_given))
            {
              fprintf (stderr, "%s: `--bank-fipid' (`-f') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->bank_fipid_given && ! override)
            continue;
          local_args_info.bank_fipid_given = 1;
          args_info->bank_fipid_given = 1;
          if (args_info->command_group_counter && override)
            reset_group_command (args_info);
          args_info->command_group_counter += 1;
          break;

        case 'v':	/* List supported services for a given fipid.  */
          if (local_args_info.bank_services_given || (check_ambiguity && args_info->bank_services_given))
            {
              fprintf (stderr, "%s: `--bank-services' (`-v') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->bank_services_given && ! override)
            continue;
          local_args_info.bank_services_given = 1;
          args_info->bank_services_given = 1;
          if (args_info->command_group_counter && override)
            reset_group_command (args_info);
          args_info->command_group_counter += 1;
          break;


        case 0:	/* Long option with no short option */
          /* FI partner identifier (looks up fid, org & url from partner server).  */
          if (strcmp (long_options[option_index].name, "fipid") == 0)
          {
            if (local_args_info.fipid_given || (check_ambiguity && args_info->fipid_given))
              {
                fprintf (stderr, "%s: `--fipid' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->fipid_given && ! override)
              continue;
            local_args_info.fipid_given = 1;
            args_info->fipid_given = 1;
            if (args_info->fipid_arg)
              free (args_info->fipid_arg); /* free previous string */
            args_info->fipid_arg = gengetopt_strdup (optarg);
            if (args_info->fipid_orig)
              free (args_info->fipid_orig); /* free previous string */
            args_info->fipid_orig = gengetopt_strdup (optarg);
          }
          /* FI identifier.  */
          else if (strcmp (long_options[option_index].name, "fid") == 0)
          {
            if (local_args_info.fid_given || (check_ambiguity && args_info->fid_given))
              {
                fprintf (stderr, "%s: `--fid' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->fid_given && ! override)
              continue;
            local_args_info.fid_given = 1;
            args_info->fid_given = 1;
            if (args_info->fid_arg)
              free (args_info->fid_arg); /* free previous string */
            args_info->fid_arg = gengetopt_strdup (optarg);
            if (args_info->fid_orig)
              free (args_info->fid_orig); /* free previous string */
            args_info->fid_orig = gengetopt_strdup (optarg);
          }
          /* FI org tag.  */
          else if (strcmp (long_options[option_index].name, "org") == 0)
          {
            if (local_args_info.org_given || (check_ambiguity && args_info->org_given))
              {
                fprintf (stderr, "%s: `--org' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->org_given && ! override)
              continue;
            local_args_info.org_given = 1;
            args_info->org_given = 1;
            if (args_info->org_arg)
              free (args_info->org_arg); /* free previous string */
            args_info->org_arg = gengetopt_strdup (optarg);
            if (args_info->org_orig)
              free (args_info->org_orig); /* free previous string */
            args_info->org_orig = gengetopt_strdup (optarg);
          }
          /* IBAN bank identifier.  */
          else if (strcmp (long_options[option_index].name, "bank") == 0)
          {
            if (local_args_info.bank_given || (check_ambiguity && args_info->bank_given))
              {
                fprintf (stderr, "%s: `--bank' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->bank_given && ! override)
              continue;
            local_args_info.bank_given = 1;
            args_info->bank_given = 1;
            if (args_info->bank_arg)
              free (args_info->bank_arg); /* free previous string */
            args_info->bank_arg = gengetopt_strdup (optarg);
            if (args_info->bank_orig)
              free (args_info->bank_orig); /* free previous string */
            args_info->bank_orig = gengetopt_strdup (optarg);
          }
          /* Broker identifier.  */
          else if (strcmp (long_options[option_index].name, "broker") == 0)
          {
            if (local_args_info.broker_given || (check_ambiguity && args_info->broker_given))
              {
                fprintf (stderr, "%s: `--broker' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->broker_given && ! override)
              continue;
            local_args_info.broker_given = 1;
            args_info->broker_given = 1;
            if (args_info->broker_arg)
              free (args_info->broker_arg); /* free previous string */
            args_info->broker_arg = gengetopt_strdup (optarg);
            if (args_info->broker_orig)
              free (args_info->broker_orig); /* free previous string */
            args_info->broker_orig = gengetopt_strdup (optarg);
          }
          /* User name.  */
          else if (strcmp (long_options[option_index].name, "user") == 0)
          {
            if (local_args_info.user_given || (check_ambiguity && args_info->user_given))
              {
                fprintf (stderr, "%s: `--user' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->user_given && ! override)
              continue;
            local_args_info.user_given = 1;
            args_info->user_given = 1;
            if (args_info->user_arg)
              free (args_info->user_arg); /* free previous string */
            args_info->user_arg = gengetopt_strdup (optarg);
            if (args_info->user_orig)
              free (args_info->user_orig); /* free previous string */
            args_info->user_orig = gengetopt_strdup (optarg);
          }
          /* Password.  */
          else if (strcmp (long_options[option_index].name, "pass") == 0)
          {
            if (local_args_info.pass_given || (check_ambiguity && args_info->pass_given))
              {
                fprintf (stderr, "%s: `--pass' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->pass_given && ! override)
              continue;
            local_args_info.pass_given = 1;
            args_info->pass_given = 1;
            if (args_info->pass_arg)
              free (args_info->pass_arg); /* free previous string */
            args_info->pass_arg = gengetopt_strdup (optarg);
            if (args_info->pass_orig)
              free (args_info->pass_orig); /* free previous string */
            args_info->pass_orig = gengetopt_strdup (optarg);
          }
          /* Account ID.  */
          else if (strcmp (long_options[option_index].name, "acct") == 0)
          {
            if (local_args_info.acct_given || (check_ambiguity && args_info->acct_given))
              {
                fprintf (stderr, "%s: `--acct' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->acct_given && ! override)
              continue;
            local_args_info.acct_given = 1;
            args_info->acct_given = 1;
            if (args_info->acct_arg)
              free (args_info->acct_arg); /* free previous string */
            args_info->acct_arg = gengetopt_strdup (optarg);
            if (args_info->acct_orig)
              free (args_info->acct_orig); /* free previous string */
            args_info->acct_orig = gengetopt_strdup (optarg);
          }
          /* Account Type 1=checking 2=invest 3=ccard.  */
          else if (strcmp (long_options[option_index].name, "type") == 0)
          {
            if (local_args_info.type_given || (check_ambiguity && args_info->type_given))
              {
                fprintf (stderr, "%s: `--type' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->type_given && ! override)
              continue;
            local_args_info.type_given = 1;
            args_info->type_given = 1;
            args_info->type_arg = strtol (optarg, &stop_char, 0);
            if (!(stop_char && *stop_char == '\0')) {
              fprintf(stderr, "%s: invalid numeric value: %s\n", argv[0], optarg);
              goto failure;
            }
            if (args_info->type_orig)
              free (args_info->type_orig); /* free previous string */
            args_info->type_orig = gengetopt_strdup (optarg);
          }
          /* How far back to look from today (in days).  */
          else if (strcmp (long_options[option_index].name, "past") == 0)
          {
            if (local_args_info.past_given || (check_ambiguity && args_info->past_given))
              {
                fprintf (stderr, "%s: `--past' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->past_given && ! override)
              continue;
            local_args_info.past_given = 1;
            args_info->past_given = 1;
            args_info->past_arg = strtol (optarg, &stop_char, 0);
            if (!(stop_char && *stop_char == '\0')) {
              fprintf(stderr, "%s: invalid numeric value: %s\n", argv[0], optarg);
              goto failure;
            }
            if (args_info->past_orig)
              free (args_info->past_orig); /* free previous string */
            args_info->past_orig = gengetopt_strdup (optarg);
          }
          /* Url to POST the data to (otherwise goes to stdout).  */
          else if (strcmp (long_options[option_index].name, "url") == 0)
          {
            if (local_args_info.url_given || (check_ambiguity && args_info->url_given))
              {
                fprintf (stderr, "%s: `--url' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->url_given && ! override)
              continue;
            local_args_info.url_given = 1;
            args_info->url_given = 1;
            if (args_info->url_arg)
              free (args_info->url_arg); /* free previous string */
            args_info->url_arg = gengetopt_strdup (optarg);
            if (args_info->url_orig)
              free (args_info->url_orig); /* free previous string */
            args_info->url_orig = gengetopt_strdup (optarg);
          }
          /* Transaction id.  */
          else if (strcmp (long_options[option_index].name, "trid") == 0)
          {
            if (local_args_info.trid_given || (check_ambiguity && args_info->trid_given))
              {
                fprintf (stderr, "%s: `--trid' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->trid_given && ! override)
              continue;
            local_args_info.trid_given = 1;
            args_info->trid_given = 1;
            args_info->trid_arg = strtol (optarg, &stop_char, 0);
            if (!(stop_char && *stop_char == '\0')) {
              fprintf(stderr, "%s: invalid numeric value: %s\n", argv[0], optarg);
              goto failure;
            }
            if (args_info->trid_orig)
              free (args_info->trid_orig); /* free previous string */
            args_info->trid_orig = gengetopt_strdup (optarg);
          }
          /* List all banks which support online banking.  */
          else if (strcmp (long_options[option_index].name, "allsupport") == 0)
          {
            if (local_args_info.allsupport_given || (check_ambiguity && args_info->allsupport_given))
              {
                fprintf (stderr, "%s: `--allsupport' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->allsupport_given && ! override)
              continue;
            local_args_info.allsupport_given = 1;
            args_info->allsupport_given = 1;
            if (args_info->command_group_counter && override)
              reset_group_command (args_info);
            args_info->command_group_counter += 1;
            break;
          }
          
          break;
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */

  if (args_info->command_group_counter > 1)
    {
      fprintf (stderr, "%s: %d options of group command were given. At most one is required.%s\n", argv[0], args_info->command_group_counter, (additional_error ? additional_error : ""));
      error = 1;
    }
  



  cmdline_parser_release (&local_args_info);

  if ( error )
    return (EXIT_FAILURE);

  if (optind < argc)
    {
      int i = 0 ;
      int found_prog_name = 0;
      /* whether program name, i.e., argv[0], is in the remaining args
         (this may happen with some implementations of getopt,
          but surely not with the one included by gengetopt) */

      i = optind;
      while (i < argc)
        if (argv[i++] == argv[0]) {
          found_prog_name = 1;
          break;
        }
      i = 0;

      args_info->inputs_num = argc - optind - found_prog_name;
      args_info->inputs =
        (char **)(malloc ((args_info->inputs_num)*sizeof(char *))) ;
      while (optind < argc)
        if (argv[optind++] != argv[0])
          args_info->inputs[ i++ ] = gengetopt_strdup (argv[optind-1]) ;
    }

  return 0;

failure:
  
  cmdline_parser_release (&local_args_info);
  return (EXIT_FAILURE);
}
