Summary:      libFoundation fork of the Objective-C runtime library.
Name:         libobjc-lf2
Version:      %{libf_objc_version}
Release:      %{libf_objc_release}.%{libf_objc_buildcount}%{dist_suffix}
Vendor:       http://www.gnustep.org
Packager:     Frank Reppin <frank@opengroupware.org>  
License:      GPL
URL:          http://www.opengroupware.org
Group:        Development/Libraries
AutoReqProv:  off
Source:       %{libf_objc_source}
Prefix:       %{libf_objc_prefix}
BuildRoot:    %{_tmppath}/%{name}-%{version}-%{release}-root
BuildPreReq:  ogo-gnustep_make

%description
Library needed to run Objective-C applications which use libFoundation.

%package devel
Summary:      Header files for the libFoundation fork of the Objective-C library
Group:        Development/Libraries
Requires:     libobjc-lf2 ogo-gnustep_make
AutoReqProv:  off

%description devel
This package contains the header files to build Objective-C applications
that use libFoundation.

%prep
rm -fr ${RPM_BUILD_ROOT}
%setup -q -n libobjc-lf2

# ****************************** build ********************************
%build
source %{prefix}/OGo-GNUstep/Library/Makefiles/GNUstep.sh
make %{libf_objc_makeflags} all

# ****************************** install ******************************
%install
source %{prefix}/OGo-GNUstep/Library/Makefiles/GNUstep.sh
make %{libf_objc_makeflags} GNUSTEP_INSTALLATION_DIR=${RPM_BUILD_ROOT}%{prefix}/OGo-GNUstep install

mkdir -p ${RPM_BUILD_ROOT}%{prefix}/lib
mv ${RPM_BUILD_ROOT}%{prefix}/OGo-GNUstep/Library/Libraries/libobjc*.so.lf2* \
   ${RPM_BUILD_ROOT}%{prefix}/lib/

if [ -h "${RPM_BUILD_ROOT}%{prefix}/OGo-GNUstep/Library/Libraries/libobjc_d.so" ]; then
  rm -f "${RPM_BUILD_ROOT}%{prefix}/OGo-GNUstep/Library/Libraries/libobjc_d.so"
fi

if [ -h "${RPM_BUILD_ROOT}%{prefix}/OGo-GNUstep/Library/Libraries/libobjc.so" ]; then
  rm -f "${RPM_BUILD_ROOT}%{prefix}/OGo-GNUstep/Library/Libraries/libobjc.so"
fi

# ****************************** post *********************************
%post
if [ $1 = 1 ]; then
  if [ -e %{prefix}/lib/libobjc_d.so.lf2 ]; then
    mkdir -p %{prefix}/OGo-GNUstep/Library/Libraries
    cd %{prefix}/OGo-GNUstep/Library/Libraries
    ln -s %{prefix}/lib/libobjc_d.so.lf2
    ln -s %{prefix}/lib/libobjc_d.so.lf2 \
          %{prefix}/OGo-GNUstep/Library/Libraries/libobjc_d.so
  fi
  if [ -e %{prefix}/lib/libobjc.so.lf2 ]; then
    mkdir -p %{prefix}/OGo-GNUstep/Library/Libraries
    cd %{prefix}/OGo-GNUstep/Library/Libraries
    ln -s %{prefix}/lib/libobjc.so.lf2
    ln -s %{prefix}/lib/libobjc.so.lf2 \
          %{prefix}/OGo-GNUstep/Library/Libraries/libobjc.so
  fi
  if [ -d %{_sysconfdir}/ld.so.conf.d ]; then
    echo "%{prefix}/lib" > %{_sysconfdir}/ld.so.conf.d/libobjc-lf2.conf
  elif [ ! "`grep '%{prefix}/lib' %{_sysconfdir}/ld.so.conf`" ]; then
    echo "%{prefix}/lib" >> %{_sysconfdir}/ld.so.conf
  fi
  /sbin/ldconfig
fi

# ****************************** postun *********************************
%postun
if [ $1 = 0 ]; then
  if [ -h %{prefix}/OGo-GNUstep/Library/Libraries/libobjc_d.so.lf2 ]; then
    rm -f %{prefix}/OGo-GNUstep/Library/Libraries/libobjc_d.so.lf2
  fi
  if [ -h %{prefix}/OGo-GNUstep/Library/Libraries/libobjc_d.so ]; then
    rm -f %{prefix}/OGo-GNUstep/Library/Libraries/libobjc_d.so
  fi
  if [ -h %{prefix}/OGo-GNUstep/Library/Libraries/libobjc.so.lf2 ]; then
    rm -f %{prefix}/OGo-GNUstep/Library/Libraries/libobjc.so.lf2
  fi
  if [ -h %{prefix}/OGo-GNUstep/Library/Libraries/libobjc.so ]; then
    rm -f %{prefix}/OGo-GNUstep/Library/Libraries/libobjc.so
  fi
  if [ -e %{_sysconfdir}/ld.so.conf.d/libobjc-lf2.conf ]; then
    rm -f %{_sysconfdir}/ld.so.conf.d/libobjc-lf2.conf
  fi
  /sbin/ldconfig
fi

# ****************************** clean ********************************
%clean
rm -fr ${RPM_BUILD_ROOT}

# ****************************** files ********************************
%files
%defattr(-,root,root,-)
%{prefix}/lib/libobjc*.so.lf2*
%files devel
%defattr(-,root,root,-)
%{prefix}/OGo-GNUstep/Library/Headers/objc

# ********************************* changelog *************************
%changelog
* Thu Apr 14 2005 Frank Reppin <frank@opengroupware.org>
- fix linking issue (make sure things are linked against the lf2 libobjc)
* Tue Mar 22 2005 Frank Reppin <frank@opengroupware.org>
- remove leftover symlink pointing to nowhere from buildroot
  during install (after mv)
* Mon Jan 17 2005 Frank Reppin <frank@opengroupware.org>
- mkdir "%{prefix}/OGo-GNUstep/Library/Libraries" prior symlinking,
* Wed Sep 09 2004 Frank Reppin <frank@opengroupware.org>
- initial build
