/* GNU Objective C Runtime class related functions
   Copyright (C) 1993, 1995, 1996, 1997 Free Software Foundation, Inc.
   Contributed by Kresten Krab Thorup and Dennis Glatting.

This file is part of GNU CC.

GNU CC is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation; either version 2, or (at your option) any later version.

GNU CC is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
details.

You should have received a copy of the GNU General Public License along with
GNU CC; see the file COPYING.  If not, write to the Free Software
Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

/* As a special exception, if you link this library with files compiled with
   GCC to produce an executable, this does not cause the resulting executable
   to be covered by the GNU General Public License. This exception does not
   however invalidate any other reasons why the executable file might be
   covered by the GNU General Public License.  */

#include "objc-decls.h"
#include "runtime.h"		/* the kitchen sink */

/*
  Global variables used in the Objective-C runtime.
*/

/* deprecated: */

objc_DECLARE void *__objc_uninstalled_dtable = NULL;

/* ******************** from class.c: ******************** */

/* The table of classname->class.  Used for objc_lookup_class and friends */
objc_DECLARE cache_ptr __objc_class_hash = 0;                 /* !T:MUTEX */

/* This is a hook which is called by objc_get_class and 
   objc_lookup_class if the runtime is not able to find the class.
   This may e.g. try to load in the class using dynamic loading */
objc_DECLARE Class (*_objc_lookup_class)(const char* name) = 0;      /* !T:SAFE */


/* True when class links has been resolved */     
objc_DECLARE BOOL __objc_class_links_resolved = NO;                  /* !T:UNUSED */


/* ******************** from init.c: ********************* */

/* This list contains all modules currently loaded into the runtime */
objc_DECLARE struct objc_list* __objc_module_list = 0; 	/* !T:MUTEX */

/* This list contains all proto_list's not yet assigned class links */
objc_DECLARE struct objc_list* __objc_unclaimed_proto_list = 0; 	/* !T:MUTEX */

/* List of unresolved static instances.  */
objc_DECLARE struct objc_list *__objc_uninitialized_statics = 0; 	/* !T:MUTEX */

/* Global runtime "write" mutex. */
objc_DECLARE objc_mutex_t __objc_runtime_mutex = 0;

/* Number of threads that are alive. */
objc_DECLARE int __objc_runtime_threads_alive = 1;			/* !T:MUTEX */

/* This is a hook which is called by __objc_exec_class every time a class
   or a category is loaded into the runtime.  This may e.g. help a
   dynamic loader determine the classes that have been loaded when
   an object file is dynamically linked in */
objc_DECLARE void (*_objc_load_callback)(Class class, Category* category); /* !T:SAFE */

/* Is all categories/classes resolved? */
objc_DECLARE BOOL __objc_dangling_categories = NO;           /* !T:UNUSED */

/* This is a linked list of objc_class_tree trees. The head of these trees
   are root classes (their super class is Nil). These different trees
   represent different class hierarchies. */
objc_DECLARE struct objc_list *__objc_class_tree_list = NULL;

/* Keeps the +load methods who have been already executed. This hash should
   not be destroyed during the execution of the program. */
objc_DECLARE cache_ptr __objc_load_methods = NULL;


/* ******************** from selector.c: ********************* */

/* Tables mapping selector names to uid and opposite */
objc_DECLARE struct sarray* __objc_selector_array = 0; /* uid -> sel-list !T:MUTEX */
objc_DECLARE struct sarray* __objc_selector_names = 0; /* uid -> name     !T:MUTEX */
objc_DECLARE cache_ptr      __objc_selector_hash  = 0; /* name -> uid     !T:MUTEX */

/* Number of selectors stored in each of the above tables */
objc_DECLARE int __objc_selector_max_index = 0;              /* !T:MUTEX */

objc_DECLARE IMP (*__objc_msg_lookup)(id, SEL) = NULL;
objc_DECLARE IMP (*__objc_class_get_method)(Class, SEL) = NULL;
