/*
 * Copyright (C) The MX4J Contributors.
 * All rights reserved.
 *
 * This software is distributed under the terms of the MX4J License version 1.0.
 * See the terms of the MX4J License in the documentation provided with this software.
 */

package mx4j.tools.adaptor.interceptor;

/**
 * Management interface for interceptors
 *
 * @version $Revision: 1.3 $
 */
public interface AdaptorInterceptorMBean
{
   /**
    * Enables or disables this interceptor
    */
   public void setEnabled(boolean value);

   /**
    * Returns whether this interceptor is enabled
    */
   public boolean isEnabled();

   /**
    * Returns the type of this interceptor
    */
   public String getType();
}
