/*
 * Copyright (c) 2003 OpenSource. All rights reserved.
 */
package test.javax.management.relation;

import junit.framework.TestCase;

import javax.management.relation.Role;
import javax.management.ObjectName;
import java.util.ArrayList;
import java.util.List;

/**
 * Class or Interface description.
 * 
 * @author bcassidy
 * @version $Revision: 1.1 $
 * $Id: RoleTest.java,v 1.1 2003/09/05 22:51:54 shadow12 Exp $
 */
public class RoleTest extends TestCase
{
    private Role _role;

    public RoleTest(String name)
    {
        super(name);
    }

    protected void setUp() throws Exception
    {
        _role = new Role("test Role", new ArrayList());
    }

    protected void tearDown() throws Exception
    {
    }

    public void testGetRoleValue() throws Exception
    {
        List roleValues = _role.getRoleValue();
        assertNotNull(roleValues);
    }

    public void testGetRoleValue_ListHasElements() throws Exception
    {
        List values = new ArrayList();
        values.add(new ObjectName("domain:name=test"));
        Role role = new Role("Test Role", values);
        assertEquals(1, role.getRoleValue().size());
    }
}