# -*- ruby -*-
# This file is a part of test scripts of LDAP extension module.

require "test/conf"
require "ldap"

conn = LDAP::Conn.new($HOST, $PORT)
conn.bind('cn=root, dc=localhost, dc=localdomain','secret'){
  conn.perror("bind")
  entry1 = [
    LDAP.mod(LDAP::LDAP_MOD_ADD,
	     'objectclass', ['top', 'organization']),
    LDAP.mod(LDAP::LDAP_MOD_ADD,
	     'o', ['Japan Advanced Institute of Science and Technology']),
  ]

  entry2 = [
    LDAP.mod(LDAP::LDAP_MOD_ADD, 'objectclass', ['top', 'person']),
    LDAP.mod(LDAP::LDAP_MOD_ADD, 'cn', ['Takaaki Tateishi']),
    LDAP.mod(LDAP::LDAP_MOD_ADD, 'sn', ['ttate','Tateishi']),
  ]

  begin
    conn.add("dc=localhost, dc=localdomain", entry1)
    conn.add("cn=Takaaki Tateishi, dc=localhost, dc=localdomain", entry2)
  rescue LDAP::ResultError
    conn.perror("add")
    exit
  end
  conn.perror("add")
}
