/*
 * saslconn.c
 * $Id: saslconn.c,v 1.7 2002/03/12 05:36:05 ttate Exp $
 */

#include "ruby.h"
#include "rbldap.h"
#include <sys/time.h>
#include <unistd.h>


VALUE rb_cLDAP_SASLConn;

void
Init_ldap_saslconn()
{
  rb_cLDAP_SASLConn = rb_define_class_under(rb_mLDAP, "SASLConn", rb_cLDAP_Conn);
  rb_define_method(rb_cLDAP_SASLConn, "bind", rb_ldap_saslconn_bind, -1);
};


#if defined(HAVE_LDAP_SASL_BIND_S)
VALUE
rb_ldap_saslconn_bind(int argc, VALUE argv[], VALUE self)
{
  RB_LDAP_DATA *ldapdata;

  VALUE arg1, arg2, arg3, arg4, arg5, arg6;
  VALUE result;
  char *dn = NULL;
  char *mechanism = NULL;
  struct berval *cred = ALLOCA_N(struct berval, 1);
  LDAPControl **serverctrls = NULL;
  LDAPControl **clientctrls = NULL;
  struct berval *servercred;

  GET_LDAP_DATA(self,ldapdata);
  switch( rb_scan_args(argc, argv, "32", &arg1, &arg2, &arg3, &arg4, &arg5) ){
  case 3:
    if( arg1 == Qnil ){
      dn = NULL;
    }
    else{
      dn = STR2CSTR(arg1);
    };
    mechanism = STR2CSTR(arg2);
    cred->bv_val = STR2CSTR(arg3);
    cred->bv_len = RSTRING(arg3)->len;
    break;
  case 4:
    if( arg1 == Qnil ){
      dn = NULL;
    }
    else{
      dn = STR2CSTR(arg1);
    };
    mechanism = STR2CSTR(arg2);
    cred->bv_val = STR2CSTR(arg3);
    cred->bv_len = RSTRING(arg3)->len;
    serverctrls = rb_ldap_get_controls(arg4);
    break;
  case 5:
    if( arg1 == Qnil ){
      dn = NULL;
    }
    else{
      dn = STR2CSTR(arg1);
    };
    mechanism = STR2CSTR(arg2);
    cred->bv_val = STR2CSTR(arg3);
    cred->bv_len = RSTRING(arg3)->len;
    serverctrls = rb_ldap_get_controls(arg4);
    clientctrls = rb_ldap_get_controls(arg5);
    break;
  default:
    rb_bug("rb_ldap_conn_bind_s");
  }

  ldapdata->err = ldap_sasl_bind_s(ldapdata->ldap, dn, mechanism, cred,
				   serverctrls, clientctrls, &servercred);
  Check_LDAP_Result(ldapdata->err);

  if( rb_block_given_p() ){
    VALUE val;
    val = rb_assoc_new(self,
		       rb_tainted_str_new(servercred->bv_val, servercred->bv_len));
    result = rb_ensure(rb_yield, val, rb_ldap_conn_unbind, self);
  };

  return self;
};

#else /* HAVE_LDAP_SASL_BIND_S */

VALUE
rb_ldap_saslconn_bind(int argc, VALUE argv[], VALUE self)
{
  rb_notimplement();
};

#endif /* HAVE_LDAP_SASL_BIND_S */



