/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.date.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.date.SerialDate;

public class SerialDateTests
extends TestCase {
    private SerialDate nov9Y2001;
    static /* synthetic */ Class class$org$jfree$date$junit$SerialDateTests;

    public SerialDateTests(String name) {
        super(name);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    protected void setUp() {
        this.nov9Y2001 = SerialDate.createInstance(9, 11, 2001);
    }

    public static Test suite() {
        return new TestSuite(class$org$jfree$date$junit$SerialDateTests != null ? class$org$jfree$date$junit$SerialDateTests : (class$org$jfree$date$junit$SerialDateTests = SerialDateTests.class$("org.jfree.date.junit.SerialDateTests")));
    }

    public void test1096282() {
        SerialDate d = SerialDate.createInstance(29, 2, 2004);
        d = SerialDate.addYears(1, d);
        SerialDate expected = SerialDate.createInstance(28, 2, 2005);
        Assert.assertTrue((boolean)d.isOn(expected));
    }

    public void testAddMonths() {
        SerialDate d1 = SerialDate.createInstance(31, 5, 2004);
        SerialDate d2 = SerialDate.addMonths(1, d1);
        Assert.assertEquals((int)30, (int)d2.getDayOfMonth());
        Assert.assertEquals((int)6, (int)d2.getMonth());
        Assert.assertEquals((int)2004, (int)d2.getYYYY());
        SerialDate d3 = SerialDate.addMonths(2, d1);
        Assert.assertEquals((int)31, (int)d3.getDayOfMonth());
        Assert.assertEquals((int)7, (int)d3.getMonth());
        Assert.assertEquals((int)2004, (int)d3.getYYYY());
        SerialDate d4 = SerialDate.addMonths(1, SerialDate.addMonths(1, d1));
        Assert.assertEquals((int)30, (int)d4.getDayOfMonth());
        Assert.assertEquals((int)7, (int)d4.getMonth());
        Assert.assertEquals((int)2004, (int)d4.getYYYY());
    }

    public void testAddMonthsTo1Jan2003() {
        SerialDate d1 = SerialDate.createInstance(1, 1, 2003);
        SerialDate d2 = SerialDate.addMonths(0, d1);
        Assert.assertEquals((Object)d2, (Object)d1);
    }

    public void testAddMonthsTo5Oct2003() {
        SerialDate d1 = SerialDate.createInstance(5, 10, 2003);
        SerialDate d2 = SerialDate.addMonths(2, d1);
        Assert.assertEquals((Object)d2, (Object)SerialDate.createInstance(5, 12, 2003));
    }

    public void testAddMonthsTo9Nov2001() {
        SerialDate jan9Y2002 = SerialDate.addMonths(2, this.nov9Y2001);
        SerialDate answer = SerialDate.createInstance(9, 1, 2002);
        Assert.assertEquals((Object)answer, (Object)jan9Y2002);
    }

    public void testIsLeapYear2000() {
        Assert.assertTrue((boolean)SerialDate.isLeapYear(2000));
    }

    public void testIsNotLeapYear1900() {
        Assert.assertTrue((boolean)(SerialDate.isLeapYear(1900) ^ true));
    }

    public void testLeapYearCount1899() {
        Assert.assertEquals((int)SerialDate.leapYearCount(1899), (int)0);
    }

    public void testLeapYearCount1903() {
        Assert.assertEquals((int)SerialDate.leapYearCount(1903), (int)0);
    }

    public void testLeapYearCount1904() {
        Assert.assertEquals((int)SerialDate.leapYearCount(1904), (int)1);
    }

    public void testLeapYearCount1999() {
        Assert.assertEquals((int)SerialDate.leapYearCount(1999), (int)24);
    }

    public void testLeapYearCount2000() {
        Assert.assertEquals((int)SerialDate.leapYearCount(2000), (int)25);
    }

    public void testMondayFollowingFriday9Nov2001() {
        SerialDate mondayAfter = SerialDate.getFollowingDayOfWeek(2, this.nov9Y2001);
        Assert.assertEquals((int)12, (int)mondayAfter.getDayOfMonth());
    }

    public void testMondayNearest22Jan1970() {
        SerialDate jan22Y1970 = SerialDate.createInstance(22, 1, 1970);
        SerialDate mondayNearest = SerialDate.getNearestDayOfWeek(2, jan22Y1970);
        Assert.assertEquals((int)19, (int)mondayNearest.getDayOfMonth());
    }

    public void testMondayNearestFriday9Nov2001() {
        SerialDate mondayNearest = SerialDate.getNearestDayOfWeek(2, this.nov9Y2001);
        Assert.assertEquals((int)12, (int)mondayNearest.getDayOfMonth());
    }

    public void testMondayPrecedingFriday9Nov2001() {
        SerialDate mondayBefore = SerialDate.getPreviousDayOfWeek(2, this.nov9Y2001);
        Assert.assertEquals((int)5, (int)mondayBefore.getDayOfMonth());
    }

    public void testMonthCodeToStringCode() {
        String test = SerialDate.monthCodeToString(12);
        Assert.assertEquals((String)"December", (String)test);
    }

    public void testSerialization() {
        SerialDate d1 = SerialDate.createInstance(15, 4, 2000);
        SerialDate d2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(d1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            d2 = (SerialDate)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Assert.assertEquals((Object)d1, d2);
    }

    public void testStringToMonthCode() {
        int m = SerialDate.stringToMonthCode("January");
        Assert.assertEquals((int)1, (int)m);
        m = SerialDate.stringToMonthCode(" January ");
        Assert.assertEquals((int)1, (int)m);
        m = SerialDate.stringToMonthCode("Jan");
        Assert.assertEquals((int)1, (int)m);
    }

    public void testStringToWeekday() {
        int weekday = SerialDate.stringToWeekdayCode("Wednesday");
        Assert.assertEquals((int)4, (int)weekday);
        weekday = SerialDate.stringToWeekdayCode(" Wednesday ");
        Assert.assertEquals((int)4, (int)weekday);
        weekday = SerialDate.stringToWeekdayCode("Wed");
        Assert.assertEquals((int)4, (int)weekday);
    }

    public void testWeekdayCodeToString() {
        String test = SerialDate.weekdayCodeToString(7);
        Assert.assertEquals((String)"Saturday", (String)test);
    }
}

