/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.test.annotation.factory.support;

import java.lang.annotation.Annotation;

import org.jboss.util.JBossObject;

/**
 * @author <a href="mailto:ales.justin@jboss.com">Ales Justin</a>
 */
public class NameImpl implements Name
{
   private String type = "";
   private String subtype = "";

   public NameImpl()
   {
   }

   public NameImpl(String type, String subtype)
   {
      if (type != null)
         this.type = type;
      if (subtype != null)
         this.subtype = subtype;
   }

   public String type()
   {
      return type;
   }

   public String subtype()
   {
      return subtype;
   }

   public Class<? extends Annotation> annotationType()
   {
      return Name.class;
   }

   public int hashCode()
   {
      return type.hashCode() + subtype.hashCode();
   }

   public boolean equals(Object obj)
   {
      if (obj instanceof Name == false)
         return false;

      Name name = (Name)obj;
      return JBossObject.equals(type, name.type()) && JBossObject.equals(subtype, name.subtype());
   }

   public String toString()
   {
      return "@" + annotationType().getName() + "(type=" + type + ", subtype=" + subtype + ")";
   }
}
