package org.jboss.test.managed.factory.support.mcf;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import org.jboss.managed.api.annotation.ManagementObject;

@XmlAccessorType(XmlAccessType.FIELD)
@ManagementObject
public abstract class NonXADataSourceDeploymentMetaData extends DataSourceDeploymentMetaData
{
   @XmlElement(name="driver-class", required=true)
   @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
   private String driverClass;
   
   @XmlElement(name="connection-url", required=true)
   @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
   private String connectionUrl;
   
   @XmlElement(name="connection-property")
   private List<DataSourceConnectionPropertyMetaData> connectionProperties = new ArrayList<DataSourceConnectionPropertyMetaData>();

   public String getConnectionUrl()
   {
      return connectionUrl;
   }

   public void setConnectionUrl(String connectionUrl)
   {
      this.connectionUrl = connectionUrl;
   }

   public String getDriverClass()
   {
      return driverClass;
   }

   public void setDriverClass(String driverClass)
   {
      this.driverClass = driverClass;
   }

   public List<DataSourceConnectionPropertyMetaData> getDataSourceConnectionProperties()
   {
      return this.connectionProperties;      
   }

   public void setDataSourceConnectionProperties(List<DataSourceConnectionPropertyMetaData> connectionProperties)
   {
      this.connectionProperties = connectionProperties;
   }
   
   @Override
   public List<ManagedConnectionFactoryPropertyMetaData> getManagedConnectionFactoryProperties()
   {
      
      List<ManagedConnectionFactoryPropertyMetaData> properties = super.getManagedConnectionFactoryProperties();
      ManagedConnectionFactoryPropertyMetaData property = null;
      
      if(getConnectionUrl() != null)
      {
         property = new ManagedConnectionFactoryPropertyMetaData();
         property.setName("ConnectionURL");
         property.setValue(getConnectionUrl());
         properties.add(property);
         
      }
      
      if(getDriverClass() != null)
      {
         property = new ManagedConnectionFactoryPropertyMetaData();
         property.setName("DriverClass");
         property.setValue(getDriverClass());
         properties.add(property);         
      }
      
      StringBuffer propBuff = new StringBuffer();
      List<DataSourceConnectionPropertyMetaData> dsProps = getDataSourceConnectionProperties();

      if (dsProps != null)
      {
         for (DataSourceConnectionPropertyMetaData prop : dsProps)
         {
            propBuff.append(prop.getName() + "=" + prop.getValue() + "\n");      
         }
      }
      
      property = new ManagedConnectionFactoryPropertyMetaData();
      property.setName("ConnectionProperties");
      property.setValue(propBuff.toString());
      properties.add(property);

      return properties;
      
   }
}
