package org.jboss.cache.commands;

import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import javax.transaction.TransactionManager;
import java.util.HashMap;

/**
 * Test to check that structural nodes are being removed on rollback: http://jira.jboss.com/jira/browse/JBCACHE-1365.
 *
 * @author Mircea.Markus@jboss.com
 * @since 2.2
 */
@Test(groups = "functional")
public class StructuralNodesOnRollbackTest
{
   private CacheSPI<Object, Object> cache;
   private TransactionManager txMgr;

   @BeforeMethod(alwaysRun = true)
   public void setUp()
   {
      Configuration cacheConfig = UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.LOCAL, false);
      cache = (CacheSPI<Object, Object>) new DefaultCacheFactory().createCache(cacheConfig, false);
      cache.start();
      txMgr = cache.getTransactionManager();
   }

   @AfterMethod(alwaysRun = true)
   public void tearDown()
   {
      cache.stop();
      cache.destroy();
   }

   public void testPutDataMap() throws Exception
   {
      HashMap map = new HashMap();
      map.put("k", "v");

      assert !cache.exists("/a/b");
      txMgr.begin();
      cache.put("/a/b/c", map);
      assert cache.exists("/a/b");
      txMgr.rollback();
      assert !cache.exists("/a/b");
   }

   public void testPutKeyValueCommand() throws Exception
   {
      assert !cache.exists("/a/b");
      txMgr.begin();
      cache.put("/a/b/c", "key", "value");
      assert cache.exists("/a/b");
      txMgr.rollback();
      assert !cache.exists("/a/b");
   }
}
