/**
 * GUI Commands
 * Copyright 2005 Andrew Pietsch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: RenderManager.java,v 1.3 2005/06/13 08:10:31 pietschy Exp $
 */
package org.pietschy.command;

import javax.swing.*;

/**
 * The RenderManager provides a simple static method that can be used to configure the specified
 * button using the current {@link FaceRenderer}.
 *
 * @author andrewp
 * @version $Revision: 1.3 $
 */
public class
RenderManager
{
   private static FaceRenderer renderer;

   static
   {
      if (CommandManager.isMacOS())
         renderer = new MacFaceRenderer();
      else
         renderer = new DefaultFaceRenderer();
   }

   /**
    * Gets the currently installed {@link FaceRenderer}.
    *
    * @return the currently installed {@link FaceRenderer}.
    */
   public static FaceRenderer
   getRenderer()
   {
      return renderer;
   }

   /**
    * Sets the {@link FaceRenderer} to use when configuring buttons and menus.
    *
    * @param renderer the {@link FaceRenderer} to use.
    */
   public static void
   setRenderer(FaceRenderer renderer)
   {
      RenderManager.renderer = renderer;
   }

   /**
    * Renders the specified button using the currently configured {@link FaceRenderer}.  The button
    * must be attached to a {@link Command} instance.
    *
    * @param button the button to configure.
    */
   public static void
   renderButton(AbstractButton button)
   {
      RenderContext context = RenderContext.get(button);

      if (button instanceof JMenuItem)
         renderer.configureMenu((JMenuItem) button, context);
      else
         renderer.configureButton(button, context);
   }
}
