/* testmultimap.c generated by valac, the Vala compiler
 * generated from testmultimap.vala, do not modify */

/* testmultimap.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 * Copyright (C) 2009  Didier Villevalois, Julien Peeters
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Didier 'Ptitjes' Villevalois <ptitjes@free.fr>
 * 	Julien Peeters <contact@julienpeeters.fr>
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define GEE_TYPE_TEST_CASE (gee_test_case_get_type ())
#define GEE_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TEST_CASE, GeeTestCase))
#define GEE_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_TEST_CASE, GeeTestCaseClass))
#define GEE_IS_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TEST_CASE))
#define GEE_IS_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_TEST_CASE))
#define GEE_TEST_CASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_TEST_CASE, GeeTestCaseClass))

typedef struct _GeeTestCase GeeTestCase;
typedef struct _GeeTestCaseClass GeeTestCaseClass;
typedef struct _GeeTestCasePrivate GeeTestCasePrivate;

#define TYPE_MULTI_MAP_TESTS (multi_map_tests_get_type ())
#define MULTI_MAP_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MULTI_MAP_TESTS, MultiMapTests))
#define MULTI_MAP_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MULTI_MAP_TESTS, MultiMapTestsClass))
#define IS_MULTI_MAP_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MULTI_MAP_TESTS))
#define IS_MULTI_MAP_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MULTI_MAP_TESTS))
#define MULTI_MAP_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MULTI_MAP_TESTS, MultiMapTestsClass))

typedef struct _MultiMapTests MultiMapTests;
typedef struct _MultiMapTestsClass MultiMapTestsClass;
typedef struct _MultiMapTestsPrivate MultiMapTestsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GeeTestCase {
	GObject parent_instance;
	GeeTestCasePrivate * priv;
};

struct _GeeTestCaseClass {
	GObjectClass parent_class;
	void (*set_up) (GeeTestCase* self);
	void (*tear_down) (GeeTestCase* self);
};

struct _MultiMapTests {
	GeeTestCase parent_instance;
	MultiMapTestsPrivate * priv;
	GeeMultiMap* test_multi_map;
};

struct _MultiMapTestsClass {
	GeeTestCaseClass parent_class;
};

typedef void (*GeeTestCaseTestMethod) (void* user_data);

static gpointer multi_map_tests_parent_class = NULL;

GType gee_test_case_get_type (void) G_GNUC_CONST;
GType multi_map_tests_get_type (void) G_GNUC_CONST;
enum  {
	MULTI_MAP_TESTS_DUMMY_PROPERTY
};
GeeTestCase* gee_test_case_construct (GType object_type, const char* name);
void gee_test_case_add_test (GeeTestCase* self, const char* name, GeeTestCaseTestMethod test, void* test_target);
static void multi_map_tests_test_size (MultiMapTests* self);
static void _multi_map_tests_test_size_gee_test_case_test_method (gpointer self);
static void multi_map_tests_test_getting_setting (MultiMapTests* self);
static void _multi_map_tests_test_getting_setting_gee_test_case_test_method (gpointer self);
static void multi_map_tests_test_keys_all_keys_values (MultiMapTests* self);
static void _multi_map_tests_test_keys_all_keys_values_gee_test_case_test_method (gpointer self);
MultiMapTests* multi_map_tests_construct (GType object_type, const char* name);
static void multi_map_tests_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



static void _multi_map_tests_test_size_gee_test_case_test_method (gpointer self) {
	multi_map_tests_test_size (self);
}


static void _multi_map_tests_test_getting_setting_gee_test_case_test_method (gpointer self) {
	multi_map_tests_test_getting_setting (self);
}


static void _multi_map_tests_test_keys_all_keys_values_gee_test_case_test_method (gpointer self) {
	multi_map_tests_test_keys_all_keys_values (self);
}


MultiMapTests* multi_map_tests_construct (GType object_type, const char* name) {
	MultiMapTests * self;
	g_return_val_if_fail (name != NULL, NULL);
	self = (MultiMapTests*) gee_test_case_construct (object_type, name);
	gee_test_case_add_test ((GeeTestCase*) self, "[MultiMap] size", _multi_map_tests_test_size_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[MultiMap] getting and setting", _multi_map_tests_test_getting_setting_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[MultiMap] keys, all keys and values", _multi_map_tests_test_keys_all_keys_values_gee_test_case_test_method, self);
	return self;
}


static void multi_map_tests_test_size (MultiMapTests* self) {
	g_return_if_fail (self != NULL);
	g_assert (self->test_multi_map != NULL);
	g_assert (gee_multi_map_get_size (self->test_multi_map) == 0);
	gee_multi_map_set (self->test_multi_map, "0", "0");
	g_assert (gee_multi_map_get_size (self->test_multi_map) == 1);
	gee_multi_map_set (self->test_multi_map, "0", "1");
	g_assert (gee_multi_map_get_size (self->test_multi_map) == 2);
	gee_multi_map_remove (self->test_multi_map, "0", "1");
	g_assert (gee_multi_map_get_size (self->test_multi_map) == 1);
	gee_multi_map_set (self->test_multi_map, "0", "1");
	gee_multi_map_remove_all (self->test_multi_map, "0");
	g_assert (gee_multi_map_get_size (self->test_multi_map) == 0);
	gee_multi_map_set (self->test_multi_map, "0", "0");
	g_assert (gee_multi_map_get_size (self->test_multi_map) == 1);
	gee_multi_map_set (self->test_multi_map, "1", "1");
	g_assert (gee_multi_map_get_size (self->test_multi_map) == 2);
}


static void multi_map_tests_test_getting_setting (MultiMapTests* self) {
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_;
	GeeCollection* _tmp4_;
	GeeCollection* _tmp5_;
	GeeCollection* _tmp6_;
	GeeCollection* _tmp7_;
	GeeCollection* _tmp8_;
	GeeCollection* _tmp9_;
	GeeCollection* _tmp10_;
	GeeCollection* _tmp11_;
	GeeCollection* _tmp12_;
	GeeCollection* _tmp13_;
	GeeCollection* _tmp14_;
	GeeCollection* _tmp15_;
	GeeCollection* _tmp16_;
	GeeCollection* _tmp17_;
	GeeCollection* _tmp18_;
	GeeCollection* _tmp19_;
	GeeCollection* _tmp20_;
	GeeCollection* _tmp21_;
	GeeCollection* _tmp22_;
	GeeCollection* _tmp23_;
	GeeCollection* _tmp24_;
	GeeCollection* _tmp25_;
	GeeCollection* _tmp26_;
	GeeCollection* _tmp27_;
	GeeCollection* _tmp28_;
	GeeCollection* _tmp29_;
	GeeCollection* _tmp30_;
	g_return_if_fail (self != NULL);
	g_assert (self->test_multi_map != NULL);
	gee_multi_map_set (self->test_multi_map, "0", "0");
	g_assert (gee_multi_map_contains (self->test_multi_map, "0"));
	g_assert (gee_collection_get_size (_tmp0_ = gee_multi_map_get (self->test_multi_map, "0")) == 1);
	_g_object_unref0 (_tmp0_);
	g_assert (gee_collection_contains (_tmp1_ = gee_multi_map_get (self->test_multi_map, "0"), "0"));
	_g_object_unref0 (_tmp1_);
	g_assert (gee_collection_get_size (_tmp2_ = gee_multi_map_get (self->test_multi_map, "1")) == 0);
	_g_object_unref0 (_tmp2_);
	gee_multi_map_set (self->test_multi_map, "0", "1");
	g_assert (gee_collection_get_size (_tmp3_ = gee_multi_map_get (self->test_multi_map, "0")) == 2);
	_g_object_unref0 (_tmp3_);
	g_assert (gee_collection_contains (_tmp4_ = gee_multi_map_get (self->test_multi_map, "0"), "0"));
	_g_object_unref0 (_tmp4_);
	g_assert (gee_collection_contains (_tmp5_ = gee_multi_map_get (self->test_multi_map, "0"), "1"));
	_g_object_unref0 (_tmp5_);
	gee_multi_map_set (self->test_multi_map, "1", "1");
	g_assert (gee_multi_map_contains (self->test_multi_map, "1"));
	g_assert (gee_collection_get_size (_tmp6_ = gee_multi_map_get (self->test_multi_map, "0")) == 2);
	_g_object_unref0 (_tmp6_);
	g_assert (gee_collection_contains (_tmp7_ = gee_multi_map_get (self->test_multi_map, "0"), "0"));
	_g_object_unref0 (_tmp7_);
	g_assert (gee_collection_contains (_tmp8_ = gee_multi_map_get (self->test_multi_map, "0"), "1"));
	_g_object_unref0 (_tmp8_);
	g_assert (gee_collection_get_size (_tmp9_ = gee_multi_map_get (self->test_multi_map, "1")) == 1);
	_g_object_unref0 (_tmp9_);
	g_assert (gee_collection_contains (_tmp10_ = gee_multi_map_get (self->test_multi_map, "0"), "1"));
	_g_object_unref0 (_tmp10_);
	g_assert (gee_multi_map_remove (self->test_multi_map, "0", "0"));
	g_assert (gee_multi_map_contains (self->test_multi_map, "0"));
	g_assert (!gee_collection_contains (_tmp11_ = gee_multi_map_get (self->test_multi_map, "0"), "0"));
	_g_object_unref0 (_tmp11_);
	g_assert (gee_collection_contains (_tmp12_ = gee_multi_map_get (self->test_multi_map, "0"), "1"));
	_g_object_unref0 (_tmp12_);
	g_assert (gee_multi_map_contains (self->test_multi_map, "1"));
	g_assert (gee_collection_contains (_tmp13_ = gee_multi_map_get (self->test_multi_map, "1"), "1"));
	_g_object_unref0 (_tmp13_);
	g_assert (gee_multi_map_remove (self->test_multi_map, "0", "1"));
	g_assert (!gee_multi_map_contains (self->test_multi_map, "0"));
	g_assert (!gee_collection_contains (_tmp14_ = gee_multi_map_get (self->test_multi_map, "0"), "0"));
	_g_object_unref0 (_tmp14_);
	g_assert (!gee_collection_contains (_tmp15_ = gee_multi_map_get (self->test_multi_map, "0"), "1"));
	_g_object_unref0 (_tmp15_);
	g_assert (gee_multi_map_contains (self->test_multi_map, "1"));
	g_assert (gee_collection_contains (_tmp16_ = gee_multi_map_get (self->test_multi_map, "1"), "1"));
	_g_object_unref0 (_tmp16_);
	g_assert (!gee_multi_map_remove (self->test_multi_map, "0", "1"));
	g_assert (!gee_multi_map_contains (self->test_multi_map, "0"));
	g_assert (!gee_collection_contains (_tmp17_ = gee_multi_map_get (self->test_multi_map, "0"), "0"));
	_g_object_unref0 (_tmp17_);
	g_assert (!gee_collection_contains (_tmp18_ = gee_multi_map_get (self->test_multi_map, "0"), "1"));
	_g_object_unref0 (_tmp18_);
	g_assert (gee_multi_map_contains (self->test_multi_map, "1"));
	g_assert (gee_collection_contains (_tmp19_ = gee_multi_map_get (self->test_multi_map, "1"), "1"));
	_g_object_unref0 (_tmp19_);
	gee_multi_map_clear (self->test_multi_map);
	g_assert (!gee_multi_map_contains (self->test_multi_map, "0"));
	g_assert (!gee_multi_map_contains (self->test_multi_map, "1"));
	gee_multi_map_set (self->test_multi_map, "0", "0");
	gee_multi_map_set (self->test_multi_map, "0", "1");
	gee_multi_map_set (self->test_multi_map, "1", "1");
	g_assert (gee_multi_map_get_size (self->test_multi_map) == 3);
	g_assert (gee_multi_map_contains (self->test_multi_map, "0"));
	g_assert (gee_multi_map_contains (self->test_multi_map, "1"));
	g_assert (gee_collection_get_size (_tmp20_ = gee_multi_map_get (self->test_multi_map, "0")) == 2);
	_g_object_unref0 (_tmp20_);
	g_assert (gee_collection_contains (_tmp21_ = gee_multi_map_get (self->test_multi_map, "0"), "0"));
	_g_object_unref0 (_tmp21_);
	g_assert (gee_collection_contains (_tmp22_ = gee_multi_map_get (self->test_multi_map, "0"), "1"));
	_g_object_unref0 (_tmp22_);
	g_assert (gee_collection_get_size (_tmp23_ = gee_multi_map_get (self->test_multi_map, "1")) == 1);
	_g_object_unref0 (_tmp23_);
	g_assert (gee_collection_contains (_tmp24_ = gee_multi_map_get (self->test_multi_map, "0"), "1"));
	_g_object_unref0 (_tmp24_);
	g_assert (gee_multi_map_remove_all (self->test_multi_map, "0"));
	g_assert (!gee_multi_map_contains (self->test_multi_map, "0"));
	g_assert (!gee_collection_contains (_tmp25_ = gee_multi_map_get (self->test_multi_map, "0"), "0"));
	_g_object_unref0 (_tmp25_);
	g_assert (!gee_collection_contains (_tmp26_ = gee_multi_map_get (self->test_multi_map, "0"), "1"));
	_g_object_unref0 (_tmp26_);
	g_assert (gee_multi_map_contains (self->test_multi_map, "1"));
	g_assert (gee_collection_contains (_tmp27_ = gee_multi_map_get (self->test_multi_map, "1"), "1"));
	_g_object_unref0 (_tmp27_);
	g_assert (!gee_multi_map_remove_all (self->test_multi_map, "0"));
	g_assert (!gee_multi_map_contains (self->test_multi_map, "0"));
	g_assert (!gee_collection_contains (_tmp28_ = gee_multi_map_get (self->test_multi_map, "0"), "0"));
	_g_object_unref0 (_tmp28_);
	g_assert (!gee_collection_contains (_tmp29_ = gee_multi_map_get (self->test_multi_map, "0"), "1"));
	_g_object_unref0 (_tmp29_);
	g_assert (gee_multi_map_contains (self->test_multi_map, "1"));
	g_assert (gee_collection_contains (_tmp30_ = gee_multi_map_get (self->test_multi_map, "1"), "1"));
	_g_object_unref0 (_tmp30_);
}


static void multi_map_tests_test_keys_all_keys_values (MultiMapTests* self) {
	GeeSet* keys;
	GeeMultiSet* all_keys;
	GeeCollection* values;
	gboolean zero_found;
	gboolean zero_found_once;
	gboolean one_found;
	gboolean one_found_twice;
	gboolean nothing_more;
	g_return_if_fail (self != NULL);
	g_assert (self->test_multi_map != NULL);
	gee_multi_map_set (self->test_multi_map, "0", "0");
	gee_multi_map_set (self->test_multi_map, "0", "1");
	gee_multi_map_set (self->test_multi_map, "1", "1");
	keys = gee_multi_map_get_keys (self->test_multi_map);
	all_keys = gee_multi_map_get_all_keys (self->test_multi_map);
	values = gee_multi_map_get_values (self->test_multi_map);
	g_assert (gee_collection_contains ((GeeCollection*) keys, "0"));
	g_assert (gee_collection_contains ((GeeCollection*) keys, "1"));
	g_assert (gee_multi_set_count (all_keys, "0") == 2);
	g_assert (gee_multi_set_count (all_keys, "1") == 1);
	g_assert (gee_collection_contains (values, "0"));
	g_assert (gee_collection_contains (values, "1"));
	zero_found = FALSE;
	zero_found_once = TRUE;
	one_found = FALSE;
	one_found_twice = FALSE;
	nothing_more = TRUE;
	{
		GeeIterator* _value_it;
		_value_it = gee_iterable_iterator ((GeeIterable*) values);
		while (TRUE) {
			char* value;
			if (!gee_iterator_next (_value_it)) {
				break;
			}
			value = (char*) gee_iterator_get (_value_it);
			if (_vala_strcmp0 (value, "0") == 0) {
				if (zero_found) {
					zero_found_once = FALSE;
				}
				zero_found = TRUE;
			} else {
				if (_vala_strcmp0 (value, "1") == 0) {
					if (one_found) {
						if (one_found_twice) {
							one_found_twice = FALSE;
						} else {
							one_found_twice = TRUE;
						}
					}
					one_found = TRUE;
				} else {
					nothing_more = FALSE;
				}
			}
			_g_free0 (value);
		}
		_g_object_unref0 (_value_it);
	}
	g_assert (zero_found);
	g_assert (zero_found_once);
	g_assert (one_found);
	g_assert (one_found_twice);
	g_assert (nothing_more);
	_g_object_unref0 (values);
	_g_object_unref0 (all_keys);
	_g_object_unref0 (keys);
}


static void multi_map_tests_class_init (MultiMapTestsClass * klass) {
	multi_map_tests_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = multi_map_tests_finalize;
}


static void multi_map_tests_instance_init (MultiMapTests * self) {
}


static void multi_map_tests_finalize (GObject* obj) {
	MultiMapTests * self;
	self = MULTI_MAP_TESTS (obj);
	_g_object_unref0 (self->test_multi_map);
	G_OBJECT_CLASS (multi_map_tests_parent_class)->finalize (obj);
}


GType multi_map_tests_get_type (void) {
	static volatile gsize multi_map_tests_type_id__volatile = 0;
	if (g_once_init_enter (&multi_map_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MultiMapTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) multi_map_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MultiMapTests), 0, (GInstanceInitFunc) multi_map_tests_instance_init, NULL };
		GType multi_map_tests_type_id;
		multi_map_tests_type_id = g_type_register_static (GEE_TYPE_TEST_CASE, "MultiMapTests", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&multi_map_tests_type_id__volatile, multi_map_tests_type_id);
	}
	return multi_map_tests_type_id__volatile;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




