/* Copyright (C) 1999 Hans Petter K. Jansson
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * You can contact the library's author by sending e-mail to <hpj@styx.net>.
 */

#include <stdlib.h>
#include <string.h>
#include <ctype.h>


void url_split(const char *url, char **scheme, char **host, int *port, char **path)
{
  char *p, *q;

  *scheme = *host = *path = 0;
  *port = -1;

  /* Does it start with a scheme? */
  
  for (p = (char *)url; *p; p++)
    if (*p == ':' || *p == '/') break;

  if (p > url && *p == ':')
  {
    *scheme = malloc(p - url + 1);
    strncpy(*scheme, url, p - url);
    (*scheme)[p - url] = '\0';
    url = p + 1;
  }

  /* Does it have a net_loc? */
  
  if (url[0] == '/' && url[1] == '/')
  {
    url += 2;
  
    for (p = (char *)url; *p; p++)
      if (*p == '/') break;

    /* Does it have a port number? */
  
    for (q = p - 1; q >= url; q--)
      if (!isdigit(*q)) break;
  
    if (q < p - 1 && *q == ':') *port = atoi(q + 1);
    else q = p;
  
    *host = malloc(q - url + 1);
    strncpy(*host, url, q - url);
    (*host)[q - url] = '\0';
    url = p;
  }

  /* The rest is the path */

  if (*url) *path = strdup(url);
  else *path = strdup("/");

  /* Windoze users have a tendency to use backslashes instead of slashes */

  for (p = *path; *p; p++)
    if (*p == '\\') *p = '/';
}
