/* Copyright (C) 1999 Hans Petter K. Jansson
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * You can contact the library's author by sending e-mail to <hpj@styx.net>.
 */

#include "config.h"
#include "flux.h"


int mt_is_leaf(MT *mt)
{
  TT *tt;
  
  if (mt_get_type(mt) != MT_SPAN) return(1);
  
  tt = tt_find_first_child(TT(mt), "sub", 3);
  if (!tt) return(1);
  
  if (!tt_get_first_child(tt)) return(1);
  return(0);
}


MT *mt_get_parent(MT *mt)
{
  TT *tt;

  tt = tt_get_parent(TT(mt));
  if (!tt) return(0);
  tt = tt_get_parent(tt);
  return(MT(tt));
}


MT *mt_get_first_child(MT *mt)
{
  TT *tt;
  
  tt = tt_find_first_child(TT(mt), "sub", 3);
  if (!tt) return(0);
  return(MT(tt_get_first_child(tt)));
}


MT *mt_get_last_child(MT *mt)
{
  TT *tt;
  
  tt = tt_find_first_child(TT(mt), "sub", 3);
  if (!tt) return(0);
  return(MT(tt_get_last_child(tt)));
}


MT *mt_get_common_parent(MT *mt0, MT *mt1)
{
  TT *tt;
  
  tt = tt_get_common_parent(TT(mt0), TT(mt1));
  if (!tt) return(0);

  /* TODO: Don't go up if the node arrived at is not "sub".
   * This could happen for instance when you try to get the common parent
   * of one node (as both arguments). (Or?) */
  
  return(MT(tt_get_parent(tt)));  /* Go up from "sub" node */
}


void mt_add_as_first_child(MT *parent_mt, MT *mt)
{
  TT *tt;
  
  if (mt_get_type(parent_mt) != MT_SPAN) return;
  
  tt = tt_find_first_child(TT(parent_mt), "sub", 3);
  if (!tt)
  {
    tt = tt_new();
    tt_data_set_internal(tt, "sub", 3, TRUE);
    tt_add_as_last_child(TT(parent_mt), tt);
  }
  
  tt_add_as_first_child(tt, TT(mt));
}


void mt_add_as_last_child(MT *parent_mt, MT *mt)
{
  TT *tt;
  
  if (mt_get_type(parent_mt) != MT_SPAN) return;
  
  tt = tt_find_first_child(TT(parent_mt), "sub", 3);
  if (!tt)
  {
    tt = tt_new();
    tt_data_set_internal(tt, "sub", 3, TRUE);
    tt_add_as_last_child(TT(parent_mt), tt);
  }
  
  tt_add_as_last_child(tt, TT(mt));
}


void mt_add_as_first_sibling(MT *sibling_mt, MT *mt)
{
  MT *parent_mt;

  parent_mt = mt_get_parent(sibling_mt);

  if (!parent_mt)
  {
    /* Need a new root */
    parent_mt = mt_new(MT_SPAN);
    mt_add_as_first_child(parent_mt, sibling_mt);
  }

  mt_add_as_first_child(parent_mt, mt);
}


void mt_add_as_last_sibling(MT *sibling_mt, MT *mt)
{
  MT *parent_mt;
  
  parent_mt = mt_get_parent(sibling_mt);
  
  if (!parent_mt)
  {
    /* Need a new root */
    parent_mt = mt_new(MT_SPAN);
    mt_add_as_first_child(parent_mt, sibling_mt);
  }
  
  mt_add_as_last_child(parent_mt, mt);
}


u32 mt_count_children(MT *mt)
{
  TT *tt;
  
  tt = tt_find_first_child(TT(mt), "sub", 3);
  if (!tt) return(0);

  return(tt_count_children(tt));
}


u32 mt_count_children_all(MT *mt)
{
  int num;

  for (num = 0, mt = mt_get_first_child(mt); mt; mt = mt_get_next(mt), num++)
    if (mt_get_first_child(mt)) num += mt_count_children_all(mt);

  return(num);
}


u32 mt_count_siblings(MT *mt)
{
  MT *mt_parent;
  
  mt_parent = mt_get_parent(mt);
  if (mt_parent) return(mt_count_children(mt_parent));
  
  return(1);  /* Only self (am root node) */
}
