/* Copyright (C) 1999 Hans Petter K. Jansson
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * You can contact the library's author by sending e-mail to <hpj@styx.net>.
 */

#include "config.h"
#include "flux.h"


/* --- Get --- */


int mt_has_data(MT *mt)
{
  TT *tt;
  
  switch (mt_get_type(mt))
  {
    case MT_DATA:
    case MT_ENTITY:
      tt = tt_get_first_child(TT(mt));
      if (!tt) return(0);
      return(tt_has_data(tt));
      
    case MT_EMPTY:
    case MT_SPAN:
      return(tt_has_data(TT(mt)));
    
    default:
      break;
  }
  
  return(0);
}


int mt_get_type(MT *mt)
{
  int i;

  /* TODO: Perfect hash lookup */
  
  for (i = 0; i < MT_TYPES_NUM; i++)
    if (!tt_strcmp(TT(mt), mt_types[i])) return(i);

  return(MT_UNKNOWN);
}


TT *mt_get_name(MT *mt)
{
  TT *tt;
  
  tt = tt_find_first_child(TT(mt), "name", 4);
  if (!tt) return(0);
  
  return(tt_get_first_child(tt));
}


char *mt_get_name_str(MT *mt)
{
  TT *tt;
  
  tt = mt_get_name(mt);
  if (!tt) return(0);
  
  return(tt_data_get_str(tt));
}


TT *mt_get_attr(MT *mt, const char *attr)
{
  TT *tt;
  
  tt = mt_get_attrs(mt);
  if (!tt) return(0);

  tt = tt_find_first_child(tt, (char *) attr, strlen(attr));
  if (!tt) return(0);
  
  tt = tt_get_first_child(tt);
  return(tt);
}


char *mt_get_attr_str(MT *mt, const char *attr)
{
  TT *tt;
  
  tt = mt_get_attr(mt, attr);
  if (tt) return(tt_data_get_str(tt));
  return(0);
}



char *mt_data_get_str(MT *mt)
{
  TT *tt;
  
  tt = mt_data_get(mt);
  if (!tt) return(0);
  
  return(tt_data_get_str(tt));
}


u32 mt_data_get_bytes(MT *mt, byte *dest, u32 start, u32 len)
{
  TT *tt;
  
  tt = mt_data_get(mt);
  if (!tt) return(0);
  
  return(tt_data_get_bytes(tt, dest, start, len));
}


/* --- Set --- */

void mt_set_name_str(MT *mt, const char *str)
{
  TT *tt0;
  
  tt0 = tt_find_first_child(mt, "name", 4);
  if (!tt0) tt0 = tt_new_with_parent_and_data(TT(mt), "name", 4);
  
  if (!tt_is_leaf(tt0)) tt_del(tt_get_first_child(tt0));
  tt_new_with_parent_and_data(tt0, (char *) str, strlen(str));
}


void mt_data_set_str(MT *mt, const char *str)
{
  TT *tt;
  
  tt = mt_data_get(mt);
  if (!tt)
  {
    tt = tt_new();
    tt_add_as_first_child(TT(mt), tt);
  }
  
  tt_data_set_str(tt, str);
}


void mt_data_set_bytes(MT *mt, byte *src, u32 start, u32 len)
{
  TT *tt;
  
  tt = mt_data_get(mt);
  if (!tt) return;
  
  tt_data_set_bytes(tt, src, start, len);
}


void mt_data_append_bytes(MT *mt, byte *src, u32 len)
{
  TT *tt;
  
  tt = mt_data_get(mt);
  if (!tt) return;
  
  tt_data_append_bytes(tt, src, len);
}


void mt_data_prepend_bytes(MT *mt, byte *src, u32 len)
{
  TT *tt;
  
  tt = mt_data_get(mt);
  if (!tt) return;
  
  tt_data_prepend_bytes(tt, src, len);
}

