package net.styx.flux.comm;

public class Transaction {
    short transid;
    TTreeComm comm;
    TransactionListener listener;

    Transaction (TTreeComm comm, short transid, TransactionListener listener) {
	this.transid = transid;
	this.comm = comm;
	this.listener = listener;
    }

    public void write (TTree ttree) {
	comm.queueOutgoingTTree(ttree, transid);
    }

    public short getTransID() {
	return transid;
    }

    public TTreeComm getTTreeComm() {
	return comm;
    }

    public TransactionListener getListener() {
	return listener;
    }
}
