/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.exml;

/**
 * A common interface for XML node classes.
 * This is a very brief version of the <code>org.w3c.Node</code> object.
 */
public interface Node 
{
	/**
	 * Node is an Element.
	 * @see Element
	 */
	short ELEMENT_NODE = 1;

	/** 
	 * Node is a CharacterData instance.
	 * @see CharacterData
	 */
	short TEXT_NODE = 2;

	/** 
	 * Node is a Comment.
	 * @see Comment
	 */
	short COMMENT_NODE = 3;

	/** 
	 * Node is a Processing Instruction.
	 * @see PI
	 */
	short PI_NODE = 4;

	/** 
	 * Node is a Document.
	 * @see Document
	 */
	short DOCUMENT_NODE = 5;

	/** Returns this Node's Type */
	short getNodeType();

	/**
	 * Returns this <code>Node</code> as it would
	 * appear in an XML document.
	 */
	String toString();

}
