/*

    FFT filter
    Copyright (C) 1999-2000 Jussi Laako

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "dsp/DSPOp.hh"


#ifndef FILTER_HH
    #define FILTER_HH


    class clFilter : private clDSPOp
    {
            bool bInitialized;
            bool bUseWindow;
            long lWinSize;
            long lFFTSize;
            long lSpectPoints;
            long lLPIdx;
            long lBPLP;
            long lBPHP;
            clDSPAlloc Win;
            clDSPAlloc InvWin;
            clDSPAlloc CoeffWin;
            clDSPAlloc Prev;
            clDSPAlloc Proc;
            clDSPAlloc CCoeffs;
            clDSPAlloc CProc;
            void InitCoeffsS ();
            void InitCoeffsD ();
            void ReadyFilterS ();
            void ReadyFilterD ();
        public:
            clFilter ();
            ~clFilter ();
            // Initialize filter
            // Note: Filter FFT size is 2 * window size, so there must be
            // window size + 1 coefficients! Window size also must be power
            // of two!
            // (window size, coefficients vector, use window function?)
            bool Initialize (long, const float *, bool);
            bool Initialize (long, const double *, bool);
            // (window size, use window function?)
            bool InitFloat (long, bool);
            bool InitDouble (long, bool);
            // Uninitialize filter
            void Uninitialize ();
            // Set coefficients
            // (coefficients vector)
            void SetCoeffs (const float *);
            void SetCoeffs (const double *);
            // Get coefficients
            // (coefficients vector)
            void GetCoeffs (float *);
            void GetCoeffs (double *);
            // Filter data in-place
            // (source&destination vector)
            void Process (float *);
            void Process (double *);
            // Filter data in-place using provided complex coefficients
            // (source&destination vector, coefficients)
            void Process (float *, const stpSCplx);
            void Process (double *, const stpDCplx);
            // Filter data out-of-place
            // (destination vector, source vector)
            void Process (float *, const float *);
            void Process (double *, const double *);
            // Filter data out-of-place using provided complex coefficients
            // (destination vector, source vector, coefficients)
            void Process (float *, const float *, const stpSCplx);
            void Process (double *, const double *, const stpDCplx);
            // Filter data in-place, fast
            // (source&destination vector)
            void ProcessLP (float *);
            void ProcessLP (double *);
            // Filter data out-of-place, fast
            // (destination vector, source vector)
            void ProcessLP (float *, const float *);
            void ProcessLP (double *, const double *);
            // Band-pass filter data in-place, fast
            // (source&destination vector)
            void ProcessBP (float *);
            void ProcessBP (double *);
            // Band-pass filter data out-of-place, fast
            // (destination vector, source vector)
            void ProcessBP (float *, const float *);
            void ProcessBP (double *, const double *);
            // Design low-pass filter
            // (corner frequency (in/out), samplerate)
            void DesignLP (float *, int);
            void DesignLP (double *, int);
            // Design narrow low-pass filter (for decimation and interpolation)
            // (corner frequency (in/out), samplerate)
            void DesignNarrowLP (float *, int);
            void DesignNarrowLP (double *, int);
            // Design high-pass filter
            // (corner frequency (in/out), samplerate)
            void DesignHP (float *, int);
            void DesignHP (double *, int);
            // Design band-pass filter
            // (lower corner freq (i/o), higher corner freq (i/o), samplerate)
            void DesignBP (float *, float *, int);
            void DesignBP (double *, double *, int);
            // Design narrow band-pass filter (for zoomed spectrum)
            // (lower corner freq (i/o), higher corner freq (i/o), samplerate)
            void DesignNarrowBP (float *, float *, int);
            void DesignNarrowBP (double *, double *, int);
            // Design band-reject filter
            // (lower corner freq (i/o), higher corner freq (i/o), samplerate)
            void DesignBR (float *, float *, int);
            void DesignBR (double *, double *, int);
            // Design lowpass filter using frequency divisor
            // (frequency divisor)
            void DesignLP (float);
            void DesignLP (double);
    };

#endif

