/**
 * @file cache/component/debtags/serializer.h
 * @author Enrico Zini (enrico) <enrico@enricozini.org>
 */

#ifndef APTFRONT_CACHE_COMPONENT_DEBTAGS_SERIALIZER_H
#define APTFRONT_CACHE_COMPONENT_DEBTAGS_SERIALIZER_H

#include <apt-front/forward.h>
#include <apt-front/cache/component/base.h>
#include <tagcoll/Serializer.h>

namespace aptFront {
namespace cache {
namespace component {
namespace debtags {

/**
 * Convert Facets to ints
 */
class FacetIntConverter : public Implementation<FacetIntConverter>,
	public Tagcoll::Converter<aptFront::cache::entity::Facet, int>,
	public Tagcoll::Converter<int, aptFront::cache::entity::Facet>
{
	typedef aptFront::cache::entity::Facet Facet;
	typedef Tagcoll::OpSet<aptFront::cache::entity::Facet> FacetSet;
	typedef Tagcoll::OpSet<int> IntSet;
public:
	virtual int operator()(const aptFront::cache::entity::Facet& item) const;
	virtual aptFront::cache::entity::Facet operator()(const int& item) const;

	virtual IntSet operator()(const FacetSet& item) const
		{ return Tagcoll::Converter<Facet, int>::operator()(item); }
	virtual FacetSet operator()(const IntSet& item) const
		{ return Tagcoll::Converter<int, Facet>::operator()(item); }

	static std::string componentName();
};

/**
 * Convert Facets to strings
 */
class FacetStringConverter : public Implementation<FacetStringConverter>,
	public Tagcoll::Converter<aptFront::cache::entity::Facet, std::string>,
	public Tagcoll::Converter<std::string, aptFront::cache::entity::Facet>
{
	typedef aptFront::cache::entity::Facet Facet;
	typedef Tagcoll::OpSet<aptFront::cache::entity::Facet> FacetSet;
	typedef Tagcoll::OpSet<std::string> StringSet;
public:
	virtual std::string operator()(const aptFront::cache::entity::Facet& item) const;
	virtual aptFront::cache::entity::Facet operator()(const std::string& item) const;

	virtual StringSet operator()(const FacetSet& item) const
		{ return Tagcoll::Converter<Facet, std::string>::operator()(item); }
	virtual FacetSet operator()(const StringSet& item) const
		{ return Tagcoll::Converter<std::string, Facet>::operator()(item); }

	static std::string componentName();
};

/**
 * Convert Tags to ints
 */
class TagIntConverter : public Implementation<TagIntConverter>,
	public Tagcoll::Converter<aptFront::cache::entity::Tag, int>,
	public Tagcoll::Converter<int, aptFront::cache::entity::Tag>
{
	typedef aptFront::cache::entity::Tag Tag;
	typedef Tagcoll::OpSet<aptFront::cache::entity::Tag> TagSet;
	typedef Tagcoll::OpSet<int> IntSet;
public:
	virtual int operator()(const aptFront::cache::entity::Tag& item) const;
	virtual aptFront::cache::entity::Tag operator()(const int& item) const;

	virtual IntSet operator()(const TagSet& item) const
		{ return Tagcoll::Converter<Tag, int>::operator()(item); }
	virtual TagSet operator()(const IntSet& item) const
		{ return Tagcoll::Converter<int, Tag>::operator()(item); }

	static std::string componentName();
};

/**
 * Convert Tags to strings
 */
class TagStringConverter : public Implementation<TagStringConverter>,
	public Tagcoll::Converter<aptFront::cache::entity::Tag, std::string>,
	public Tagcoll::Converter<std::string, aptFront::cache::entity::Tag>
{
	typedef aptFront::cache::entity::Tag Tag;
	typedef Tagcoll::OpSet<aptFront::cache::entity::Tag> TagSet;
	typedef Tagcoll::OpSet<std::string> StringSet;
public:
	virtual std::string operator()(const Tag& item) const;
	virtual Tag operator()(const std::string& item) const;

	virtual StringSet operator()(const TagSet& item) const
		{ return Tagcoll::Converter<Tag, std::string>::operator()(item); }
	virtual TagSet operator()(const StringSet& item) const
		{ return Tagcoll::Converter<std::string, Tag>::operator()(item); }

	TagSet parseTagList(const std::string& str) const;

	static std::string componentName();
};

/**
 * Convert Packages to ints
 */
class PackageIntConverter : public Implementation<PackageIntConverter>,
	public Tagcoll::Converter<aptFront::cache::entity::Package, int>,
	public Tagcoll::Converter<int, aptFront::cache::entity::Package>
{
	typedef aptFront::cache::entity::Package Package;
	typedef Tagcoll::OpSet<aptFront::cache::entity::Package> PackageSet;
	typedef Tagcoll::OpSet<int> IntSet;
public:
	virtual int operator()(const Package& item) const;
	virtual Package operator()(const int& item) const;

	virtual IntSet operator()(const PackageSet& item) const
		{ return Tagcoll::Converter<Package, int>::operator()(item); }
	virtual PackageSet operator()(const IntSet& item) const
		{ return Tagcoll::Converter<int, Package>::operator()(item); }

	static std::string componentName();
};

/**
 * Convert Packages to strings
 */
class PackageStringConverter : public Implementation<PackageStringConverter>,
	public Tagcoll::Converter<aptFront::cache::entity::Package, std::string>,
	public Tagcoll::Converter<std::string, aptFront::cache::entity::Package>
{
	typedef aptFront::cache::entity::Package Package;
	typedef Tagcoll::OpSet<aptFront::cache::entity::Package> PackageSet;
	typedef Tagcoll::OpSet<std::string> StringSet;
public:
	virtual std::string operator()(const Package& item) const;
	virtual Package operator()(const std::string& item) const;

	virtual StringSet operator()(const PackageSet& item) const
		{ return Tagcoll::Converter<Package, std::string>::operator()(item); }
	virtual PackageSet operator()(const StringSet& item) const
		{ return Tagcoll::Converter<std::string, Package>::operator()(item); }

	static std::string componentName();
};

}
}
}
}

#endif
