#include <stdio.h>
#include <mod_xmlrpc_c.h>
#include <xmlrpc.h>

static xmlrpc_value *do_add(xmlrpc_env *env, xmlrpc_value *param, void *ignored)
{
	xmlrpc_value *result;
	xmlrpc_int32 a, b, c;
	
	/* get the function arguments, store them in 'a' and 'b' */
	xmlrpc_parse_value(env, param, "(ii)", &a, &b);
	c = a + b;
	/* generate the function result packet from 'c' */
	result = xmlrpc_build_value(env, "i", c);

	return result;
}

/* This symbol is located in test2.c */
extern int get_integer(void);

struct mod_xmlrpc_func mod_xmlrpc_register[] =
{
	{"math", "add", &do_add, NULL, "i:ii", "Add two integers together, return the result."},
	{"blah", "blah", &get_integer, NULL, "i:", "Return an integer."},
	{0}
};

