/* 
**  encode.c
** $Id: encode.c,v 1.5 2002/05/20 00:45:56 brian Exp $
*/ 
#include "mod_mp3.h"

struct encode_info {
    const char* encoder;
    const char* filename;
};

static int reencode_content(void* data, child_info* ci) {
	struct encode_info* ei;
	int i, argc;
	char** argv;
	char* buf;
	char* cp;

	ei = (struct encode_info*) data;
	buf = malloc(strlen(ei->encoder) + 1);
	strcpy(buf, ei->encoder);
#ifdef DEBUG    
	fprintf(stderr, "encoder is \"%s\"\n", buf);
#endif
	argc = 0;
	for (i = 0; i < 2; i++) {
		if (i == 1) {
			argv = (char**) malloc(sizeof(char*) * (argc + 1));
		}
		argc = 0;
		cp = buf;
		while (*cp) {
			if (*cp != ' ') {
				if (i == 0) {
						argc++;
				} else if (*cp == '%') {
						argv[argc] = (char*) malloc(strlen(ei->filename) + 1);
						strcpy(argv[argc], ei->filename);
						argc++;
				} else {
						argv[argc++] = cp;
				}
				while (*cp && *cp != ' ') cp++;
			} else {
				if (i == 1) *cp = 0;
				cp++;
				while (*cp == ' ') cp++;
			}
		}
	}
	argv[argc] = 0;
	ap_cleanup_for_exec();
#ifdef DEBUG
	printf("about to exec %s with %d args\n", argv[0], argc);
	for (i = 0; argv[i]; i++) {
		printf("\targv[%d] = %s\n", i, argv[i]);
	}
#endif
	execv(argv[0], argv);
	/* NOT REACHED */
	free(buf);
	free(argv);
	exit(1);
	return 0;
}

MP3_EXPORT(FILE *)open_content(request_rec* r, mp3_conf* cfg, mp3_data* content) {
	FILE* out = NULL;
	struct encode_info ei;

#ifdef DEBUG
	printf("Opening %s (cfg->encoder)\n", content->filename);
#endif
	if (cfg->encoder == 0) {
		return ap_pfopen(r->pool, content->filename, "r");
	} else {
		ei.encoder = cfg->encoder;
		ei.filename = content->filename;
		ap_spawn_child(r->pool, reencode_content, &ei, kill_always, 0, &out, 0);
		return out;
	}

	return NULL;
}
