#ifndef TLMPMOD_H
#define TLMPMOD_H

#ifndef MODULE_H
	#include <module.h>
#endif

class M_DIALOG;

#define _TLMP_TLMP_MODULE

struct _F_TLMP_MODULE{
	class TLMP_MODULE_PRIVATE *priv;
	// Put any load time initialisation code here, if needed.
	#define _F_TLMP_MODULE_init(nom) void nom init()
	virtual _F_TLMP_MODULE_init( );
	#define _F_TLMP_MODULE_setmenu(nom) void nom setmenu(M_DIALOG &dia, MENU_CONTEXT context)
	virtual _F_TLMP_MODULE_setmenu( )=0;
	#define _F_TLMP_MODULE_domenu(nom) int nom domenu(MENU_CONTEXT context,const char *key)
	virtual _F_TLMP_MODULE_domenu( )=0;
	#define _F_TLMP_MODULE_dohtml(nom) int nom dohtml(const char *key)
	virtual _F_TLMP_MODULE_dohtml( );
	// Called for linuxconf --modulemain modulename ...
	// where modulename is the modulename exactly
	#define _F_TLMP_MODULE_execmain(nom) int nom execmain(const char *progname, int argc, char *argv[], bool standalone)
	virtual _F_TLMP_MODULE_execmain( );
	// othermain allows a module to react to several name
	// progname must be check and LNCF_NOT_APPLICABLE must
	// be returned if it does not match any name
	#define _F_TLMP_MODULE_othermain(nom) int nom othermain(const char *progname, int argc, char *argv[], bool standalone)
	virtual _F_TLMP_MODULE_othermain( );
	#define _F_TLMP_MODULE_usage(nom) void nom usage(SSTRINGS &tb)
	virtual _F_TLMP_MODULE_usage( )=0;
	void printusage();
	#define _F_TLMP_MODULE_message(nom) int nom message(const char *msg, int argc, const char *argv[])
	virtual _F_TLMP_MODULE_message( );
	#define _F_TLMP_MODULE_probe(nom) int nom probe(int level, int target, bool simulation)
	virtual _F_TLMP_MODULE_probe( );
};	

class TLMP_MODULE: public LINUXCONF_MODULE{
	TLMP_MODULE_PRIVATE *priv;
	/*~PROTOBEG~ TLMP_MODULE */
public:
	TLMP_MODULE (_F_TLMP_MODULE&_c,
		 const char *modname,
		 const char *pkgrev);
	int dohtml (const char *key);
	int domenu (MENU_CONTEXT context, const char *key);
	int execmain (int argc,
		 char *argv[],
		 bool standalone);
	int message (const char *msg,
		 int argc,
		 const char *argv[]);
	int probe (int level, int target, bool simulation);
	void setmenu (M_DIALOG&dia, MENU_CONTEXT context);
	void usage (SSTRINGS&tb);
	/*~PROTOEND~ TLMP_MODULE */
};


#endif

