#include <stdio.h>
#include <sys/stat.h>
#include "tlmplib.h"
#include "tlmplib.m"

void _F_copyfile::fail(const char *src, const char *dst, const char *details)
{
	tlmp_error (MSG_U(E_COPYFAIL,"Copy file failed: %s -> %s\n%s\n")
		,src,dst,details);
}

void _F_copyfile::progress (
	const char *src,
	const char *dst,
	size_t size,
	size_t sofar,
	bool &end)
{
}

int copyfile (
	_F_copyfile &c,
	const char *src,	// Source file
	const char *dst)	// Destination
{
	c.priv = NULL;
	int ret = -1;
	FILE *fin = fopen (src,"r");
	if (fin == NULL){
		c.fail (src,dst,MSG_U(E_OPENSRCFILE,"Can't open source"));
	}else{
		FILE *fout = fopen (dst,"w");
		if (fout == NULL){
			c.fail (src,dst,MSG_U(E_OPENDSTFILE,"Can't open destination"));
		}else{
			struct stat st;
			if (fstat(fileno(fin),&st)==-1){
				c.fail (src,dst,MSG_U(E_STATSRCFILE,"Can't get statistics of source file"));
			}else{
				size_t sofar = 0;
				char buffer[32*1024];
				size_t n;
				bool end = false;
				c.progress (src,dst,st.st_size,0,end);
				ret = 0;
				while (!end && (n=fread(buffer,1,sizeof(buffer),fin))>0){
					if (fwrite(buffer,1,n,fout)!=n){
						c.fail(src,dst,MSG_U(E_WRITE
							,"Error while writing to destination file"));
						break;
					}
					sofar += n;
					c.progress (src,dst,st.st_size,sofar,end);
				}
			}
			fclose (fout);
		}
		fclose (fin);
	}
	return ret;
}

