GCC=gcc
EGCS=$(shell test -f /usr/bin/egcs && /bin/echo -n 1)
ifeq ($(EGCS),1)
# RedHat has decided that egcs was for rh6.2 compatibility
# instead of using an environment variable. Very odd
# On rh7, we will use gcc. At some point egcs will be history anyway
RH7=$(shell grep "release 7" /etc/redhat-release 2>/dev/null | wc -l)
RH7_=$(shell expr $(RH7))
ifeq ($(RH7_),1)
GPPLINK=gcc
GPP=gcc
else
GPPLINK=egcs
GPP=egcs
endif
else
GPP=g++
# check for g++ 2.7
GCC27=$(shell g++ -v 2>&1 | grep version | grep 2.7.2 | wc -l)
GCC27_=$(shell expr $(GCC27))
ifeq ($(GCC27_),1)
# Using g++ to link pulls libg++ even if the program does not need it
GPPLINK=gcc
else
GPPLINK=g++
endif
endif
CC=gcc
LINUXCONF_REV=1.26
LINUXCONF_SUBREV=4
LINUXCONF_SUBSUBREV=0
# liblinuxconf revision
LIB_REV=1
ifeq ($(LINUXCONF_SUBSUBREV),0)
ifeq ($(LINUXCONF_SUBREV),0)
PACKAGE_REV=$(LINUXCONF_REV)
else
PACKAGE_REV=$(LINUXCONF_REV)r$(LINUXCONF_SUBREV)
endif
else
PACKAGE_REV=$(LINUXCONF_REV)r$(LINUXCONF_SUBREV).$(LINUXCONF_SUBSUBREV)
endif

BIN=$(RPM_BUILD_ROOT)/bin
USRBIN=$(RPM_BUILD_ROOT)/usr/bin
SBIN=$(RPM_BUILD_ROOT)/sbin
INCLUDE=$(RPM_BUILD_ROOT)/usr/include
USRLIB=$(RPM_BUILD_ROOT)/usr/lib
ETC=$(RPM_BUILD_ROOT)/etc
LIB_LINUXCONF=$(RPM_BUILD_ROOT)/usr/lib/linuxconf
LIB_LINUXCONF_LIB=$(LIB_LINUXCONF)/lib
LIB_LINUXCONF_INSTALL=$(LIB_LINUXCONF)/install
X11R6_BIN=$(RPM_BUILD_ROOT)/usr/X11R6/bin

WWWBASE=$(HOME)/n/dnshtml
WWWTECHBASE=$(WWWBASE)/linuxconf/tech
SPEC_FILE = $(shell $(GCC) -v 2>&1 | head -1 | sed 's/^.* //')
LD_LINUX = $(patsubst ld-linux%.so.2,ld-linux.so.2,$(notdir $(shell cat $(SPEC_FILE) | sed -n -e '/:-dynamic-linker/s/^.*:-dynamic-linker \([^}]*\).*/\1/p')))
ifeq ($(LD_LINUX),ld-linux.so.2)
CRYPTLIB=-lcrypt
PAMLIB=-lpam
GLIBC=on
LIBNCURSES=-lncurses
else
# This is libc 5
# To solve a distribution problem with ncurses, we link statically
# Caldera is shipping ncurses 4 and the other version 3
LIBNCURSES=-Xlinker -Bstatic -lncurses -Xlinker -Bdynamic
endif
HAS_PAM=$(shell test -f /lib/libpam.so -o -f /usr/lib/libpam.so && echo 1)
ifeq ($(HAS_PAM),1)
PAM_FLAGS=-DHAS_PAM
endif
ifeq ($(shell id -u),0)
ISROOT=1
INSTROOT=-o root -g root
endif

all:
ifdef DIRS
	@for i in $(DIRS); do make GCC=$(GCC) GPP=$(GPP) CRYPTLIB=$(CRYPTLIB) -C $$i $@ || exit 1; done
endif


checker:
	@$(MAKE) GPP=checkerg++ GCC=checkergcc all

LIBGD=-L/usr/X11R6/lib -lgd -lpng -lz

ifndef LINUXCONF_PATH
LINUXCONF_PATH=..
LINUXCONF_HELP=../messages/sources
LINUXCONF_MSG=linuxconf-msg
MSGDICS=askrunlevel dialog fstab misc main netconf \
		userconf xconf diajava tlmplib tlmpdia tlmpnet
endif

ifdef DIRS
install: $(LOCAL_INSTALL) install_subdirs $(LOCAL_POSTINSTALL)

install_subdirs:
	@echo doing subdirs
	@for i in $(DIRS); do make -C $$i install  || exit 1 ; done
	@echo end subdirs

else
install: $(LOCAL_INSTALL) $(LOCAL_POSTINSTALL)
endif


ifdef DIRS
clean: $(LOCAL_CLEAN)
	rm -f x *.o *.os *.obt *.bak .bak *~ *.a *.old *.log *.nap *.nar core
	@for i in $(DIRS); do make -C $$i clean  || exit 1; done
else
clean: $(LOCAL_CLEAN)
	rm -f x *.o *.os *.obt *.bak *~ *.a *.old *.log *.nap *.nar core
endif

# We link libgd statically since it is not a widespread package
LIBS = \
	 ../diajava/diajava.o ../diajava/_dict.o \
	../tlmp/tlmpdia/*.o ../tlmp/tlmplib/*.o ../tlmp/tlmpmod/*.o \
	../askrunlevel/askrunlevel.a \
	../netconf/netconf.a \
	../fstab/fstab.a \
	../xconf/xconf.a ../userconf/userconf.a\
	../translate/translate.a ../misc/misc.a \
	../modapi/modapi.a ../dialog/dialog.a \
	$(LIBNCURSES) $(LIBDYNAMIC) $(CRYPTLIB) \
	$(LIBGD)

.SUFFIXES: .o .os .obt .help .html .sgml .txt .doc .tex .java .class .tlcc .cc

CPP_DEFINES=-DEXPORT= -DPUBLIC= -DPROTECTED= -DPRIVATE= -DVIRTUAL=
DEF_NCURSES=-DHAVE_NCURSES -I/usr/include/ncurses
# libgd header are either in /usr/include or /usr/include/gd.
# We check both places
DEF_LIBGD=-I/usr/include/gd
ifdef OLDGCC
FLAGS=-funsigned-char -g -O2 -Wall -DLINUXCONF_AOUT
BINFORM=aout
else
# For gcc 2.7.x
# FLAGS = -fno-for-scope
FLAGS=-funsigned-char -g -O2 -Wall -D_GNU_SOURCE
BINFORM=elf
LIBDYNAMIC=-ldl
OPTDYNAMIC=-rdynamic
endif

INCLUDES=-I../misc -I../dialog -I../modapi -I../userconf -I../translate \
	-I../netconf -I../xconf -I../dnsconf -I../mailconf -I../fstab \
	-I../diajava -I../modules

.tlcc.o:
	@echo "    " $<
	@$(LINUXCONF_PATH)/utils/tlcc $< `basename $< .tlcc`.cpp
	@$(GPP) -DLINUXCONF_REVISION=\"$(LINUXCONF_REV)\" \
			-DLINUXCONF_SUBREVISION=$(LINUXCONF_SUBREV) \
			-DLINUXCONF_SUBSUBREVISION=$(LINUXCONF_SUBSUBREV) \
			-DPACKAGE_REV=\"$(PACKAGE_REV)\" \
			$(MODULE_CFLAGS)  $(PAM_FLAGS) \
		$(INCLUDES) $(CPP_DEFINES) $(DEF_NCURSES) $(DEF_LIBGD) $(FLAGS) \
		-c `basename $< .tlcc`.cpp -o $@ || \
		( rm -f `basename $< .tlcc`.cpp ; exit 1)
	@rm -f `basename $< .tlcc`.cpp

.tlcc.obt:
	@echo "    " $<
	@$(LINUXCONF_PATH)/utils/tlcc $< `basename $< .tlcc`.cpp
	@$(GPP) -DLINUXCONF_REVISION=\"$(LINUXCONF_REV)\" \
			-DLINUXCONF_SUBREVISION=$(LINUXCONF_SUBREV) \
			-DLINUXCONF_SUBSUBREVISION=$(LINUXCONF_SUBSUBREV) \
			-DPACKAGE_REV=\"$(PACKAGE_REV)\" \
			$(MODULE_CFLAGS)  $(PAM_FLAGS) \
		$(INCLUDES) $(CPP_DEFINES) $(DEF_NCURSES) $(DEF_LIBGD) $(FLAGS) \
		-c `basename $< .tlcc`.cpp -o $@ || \
		( rm -f `basename $< .tlcc`.cpp ; exit 1)
	@rm -f `basename $< .tlcc`.cpp

.c.o:
	@echo "    " $<
	@$(GPP) -DLINUXCONF_REVISION=\"$(LINUXCONF_REV)\" \
			-DLINUXCONF_SUBREVISION=$(LINUXCONF_SUBREV) \
			-DLINUXCONF_SUBSUBREVISION=$(LINUXCONF_SUBSUBREV) \
			-DPACKAGE_REV=\"$(PACKAGE_REV)\" \
			$(MODULE_CFLAGS)  $(PAM_FLAGS) \
		$(INCLUDES) $(CPP_DEFINES) $(DEF_NCURSES) $(DEF_LIBGD) $(FLAGS) -c $< -o $@

.tlcc.os:
	@echo "    " $<
	@$(LINUXCONF_PATH)/utils/tlcc $< `basename $< .tlcc`.cpp
	@$(GPP) -fPIC -DLINUXCONF_REVISION=\"$(LINUXCONF_REV)\" \
			-DLINUXCONF_SUBREVISION=$(LINUXCONF_SUBREV) \
			-DLINUXCONF_SUBSUBREVISION=$(LINUXCONF_SUBSUBREV) \
			-DPACKAGE_REV=\"$(PACKAGE_REV)\" \
			$(MODULE_CFLAGS)  $(PAM_FLAGS)  \
		$(INCLUDES) $(CPP_DEFINES) $(DEF_NCURSES) $(DEF_LIBGD) $(FLAGS) \
		-c `basename $< .tlcc`.cpp -o $@ || \
		( rm -f `basename $< .tlcc`.cpp ; exit 1)
	@rm -f `basename $< .tlcc`.cpp


.c.os:
	@echo "    " $<
	@$(GPP) -fPIC -DLINUXCONF_REVISION=\"$(LINUXCONF_REV)\" \
			-DLINUXCONF_SUBREVISION=$(LINUXCONF_SUBREV) \
			-DLINUXCONF_SUBSUBREVISION=$(LINUXCONF_SUBSUBREV) \
			-DPACKAGE_REV=\"$(PACKAGE_REV)\" \
			$(MODULE_CFLAGS)  $(PAM_FLAGS)  \
		$(INCLUDES) $(CPP_DEFINES) $(DEF_NCURSES) $(DEF_LIBGD) $(FLAGS) -c $< -o $@

# Trick to compile test program at the end of a source
.c.obt:
	@echo $< '->' $@
	@$(GPP) -DLINUXCONF_REVISION=\"$(LINUXCONF_REV)\" \
			-DLINUXCONF_SUBREVISION=$(LINUXCONF_SUBREV) \
			-DPACKAGE_REV=\"$(PACKAGE_REV)\" \
			$(MODULE_CFLAGS)  $(PAM_FLAGS) \
			-DTEST $(CPP_DEFINES) \
		$(INCLUDES) $(DEF_NCURSES) $(DEF_LIBGD) $(FLAGS) -c $< -o $@

.cc.o:
	@echo "    " $<
	@$(GPP) -DLINUXCONF_REVISION=\"$(LINUXCONF_REV)\" \
			-DLINUXCONF_SUBREVISION=$(LINUXCONF_SUBREV) \
			-DLINUXCONF_SUBSUBREVISION=$(LINUXCONF_SUBSUBREV) \
			-DPACKAGE_REV=\"$(PACKAGE_REV)\" \
			$(MODULE_CFLAGS) $(PAM_FLAGS) \
		$(INCLUDES) $(CPP_DEFINES) $(DEF_NCURSES) $(DEF_LIBGD) $(FLAGS) -c $< -o $@

.cc.os:
	@echo "    " $<
	@$(GPP) -fPIC -DLINUXCONF_REVISION=\"$(LINUXCONF_REV)\" \
			-DLINUXCONF_SUBREVISION=$(LINUXCONF_SUBREV) \
			-DLINUXCONF_SUBSUBREVISION=$(LINUXCONF_SUBSUBREV) \
			-DPACKAGE_REV=\"$(PACKAGE_REV)\" \
			$(MODULE_CFLAGS) $(PAM_FLAGS) \
		$(INCLUDES) $(CPP_DEFINES) $(DEF_NCURSES) $(DEF_LIBGD) $(FLAGS) -c $< -o $@

# Trick to compile test program at the end of a source
.cc.obt:
	@echo $< '->' $@
	@$(GPP) -DLINUXCONF_REVISION=\"$(LINUXCONF_REV)\" \
			-DLINUXCONF_SUBREVISION=$(LINUXCONF_SUBREV) \
			-DPACKAGE_REV=\"$(PACKAGE_REV)\" \
			$(MODULE_CFLAGS)  $(PAM_FLAGS) \
			-DTEST $(CPP_DEFINES) \
		$(INCLUDES) $(DEF_NCURSES) $(DEF_LIBGD) $(FLAGS) -c $< -o $@

# Path of the linuxdoc-sgml package (used to format HOWTOs)
#LINUXDOC=/usr/lib/linuxdoc-sgml/bin
#FORMAT=$(LINUXDOC)/format
#QTEX=$(LINUXDOC)/qtex
#QROFF=$(LINUXDOC)/qroff

.sgml.txt:
	@echo Formatting $< '->' $@
	sgml2txt $(SGMLOPT) $<
	sgml2html $(SGMLOPT) $<

.sgml.html:
	@echo Formatting $< '->' $@
	sgml2html $(SGMLOPT) $<

.sgml.tex:
	@echo Formatting $< '->' $@
	sgml2latex $(SGMLOPT) $<


.txt.help:
	@mv $< $@

.txt.doc:
	@$(LINUXCONF_PATH)/translate/sgml2flat $< $@
	@rm -f $<
	
# Produce the binary dictionnary (Message translation) in /tmp (development)
# English message (originals) 
msg.eng:
	$(LINUXCONF_PATH)/translate/msgcomp -p$(LINUXCONF_HELP)/ \
		/tmp/$(LINUXCONF_MSG)-$(PACKAGE_REV).eng eE \
		$(MSGDICS)

# Install all binary dictionnaries (all available langage) in /usr/lib/linuxconf
msg.install:
	(cd ../messages && make install)

_dict.o: _dict.cc $(CURDIR).m

lib: $(CURDIR).a

$(CURDIR).a: $(OBJS)
	ar cr $(CURDIR).a $(OBJS)
	ranlib $(CURDIR).a

msg:
	$(LINUXCONF_PATH)/translate/msgscan $(CURDIR) \
		$(LINUXCONF_HELP)/$(CURDIR).dic $(CURDIR).m EF *.{cc,tlcc}

msg.clean:
	@test -f $(CURDIR).m || (echo only in a project directory; exit 1)
	$(LINUXCONF_PATH)/translate/msgclean $(LINUXCONF_HELP)/$(CURDIR).dic
	$(LINUXCONF_PATH)/translate/msgscan $(CURDIR) \
		$(LINUXCONF_HELP)/$(CURDIR).dic $(CURDIR).m EF *.{cc,tlcc}
	make clean
	
# make sure the binary dic is updated
_dict.os: _dict.cc $(CURDIR).m

INDEXPREFIX=$(HOME)/.index/linuxconf-$(INDEXSUBDIR)$(CURDIR)
index:
	mkdir -p $(HOME)/.index
	proto -ceo+i -f$(INDEXPREFIX).nar -n`pwd` *cc
	proto -ceo+d -f/tmp/tmp.nap *cc
	naperm /tmp/tmp.nap $(INDEXPREFIX).nai $(INDEXPREFIX).nas

pubspec_xml:
	@mkdir -p /tmp/xml
	nacom -x *cc >/tmp/xml/$(CURDIR).xml

