
#include <stdio.h>
#include <string.h>
#include "wineconf.h"
#include "wineconf.m"
#include <fviews.h>
#include "wineconf_global_defs.h"
#include "wineconf_tools.h"

void manage_internal_directories_settings(VIEWITEMS &vitems_wineconf, CONFIG_FILE &cf_wineconf)
{
    struct {
        SSTRING windows, system, temp, path, profile;
    } my_intdir;
    DIALOG      my_dialog;
    char        my_groupname[]="wine";
    MENU_STATUS my_button=(MENU_STATUS)0;
    int         my_selection=0;

    /* loads local vars with data from file */
    load_var_data(my_groupname, "Windows", vitems_wineconf, my_intdir.windows);
    load_var_data(my_groupname, "System", vitems_wineconf, my_intdir.system);
    load_var_data(my_groupname, "Temp", vitems_wineconf, my_intdir.temp);
    load_var_data(my_groupname, "Path", vitems_wineconf, my_intdir.path);
    load_var_data(my_groupname, "Profile", vitems_wineconf, my_intdir.profile);
    /* builds window */
    my_dialog.newf_str(MSG_U(F_WINDOWS, "Windows:"), my_intdir.windows);
    my_dialog.newf_str(MSG_U(F_SYSTEM, "System:"), my_intdir.system);
    my_dialog.newf_str(MSG_U(F_TEMP, "Temp:"), my_intdir.temp);
    my_dialog.newf_str(MSG_U(F_PATH, "Path:"), my_intdir.path);
    my_dialog.newf_str(MSG_U(F_PROFILE, "Profile:"), my_intdir.profile);

    /* opens window.. */
    my_selection=0;
    my_button=my_dialog.editmenu(MSG_U(T_INTERNALDIRS, "Internal directories"), MSG_U(I_INTERNALDIRS, "These are directories defined\nwithin Wine's drives.\nThey must be specified in DOS style."), int_dirs_helpfile, my_selection, MENUBUT_QUIT|MENUBUT_ACCEPT);

    /* now user pressed some button, let's have some processing.. */

    switch(my_button){
    case MENU_QUIT:
    case MENU_ESCAPE:
        return;
    case MENU_ACCEPT:
        {
            /* update file with data from local vars */
            write_var_data(my_groupname, "Windows", my_intdir.windows.get(), vitems_wineconf, 1);
            write_var_data(my_groupname, "System", my_intdir.system.get(), vitems_wineconf, 1);
            write_var_data(my_groupname, "Temp", my_intdir.temp.get(), vitems_wineconf, 1);
            write_var_data(my_groupname, "Path", my_intdir.path.get(), vitems_wineconf, 1);
            write_var_data(my_groupname, "Profile", my_intdir.profile.get(), vitems_wineconf, 1);

            vitems_wineconf.write(cf_wineconf, NULL);
        }
    default:
        break;
    }
}

