#include <ctype.h>
#include <misc.h>
#include "redhat.h"
#include <netconf.h>
#include <subsys.h>
#include <string.h>

static HELP_FILE help_routes ("redhat","static-routes");

static CONFIG_FILE f_staticroutes ("/etc/sysconfig/static-routes",help_routes
	,CONFIGF_MANAGED|CONFIGF_OPTIONNAL
	,"root","root",0644
	,subsys_netclient);

int routes_load (ROUTES &rt)
{
	int ret = 0;
	FILE_CFG *fin = f_staticroutes.fopen ("r");
	if (fin != NULL){
		char buf[1000];
		ret = 0;
		while (fgets_strip(buf,sizeof(buf)-1,fin,NULL)!=NULL){
			if (buf[0] != '\0'){
				char word[7][200];
				if (sscanf (buf,"%s %s %s %s %s %s %s"
					,word[0],word[1],word[2],word[3],word[4]
					,word[5],word[6])==7){
					const char *flags = strcmp(word[4],"255.255.255.255")==0
						? "UGH" : "UG";
					const char *gtw = word[6];
					const char *iface = "";
					if (isalpha(*gtw)){
						iface = gtw;
						gtw = "*";
						flags = "U";
					}
					rt.add (new ROUTE (word[2],gtw,word[4],flags,iface));
				}else{
					ret = -1;
				}
			}
		}
		fclose (fin);
	}

	const char *defgtw = linuxconf_getval ("routing","gateway");
	if (defgtw != NULL && defgtw[0] != '\0'){
		rt.add (new ROUTE ("default",defgtw,"","UG",""));
	}
	return ret;
}
int routes_save(
	SSTRING &defroute,
	ROUTES &rts)
{
	int ret = -1;
	char device[20];
	const char *defr = defroute.get();
	netconf_finddevfromhost (defr,device);
	linuxconf_replace ("routing","gateway",defr);
	linuxconf_replace ("routing","gatewaydev",device);
	{
		FILE_CFG *fout = f_staticroutes.fopen ("w");
		if (fout != NULL){
			for (int i=0; i<rts.getnb(); i++){
				ROUTE *r = rts.getitem(i);
				netconf_finddevfromhost (r->getgateway(),device);
				if (device[0] == '\0') strcpy (device,"any");
				const char *mask = r->getmask();
				char defmask[20];
				if (r->dst_is_host()){
					mask = "255.255.255.255";
				}else if (mask[0] == '\0'){
					device_setstdnetmask(r->getdst(),defmask);
					mask = defmask;
				}
				fprintf (fout,"%s net %s netmask %s gw %s\n"
					,device
					,r->getdst(),mask,r->getgateway());
			}
			ret = fclose (fout);
		}
	}
	return ret;
}

