
/*
 Radiusconf v1.0 january 10th, 2001
 by Daniel Mealha Cabrita (dancab@conectiva.com)
 */

#pragma implementation
#include <stdio.h>
#include <string.h>
#include <translat.h>
#include "radiusconf.h"
#include "radiusconf.m"
#include <netconf_def.h>

#include "rc_main.cc"

MODULE_DEFINE_VERSION(radiusconf);

PUBLIC MODULE_radiusconf::MODULE_radiusconf()
	: LINUXCONF_MODULE("radiusconf")
{
	linuxconf_loadmsg ("radiusconf",PACKAGE_REV);
}


static const char *keymenu=NULL;

PUBLIC void MODULE_radiusconf::setmenu (
	DIALOG &dia,
	MENU_CONTEXT context)
{
	if (context == MENU_NETWORK_SERVER){
		keymenu = MSG_U(M_radiusconf,"Radius configurator");
		dia.new_menuitem ("radiusconf","",keymenu);
	}
}

PUBLIC int MODULE_radiusconf::domenu (
	MENU_CONTEXT context,
	const char *key)
{
	if (context == MENU_NETWORK_SERVER){
		if (key == keymenu){
                    show_mainmenu();
                    // ### Place the call to the edit function here
		}
	}
	return 0;
}


PUBLIC int MODULE_radiusconf::dohtml (const char *key)
{
	int ret = LNCF_NOT_APPLICABLE;
	if (strcmp(key,"radiusconf")==0){
		// ### Insert any menu and dialog here
		ret = 0;
	}
	return ret;
}


static void usage()
{
	xconf_error (MSG_U(T_USAGE
		,"linuxconf --modulemain radiusconf usage\n"
		 "\n"
		 "    radiusconf --option ...\n")
		);
}

PUBLIC void MODULE_radiusconf::usage (SSTRINGS &tb)
{
	tb.add (new SSTRING (MSG_R(T_USAGE)));
}

PUBLIC int MODULE_radiusconf::execmain (int argc , char *argv[], bool standalone)
{
	int ret = LNCF_NOT_APPLICABLE;
	const char *pt = strrchr(argv[0],'/');
	if (pt != NULL){
		pt++;
	}else{
		pt = argv[0];
	}
	if (strcmp(pt,"radiusconf")==0){
		ret = -1;
		if (argc == 1){
			// ### Place call to main menu of the module
                    show_mainmenu();
                }else{
			// ### Add some option parsing for the module
			::usage();
		}
	}
	return ret;
}

PUBLIC int MODULE_radiusconf::probe (int level, int target, bool simul)
{
    if(level==2){
        int it_must_be_restarted=0; /* true, if radius needs to be restarted */

        /* looks at each radius config files to know if restarting is needed */
        it_must_be_restarted|=was_this_changed(cf_clients, "radiusconf_cf_clients", simul);
        it_must_be_restarted|=was_this_changed(cf_hints, "radiusconf_cf_hints", simul);
        it_must_be_restarted|=was_this_changed(cf_huntgroups, "radiusconf_cf_huntgroups", simul);
        it_must_be_restarted|=was_this_changed(cf_naslist, "radiusconf_cf_naslist", simul);
        it_must_be_restarted|=was_this_changed(cf_naspasswd, "radiusconf_cf_naspasswd", simul);
        it_must_be_restarted|=was_this_changed(cf_realms, "radiusconf_cf_realms", simul);
        it_must_be_restarted|=was_this_changed(cf_users, "radiusconf_cf_users", simul);

        if(it_must_be_restarted){
            if(simul==false){
                net_title(MSG_U(T_RADIUSMUSTBERESTARTED,"Radius configurations were changed"));
                netconf_system_if("radiusd", "restart");
            }
            net_prtlog(NETLOG_CMD, MSG_U(X_EXECUTINGRADIUSDRESTART,"Executing: radiusd restart\n"));
            net_prtlog(NETLOG_WHY, MSG_U(X_CFGFILESCHANGED,"One or more config files were changed. The service must be restarted.\n"));
        }
    }

    return(0);
}


static MODULE_radiusconf radiusconf;

