#include <Python.h>
#include "../pythonmod.h"

static PyObject *ErrorObject;

PyObject *
LCStrings_append(LCStringsObject *self, PyObject *args)
{
	PyObject *strobj;
	if (!PyArg_ParseTuple(args,"O",&strobj))
		return NULL;
	if (PyString_Check(strobj))
		self->ss->add(new SSTRING(PyString_AsString(strobj)));
	else if (LCString_Check(strobj))
		self->ss->add(new SSTRING(*(LCString_AsString(strobj))));
	else
		return NULL;
	Py_INCREF(Py_None);
	return Py_None;
}

static struct PyMethodDef LCStrings_methods[] = {
	{"append", (binaryfunc) LCStrings_append, 1},
	{NULL, NULL}
};

static int
LCStrings_length(LCStringsObject *self)
{
	return self->ss->getnb();
}

static PyObject *
LCStrings_item(LCStringsObject *self, int index)
{
	if (index < 0 || index >= self->ss->getnb()) {
		PyErr_SetString(PyExc_IndexError, "index out-of-bounds");
		return NULL;
	}
	return LCString_FromString(self->ss->getitem(index));
}

static PySequenceMethods LCStrings_sequence_methods = {
	(inquiry) LCStrings_length,
	(binaryfunc) 0,
	(intargfunc) 0,
	(intargfunc) LCStrings_item,
	(intintargfunc) 0,
	(intobjargproc) 0,
	(intintobjargproc) 0
};

static void
LCStrings_dealloc(LCStringsObject *self)
{
	if (self->owner)
		delete self->ss;
	PyMem_DEL(self);
}

static PyObject *
LCStrings_getattr(LCStringsObject *self, char *name)
{
	return Py_FindMethod(LCStrings_methods, (PyObject*) self, name);
}

PyTypeObject LCStrings_Type = {
	PyObject_HEAD_INIT(&PyType_Type)
	0,
	"LCStrings",
	sizeof(LCStringsObject),
	0,
	(destructor) LCStrings_dealloc,
	(printfunc) 0,
	(getattrfunc) LCStrings_getattr,
	(setattrfunc) 0,
	(cmpfunc) 0,
	(reprfunc) 0,
	0,
	&LCStrings_sequence_methods,
	0,
	(hashfunc) 0,
	(ternaryfunc) 0,
	(reprfunc) 0
};

PyObject *
LCStrings_New()
{
	LCStringsObject *self;
	self = PyObject_NEW(LCStringsObject, &LCStrings_Type);
	if (self == NULL)
		return NULL;
	self->ss = new SSTRINGS();
	self->owner = 1;
	return (PyObject*) self;
}

PyObject *
LCStrings_FromStrings(SSTRINGS *ss)
{
	LCStringsObject *self;
	self = PyObject_NEW(LCStringsObject, &LCStrings_Type);
	if (self == NULL)
		return NULL;
	self->ss = ss;
	self->owner = 0;
	return (PyObject*) self;
}

PyObject *
LCStrings_FromStringsDealloc(SSTRINGS *ss)
{
	LCStringsObject *self;
	self = PyObject_NEW(LCStringsObject, &LCStrings_Type);
	if (self == NULL)
		return NULL;
	self->ss = ss;
	self->owner = 1;
	return (PyObject*) self;
}

static PyObject *
lcstrings_LCStrings(PyObject *self, PyObject *args)
{
	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	return LCStrings_New();
}

static struct PyMethodDef lcstrings_methods[] = {
	{"LCStrings", lcstrings_LCStrings, 1},
	{NULL,NULL}
};

extern "C" void
initlcstrings()
{
	PyObject *m, *d;
	m = Py_InitModule("lcstrings", lcstrings_methods);
	d = PyModule_GetDict(m);
	ErrorObject = Py_BuildValue("s", "lcstrings.error");
	PyDict_SetItemString(d, "error", ErrorObject);
	if (PyErr_Occurred())
		Py_FatalError("can't initialize module lcstrings");
}
