// vim: nowrap

#include "postfixconf.h"
#include "postfixconf.m"
#include "string.h"

/*
DESCRIPTION: This DIALOG contains settings that I don't now where its must be
RETURN: 0 - case the user accept the changes
        1 - case the user cancel the changes
*/
PUBLIC int MODULE_postfixconf::spamctrl_edit(DATAMAIN &data){
	int ret = 0;
	int nof = 0;
	DIALOG dia;
	SSTRING *st;
	// - - - Address extensions - - -
	dia.newf_title (MSG_U(T_ADDRESSEXT,"Address extensions"),1,"",MSG_R(T_ADDRESSEXT));
	
	// recipient_delimiter		nof=1
	st = data.getvarvariable(V_RECIPIENT_DELIMITER);
	dia.newf_str(MSG_U(F_RECDELIMITER,"Recipient delimiter"),*st);

	// - - - Junk mail controls - - -
	dia.newf_title (MSG_U(T_JUNKMAILCTRL,"Junk mail controls"),1,"",MSG_R(T_JUNKMAILCTRL));

	// header_checks		nof=3
	st = data.getvarvariable(V_HEADER_CHECKS);
	dia.newf_str(MSG_U(F_HEADERCHECKS,"Header checks"),*st);

	// body_checks			nof=4
	st = data.getvarvariable(V_BODY_CHECKS);
	dia.newf_str(MSG_U(F_BODYCHECKS,"Body checks"),*st);
	
	// mynetworks			nof=5
	st = data.getvarvariable(V_MYNETWORKS);
	dia.newf_str(MSG_U(F_NETWORKS,"Networks"),*st);
	
	// - - - ADDITIONAL UCE CONTROLS - - -
	dia.newf_title (MSG_U(T_ADDITIONALUCECTRL,"Additional UCE controls"),1,"",MSG_R(T_ADDITIONALUCECTRL));
	
	// allow_untrusted_routing	nof=7
	st = data.getvarvariable(V_ALLOW_UNTRUSTED_ROUTING);
	char var_alluntrout = getvalue_yesno (st);
	const char *opt_alluntrout[] = {MSG_R(X_YES),MSG_R(X_NO),NULL};
	dia.newf_chkm (MSG_U(F_ALLOWUNTRUSTEDROUTING,"Allow untrusted routing"),var_alluntrout,opt_alluntrout);
	
	// maps_rbl_domains		nof=8
	st = data.getvarvariable(V_MAPS_RBL_DOMAINS);
	dia.newf_str(MSG_U(F_MAPSRBLDOMAINS,"Maps rbl domains"),*st);
	
	// relay_domains		nof=9
	st = data.getvarvariable(V_RELAY_DOMAINS);
	dia.newf_str(MSG_U(F_RELAYDOMAINS,"Relay domains"),*st);

	// relayhost			nof=10
	st = data.getvarvariable(V_RELAYHOST);
	dia.newf_str(MSG_U(F_RELAYHOST,"Relay host"),*st);
	
	// - - - SMTPD RESTRICTIONS - - -
	dia.newf_title (MSG_U(T_SMTPDRESTRICTION,"Smtpd restrictions"),1,"",MSG_R(T_SMTPDRESTRICTION));
	
	// smtpd_etrn_restrictions
	dia.newf_title (MSG_U(T_SMTPDETRNREST,"etrn"),2,"",MSG_R(T_SMTPDETRNREST));
	
	st = data.getvarvariable(V_SMTPD_ETRN_RESTRICTIONS); // set the pointer to actual variable
	char var_smtpdetrnrest[7]; // store the state of items   enable/disable
	SSTRING str1_smtpdetrnrest, str2_smtpdetrnrest; // strings que contem entradas do usuario
	// contain possible items of variable
	const char *param_smtpdetrnrest[] = {"reject_unknown_client","permit_mynetworks","check_client_access",
					     "maptype:mapname","reject_maps_rbl","reject","permit",NULL};
	{ // this block is used to 

		const char *tmp_smtpdetrnrest = st->get(); // pointer to variable

		SSTRINGS *strs = data.str_popul_sstrings(tmp_smtpdetrnrest); // populate the items of variable
		bool need_commas = 0;
		if (strs!=NULL){
			// parse each item checking the type and for items that have parameter read it.
			// the order of parser is important.
			for (int j=0; j<strs->getnb(); j++){
				char *p;
				
				const char *t = strs->getitem(j)->get();
				// If the item contains a 'check_client_access'
				// we must read read the maptype:mapname
				if ( (p = strstr(t,param_smtpdetrnrest[2])) ){
					if (*(p+19)=='\0')	continue;
					p+= 20;
					str1_smtpdetrnrest.append(p);
					continue;
				}
				if (strstr(t,":")){ // a simple maptype:maptable
					if (need_commas)
						str2_smtpdetrnrest.append(", ");
					str2_smtpdetrnrest.append(t);
					need_commas = 1;
				}
			}
		}
		delete (strs);
		// scan paramaters vector and verify if params are find in variable
		// if yes, set the combo to 0 or 1.
		for (int i=0; param_smtpdetrnrest[i]!=NULL; i++){
			if (i==3)	continue;
			if (i==5 || i==6)
				if (data.strcheckexactly(tmp_smtpdetrnrest, param_smtpdetrnrest[i]))
					var_smtpdetrnrest[i]=1;
				else	var_smtpdetrnrest[i]=0;
			else
				if (strstr(tmp_smtpdetrnrest, param_smtpdetrnrest[i]))	var_smtpdetrnrest[i]=1;
				else	var_smtpdetrnrest[i]=0;
		}
	}
	
	// set the permit, request radio option. Is the permit and reject are at the same time, display an alert
	// and set none.
	char rd_permrej_smtpdetrnrest;
	if (var_smtpdetrnrest[5]==0){
		if (var_smtpdetrnrest[6]==0)
			rd_permrej_smtpdetrnrest = 0;
		else 	rd_permrej_smtpdetrnrest = 2;
	}else{
		if (var_smtpdetrnrest[6]==0)
			rd_permrej_smtpdetrnrest = 1;
		else{
			xconf_notice (MSG_U(N_REJPERMSAMETIME,"You have the 'reject' and 'permit' parameters\n"
					                      "on the same variable and it's not possible.\n"
							      "This option will be set to 'default' value"));
			rd_permrej_smtpdetrnrest = 0;
		}
	}
		
	// add items to dialog
	dia.newf_chk ("",var_smtpdetrnrest[0],MSG_U(F_REJREQCLIENTHOSTM,"reject the request if the client hostname is unknown"));//13
	dia.newf_chk ("",var_smtpdetrnrest[1],MSG_U(F_PERMCLIENTADRSMATMYNET,"permit if the client address matches mynetworks"));//14
        dia.newf_str (MSG_U(F_MAPTYPEMAPNAME,"maptypes and mapnames"),str2_smtpdetrnrest);//17
        dia.newf_info ("", MSG_U(X_MAPTYPEMAPNAMEEX, "(maptype:mapname, maptype:mapname, ...)"));
        dia.newf_chk ("",var_smtpdetrnrest[4],MSG_U(F_REJIFCLIENTLSTDUNDER,"reject if the client is listed under \"maps rbl domains\""));//18
	const char *permrej_smtpdetrnrest[4] = {MSG_U(X_NONE,"none"),MSG_U(F_REJREQUEST,"reject the request"),MSG_U(F_PERMREQUEST,"permit the request"),NULL};
        dia.newf_chkm ("",rd_permrej_smtpdetrnrest, permrej_smtpdetrnrest);//19
        // (check client access)
        dia.newf_title("", MSG_U(F_ACTCHKCLIENTACCMAPTYPEMAPNAME, "Check client access"));
        dia.newf_chk ("",var_smtpdetrnrest[2], MSG_U(F_ACTIVATECHECKBOX,"active"));//15
	dia.newf_str (MSG_U(F_CHKCLIENTACCMAPTYPEMAPNAME,"maptypes and mapnames"),str1_smtpdetrnrest);//16
        dia.newf_info ("", MSG_R(X_MAPTYPEMAPNAMEEX));

	// smtpd_sender_restrictions
	dia.newf_title (MSG_U(T_SMTPDSNDREST,"sender"),2,"",MSG_R(T_SMTPDSNDREST));
	
	st = data.getvarvariable(V_SMTPD_SENDER_RESTRICTIONS);
	char var_smtpdsndrest[14];
	SSTRING str1_smtpdsndrest, str2_smtpdsndrest, str3_smtpdsndrest, str4_smtpdsndrest;
	const char *param_smtpdsndrest[] = {"permit_mynetworks","reject_unknown_client","reject_maps_rbl","reject_invalid_hostname",
					    "reject_unknown_hostname","reject_unknown_sender_domain","check_sender_access",
					     "maptype:mapname","check_client_access","check_helo_access",
					     "reject_non_fqdn_hostname","reject_non_fqdn_sender","reject","permit",NULL};

	{
		const char *tmp_smtpdsndrest = st->get();
		SSTRINGS *strs = data.str_popul_sstrings(tmp_smtpdsndrest);
		bool need_com = 0;
		if (strs!=NULL){
			for (int j=0; j<strs->getnb(); j++){
				char *p;
				const char *t = strs->getitem(j)->get();
				if ( (p = strstr(t,param_smtpdsndrest[6])) ){
					if (*(p+19)=='\0')	continue;
					p+= 20;
					str1_smtpdsndrest.append(p);
					continue;
				}
				if ( (p = strstr(t,param_smtpdsndrest[8])) ){
					if (*(p+19)=='\0')	continue;
					p+= 20;
					str3_smtpdsndrest.append(p);
					continue;
				}
				if ( (p = strstr(t,param_smtpdsndrest[9])) ){
					if (*(p+17)=='\0')	continue;
					p+= 18;
					str4_smtpdsndrest.append(p);
					continue;
				}
				if (strstr(t,":")){
					if (need_com)
						str2_smtpdsndrest.append(", ");
					str2_smtpdsndrest.append(t);
					need_com = 1;
				}
			
			}
			delete (strs);
		}
		for (int i=0; param_smtpdsndrest[i]!=NULL; i++){
			if (i==7)	continue;
			if (i==12 || i==13)
				if (data.strcheckexactly(tmp_smtpdsndrest, param_smtpdsndrest[i]))	var_smtpdsndrest[i]=1;
				else	var_smtpdsndrest[i]=0;
			else
				if (strstr(tmp_smtpdsndrest, param_smtpdsndrest[i]))	var_smtpdsndrest[i]=1;
				else	var_smtpdsndrest[i]=0;
		}
	}
	
	char rd_permrej_smtpdsndrest;
	if (var_smtpdsndrest[12]==0){
		if (var_smtpdsndrest[13]==0)
			rd_permrej_smtpdsndrest = 0;
		else 	rd_permrej_smtpdsndrest = 2;
	}else{
		if (var_smtpdsndrest[13]==0)
			rd_permrej_smtpdsndrest = 1;
		else{
			xconf_notice (MSG_R(N_REJPERMSAMETIME));
			rd_permrej_smtpdsndrest = 0;
		}
	}
	
	dia.newf_chk ("",var_smtpdsndrest[0],MSG_R(F_PERMCLIENTADRSMATMYNET));//21
	dia.newf_chk ("",var_smtpdsndrest[1],MSG_R(F_REJREQCLIENTHOSTM));//22
	dia.newf_chk ("",var_smtpdsndrest[2],MSG_R(F_REJIFCLIENTLSTDUNDER));//23
	dia.newf_chk ("",var_smtpdsndrest[3],MSG_U(F_REJINVHOSTNAME,"reject invalid hostname"));//24
	dia.newf_chk ("",var_smtpdsndrest[4],MSG_U(F_REJUNKHOSTNAME,"reject unknown hostname"));//25
	dia.newf_chk ("",var_smtpdsndrest[5],MSG_U(F_REJUNKSNDDOM,"reject unknown sender domain"));//26
        dia.newf_str (MSG_R(F_MAPTYPEMAPNAME),str2_smtpdsndrest);//29
        dia.newf_info ("", MSG_R(X_MAPTYPEMAPNAMEEX));
        dia.newf_chk ("",var_smtpdsndrest[10],MSG_U(F_REJNONFQDNHOSTNAME,"reject non fqdn hostname"));//34
	dia.newf_chk ("",var_smtpdsndrest[11],MSG_U(F_REJNONFQDNSENDER,"reject non fqdn sender"));//35
	const char *permrej_smtpdsndrest[4] = {MSG_R(X_NONE),MSG_R(F_REJREQUEST),MSG_R(F_PERMREQUEST),NULL};
	dia.newf_chkm ("",rd_permrej_smtpdsndrest, permrej_smtpdsndrest);//36
        // (check sender access)
        dia.newf_title("", MSG_U(F_ACTCHKSNDACCMAPTYPEMAPNAME,"Check sender access"));
        dia.newf_chk ("",var_smtpdsndrest[6], MSG_R(F_ACTIVATECHECKBOX));
	dia.newf_str (MSG_U(F_CHKSNDACCMAPTYPEMAPNAME,"maptypes and mapnames"),str1_smtpdsndrest);//28
        dia.newf_info ("", MSG_R(X_MAPTYPEMAPNAMEEX));
        // (check client access)
        dia.newf_title("", MSG_R(F_ACTCHKCLIENTACCMAPTYPEMAPNAME));
        dia.newf_chk ("", var_smtpdsndrest[8], MSG_R(F_ACTIVATECHECKBOX));
	dia.newf_str (MSG_U(F_CHKCLIENTACCESS,"maptypes and mapnames"),str3_smtpdsndrest);//31
        dia.newf_info ("", MSG_R(X_MAPTYPEMAPNAMEEX));
        // (check helo access)
        dia.newf_title("", MSG_U(F_ACTCHKHELOACCMAPTYPEMAPNAME,"Check helo access"));
        dia.newf_chk ("",var_smtpdsndrest[9], MSG_R(F_ACTIVATECHECKBOX));
	dia.newf_str (MSG_U(F_CHKHELOACCESS,"maptypes and mapnames"),str4_smtpdsndrest);//33
        dia.newf_info ("", MSG_R(X_MAPTYPEMAPNAMEEX));

	// smtpd_client_restrictions
	dia.newf_title (MSG_U(T_SMTPDCLIENTREST,"client"),2,"",MSG_R(T_SMTPDCLIENTREST));
	
	st = data.getvarvariable(V_SMTPD_CLIENT_RESTRICTIONS);
	char var_smtpclntrest[7];
	SSTRING str1_smtpclntrest, str2_smtpclntrest;
	const char *param_smtpclntrest[] = {"reject_unknown_client","permit_mynetworks","check_client_access",
					     "maptype:mapname","reject_maps_rbl","reject","permit",NULL};
	{
		const char *tmp_smtpclntrest = st->get();
		SSTRINGS *strs = data.str_popul_sstrings(tmp_smtpclntrest);
		bool need_commas = 0;
		if (strs!=NULL){
			for (int j=0; j<strs->getnb(); j++){
				char *p;
				const char *t = strs->getitem(j)->get();
				if ( (p = strstr(t,param_smtpclntrest[2])) ){
					if (*(p+19)=='\0')	continue;
					p+= 20;
					str1_smtpclntrest.append(p);
					continue;
				}
				if (strstr(t,":")){
					if (need_commas)
						str2_smtpclntrest.append(", ");
					str2_smtpclntrest.append(t);
					need_commas = 1;
				}
			}
			delete (strs);
		}
		for (int i=0; param_smtpclntrest[i]!=NULL; i++){
			if (i==3)	continue;
			if (i==5 || i==6)
				if (data.strcheckexactly(tmp_smtpclntrest, param_smtpclntrest[i]))	var_smtpclntrest[i]=1;
				else	var_smtpclntrest[i]=0;
			else
				if (strstr(tmp_smtpclntrest, param_smtpclntrest[i]))	var_smtpclntrest[i]=1;
				else	var_smtpclntrest[i]=0;
		}
	}
	
	char rd_permrej_smtpclntrest;
	if (var_smtpclntrest[5]==0){
		if (var_smtpclntrest[6]==0)
			rd_permrej_smtpclntrest = 0;
		else 	rd_permrej_smtpclntrest = 2;
	}else{
		if (var_smtpclntrest[6]==0)
			rd_permrej_smtpclntrest = 1;
		else{
			xconf_notice (MSG_R(N_REJPERMSAMETIME));
			rd_permrej_smtpclntrest = 0;
		}
	}
	
	dia.newf_chk ("",var_smtpclntrest[0],MSG_R(F_REJREQCLIENTHOSTM));//38
	dia.newf_chk ("",var_smtpclntrest[1],MSG_R(F_PERMCLIENTADRSMATMYNET));//39
        dia.newf_str (MSG_R(F_MAPTYPEMAPNAME),str2_smtpclntrest);//42
        dia.newf_info ("", MSG_R(X_MAPTYPEMAPNAMEEX));
	dia.newf_chk ("",var_smtpclntrest[4],MSG_R(F_REJIFCLIENTLSTDUNDER));//43
	const char *permrej_smtpclntrest[4] = {MSG_R(X_NONE),MSG_R(F_REJREQUEST),MSG_R(F_PERMREQUEST),NULL};
	dia.newf_chkm ("",rd_permrej_smtpclntrest, permrej_smtpclntrest);//44
        // (check client access)
        dia.newf_title("", MSG_R(F_ACTCHKCLIENTACCMAPTYPEMAPNAME));
        dia.newf_chk ("",var_smtpclntrest[2], MSG_R(F_ACTIVATECHECKBOX));
	dia.newf_str (MSG_R(F_CHKCLIENTACCMAPTYPEMAPNAME), str1_smtpclntrest);//41
        dia.newf_info ("", MSG_R(X_MAPTYPEMAPNAMEEX));

	// smtpd_helo_restrictions
	dia.newf_title (MSG_U(T_SMTPDHELOREST,"helo"),2,"",MSG_R(T_SMTPDHELOREST));
	
	st = data.getvarvariable(V_SMTPD_HELO_RESTRICTIONS);
	char var_smtpdhelorest[11];
	SSTRING str1_smtpdhelorest, str2_smtpdhelorest, str3_smtpdhelorest;
	const char *param_smtpdhelorest[] = {"permit_mynetworks","reject_unknown_client","reject_maps_rbl","reject_invalid_hostname",
					     "reject_unknown_hostname","reject_non_fqdn_hostname","check_helo_access",
					     "maptype:mapname","check_client_access","reject","permit",NULL};
	{
		const char *tmp_smtpdhelorest = st->get();
		SSTRINGS *strs = data.str_popul_sstrings(tmp_smtpdhelorest);
		bool need_commas = 0;
		if (strs!=NULL){
			for (int j=0; j<strs->getnb(); j++){
				char *p;
				const char *t = strs->getitem(j)->get();
				if ( (p = strstr(t,param_smtpdhelorest[6])) ){
					if (*(p+17)=='\0')	continue;
					p+= 18;
					str1_smtpdhelorest.append(p);
					continue;
				}
				if ( (p = strstr(t,param_smtpdhelorest[8])) ){
					if (*(p+19)=='\0')	continue;
					p+= 20;
					str3_smtpdhelorest.append(p);
					continue;
				}
				if (strstr(t,":")){
					if (need_commas)
						str2_smtpdhelorest.append(", ");
					str2_smtpdhelorest.append(t);
					need_commas = 1;
				}
			}
			delete (strs);
		}
		for (int i=0; param_smtpdhelorest[i]!=NULL; i++){
			if (i==7)	continue;
			if (i==9 || i==10)
				if (data.strcheckexactly(tmp_smtpdhelorest, param_smtpdhelorest[i]))	var_smtpdhelorest[i]=1;
				else	var_smtpdhelorest[i]=0;
			else
				if (strstr(tmp_smtpdhelorest, param_smtpdhelorest[i]))	var_smtpdhelorest[i]=1;
				else	var_smtpdhelorest[i]=0;
		}
	}
	
	char rd_permrej_smtpdhelorest;
	if (var_smtpdhelorest[9]==0){
		if (var_smtpdhelorest[10]==0)
			rd_permrej_smtpdhelorest = 0;
		else 	rd_permrej_smtpdhelorest = 2;
	}else{
		if (var_smtpdhelorest[10]==0)
			rd_permrej_smtpdhelorest = 1;
		else{
			xconf_notice (MSG_R(N_REJPERMSAMETIME));
			rd_permrej_smtpdhelorest = 0;
		}
	}
	
	dia.newf_chk ("",var_smtpdhelorest[0],MSG_R(F_PERMCLIENTADRSMATMYNET));//46
	dia.newf_chk ("",var_smtpdhelorest[1],MSG_R(F_REJREQCLIENTHOSTM));//47
	dia.newf_chk ("",var_smtpdhelorest[2],MSG_R(F_REJIFCLIENTLSTDUNDER));//48
	dia.newf_chk ("",var_smtpdhelorest[3],MSG_U(F_REJHELOHOSTNAMEBADSINTAXE,"reject HELO hostname with bad syntax"));//49
	dia.newf_chk ("",var_smtpdhelorest[4],MSG_U(F_REJHELOHOSTNAMEWITHOUTDNSMXREC,"reject HELO hostname without DNS A or MX record"));//50
	dia.newf_chk ("",var_smtpdhelorest[5],MSG_U(F_REJHELOHOSTNAMENOTFQDNFORM,"reject HELO hostname that is not in FQDN form"));//51
        dia.newf_str (MSG_R(F_MAPTYPEMAPNAME),str2_smtpdhelorest);//54
        dia.newf_info ("", MSG_R(X_MAPTYPEMAPNAMEEX));
        const char *permrej_smtpdhelorest[4] = {MSG_R(X_NONE),MSG_R(F_REJREQUEST),MSG_R(F_PERMREQUEST),NULL};
	dia.newf_chkm ("",rd_permrej_smtpdhelorest, permrej_smtpdhelorest);//57
        // (check helo access)
        dia.newf_title("", MSG_R(F_ACTCHKHELOACCMAPTYPEMAPNAME));
        dia.newf_chk ("",var_smtpdhelorest[6], MSG_R(F_ACTIVATECHECKBOX));
	dia.newf_str (MSG_U(F_CHKHELOACCMAPTYPEMAPNAME,"maptypes and mapnames"),str1_smtpdhelorest);//53
        dia.newf_info ("", MSG_R(X_MAPTYPEMAPNAMEEX));
        // (check client access)
        dia.newf_title("", MSG_R(F_ACTCHKCLIENTACCMAPTYPEMAPNAME));
        dia.newf_chk ("",var_smtpdhelorest[8], MSG_R(F_ACTIVATECHECKBOX));
	dia.newf_str (MSG_R(F_CHKCLIENTACCMAPTYPEMAPNAME),str3_smtpdhelorest);//56
        dia.newf_info ("", MSG_R(X_MAPTYPEMAPNAMEEX));



	// smtpd_recipient_restrictions
	dia.newf_title (MSG_U(T_SMTPDRECREST,"recipient"),2,"",MSG_R(T_SMTPDRECREST));
	
	st = data.getvarvariable(V_SMTPD_RECIPIENT_RESTRICTIONS);
	char var_smtpdrcprest[22];
	SSTRING str1_smtpdrcprest, str2_smtpdrcprest, str3_smtpdrcprest, str4_smtpdrcprest, str5_smtpdrcprest;
	const char *param_smtpdrcprest[] = {"permit_mynetworks","reject_unknown_client","reject_maps_rbl","reject_invalid_hostname",
	                                    "reject_unknown_hostname","reject_unknown_sender_domain","check_relay_domains",
	                                    "permit_auth_destination","reject_unauth_destination","reject_unauth_pipelining",
	                                    "permit_mx_backup","reject_unknown_recipient_domain","check_recipient_access",
	                                    "maptype:mapname","check_client_access","check_helo_access",
	                                    "check_sender_access","reject_non_fqdn_hostname","reject_non_fqdn_sender",
	                                    "reject_non_fqdn_recipient","reject","permit",NULL};
	{
		const char *tmp_smtpdrcprest = st->get();
		SSTRINGS *strs = data.str_popul_sstrings(tmp_smtpdrcprest);
		bool need_com = 0;
		if (strs!=NULL){
			for (int j=0; j<strs->getnb(); j++){
				char *p;
				const char *t = strs->getitem(j)->get();
				if ( (p = strstr(t,param_smtpdrcprest[12])) ){
					if (*(p+22)=='\0')	continue;
					p+= 23;
					str1_smtpdrcprest.append(p);
					continue;
				}
				if ( (p = strstr(t,param_smtpdrcprest[14])) ){
					if (*(p+19)=='\0')	continue;
					p+= 20;
					str3_smtpdrcprest.append(p);
					continue;
				}
				if ( (p = strstr(t,param_smtpdrcprest[15])) ){
					if (*(p+17)=='\0')	continue;
					p+= 18;
					str4_smtpdrcprest.append(p);
					continue;
				}
				if ( (p = strstr(t,param_smtpdrcprest[16])) ){
					if (*(p+19)=='\0')	continue;
					p+= 20;
					str5_smtpdrcprest.append(p);
					continue;
				}
				if (strstr(t,":")){
					if (need_com)
						str2_smtpdrcprest.append(", ");
					str2_smtpdrcprest.append(t);
					need_com = 1;
				}
			}
			delete (strs);
		}
		for (int i=0; param_smtpdrcprest[i]!=NULL; i++){
			if (i==13)	continue;
			if (i==20 || i==21)
				if (data.strcheckexactly(tmp_smtpdrcprest, param_smtpdrcprest[i]))	var_smtpdrcprest[i]=1;
				else	var_smtpdrcprest[i]=0;
			else
				if (strstr(tmp_smtpdrcprest, param_smtpdrcprest[i]))	var_smtpdrcprest[i]=1;
				else	var_smtpdrcprest[i]=0;
		}
	}

	char rd_permrej_smtpdrcprest;
	if (var_smtpdrcprest[20]==0){
		if (var_smtpdrcprest[21]==0)
			rd_permrej_smtpdrcprest = 0;
		else 	rd_permrej_smtpdrcprest = 2;
	}else{
		if (var_smtpdrcprest[21]==0)
			rd_permrej_smtpdrcprest = 1;
		else{
			xconf_notice (MSG_R(N_REJPERMSAMETIME));
			rd_permrej_smtpdrcprest = 0;
		}
	}
	
	dia.newf_chk ("",var_smtpdrcprest[0],MSG_R(F_PERMCLIENTADRSMATMYNET));//59
	dia.newf_chk ("",var_smtpdrcprest[1],MSG_R(F_REJREQCLIENTHOSTM));//60
	dia.newf_chk ("",var_smtpdrcprest[2],MSG_R(F_REJIFCLIENTLSTDUNDER));//61
	dia.newf_chk ("",var_smtpdrcprest[3],MSG_R(F_REJHELOHOSTNAMEBADSINTAXE));//62
	dia.newf_chk ("",var_smtpdrcprest[4],MSG_R(F_REJHELOHOSTNAMEWITHOUTDNSMXREC));//63
	dia.newf_chk ("",var_smtpdrcprest[5],MSG_U(F_REJSNDDOMWITHOUTAMXREC,"reject sender domain without A or MX record"));//64
	dia.newf_chk ("",var_smtpdrcprest[6],MSG_U(F_PERMONLYMAILTO,"check relay domains (see help)"));//65
	dia.newf_chk ("",var_smtpdrcprest[7],MSG_U(F_PERMMAILTO,"permit auth destination (see help)"));//66
	dia.newf_chk ("",var_smtpdrcprest[8],MSG_U(F_REJMAILUNLESSITSENTTO,"reject mail unless it is sent to... see help"));//67
	dia.newf_chk ("",var_smtpdrcprest[9],MSG_U(F_REJMAILFROMIMPRPIPELSPAM,"reject mail from improperly pipelining spamware"));//68
	dia.newf_chk ("",var_smtpdrcprest[10],MSG_U(F_ACPTMAILSITESTHATLSTMXHOST,"accept mail for sites that list me as MX host"));//69
	dia.newf_chk ("",var_smtpdrcprest[11],MSG_U(F_REJDOMWITHOUTAMXREC,"reject domains without A or MX record"));//70
        dia.newf_str (MSG_R(F_MAPTYPEMAPNAME),str2_smtpdrcprest);//73
        dia.newf_info ("", MSG_R(X_MAPTYPEMAPNAMEEX));
        dia.newf_chk ("",var_smtpdrcprest[17],MSG_R(F_REJHELOHOSTNAMENOTFQDNFORM));//80
	dia.newf_chk ("",var_smtpdrcprest[18],MSG_U(F_REJSNDADRSNOTFQDNFORM,"reject sender address that is not in FQDN form"));//81
	dia.newf_chk ("",var_smtpdrcprest[19],MSG_U(F_REJRECADRSNOTFQDNFORM,"reject recipient address that is not in FQDN form"));//82
	const char *permrej_smtpdrcprest[4] = {MSG_R(X_NONE),MSG_R(F_REJREQUEST),MSG_R(F_PERMREQUEST),NULL};
	dia.newf_chkm ("",rd_permrej_smtpdrcprest, permrej_smtpdrcprest);//83
        // (check recipient access)
        dia.newf_title("", MSG_U(F_ACTCHKRECACCMAPTYPEMAPNAME,"Check recipient access"));
        dia.newf_chk ("",var_smtpdrcprest[12], MSG_R(F_ACTIVATECHECKBOX));
        dia.newf_str (MSG_U(F_CHKRECACCMAPTYPEMAPNAME,"maptypes and mapnames"),str1_smtpdrcprest);//72
        dia.newf_info ("", MSG_R(X_MAPTYPEMAPNAMEEX));
        // (check client access)
        dia.newf_title("", MSG_R(F_ACTCHKCLIENTACCMAPTYPEMAPNAME));
        dia.newf_chk ("",var_smtpdrcprest[14], MSG_R(F_ACTIVATECHECKBOX));
	dia.newf_str (MSG_R(F_CHKCLIENTACCMAPTYPEMAPNAME),str3_smtpdrcprest);//75
        dia.newf_info ("", MSG_R(X_MAPTYPEMAPNAMEEX));
        // (check helo access)
        dia.newf_title("", MSG_R(F_ACTCHKHELOACCMAPTYPEMAPNAME));
        dia.newf_chk ("",var_smtpdrcprest[15], MSG_R(F_ACTIVATECHECKBOX));
	dia.newf_str (MSG_R(F_CHKHELOACCMAPTYPEMAPNAME),str4_smtpdrcprest);//77
        dia.newf_info ("", MSG_R(X_MAPTYPEMAPNAMEEX));
        // (check sender access)
        dia.newf_title("", MSG_R(F_ACTCHKSNDACCMAPTYPEMAPNAME));
        dia.newf_chk ("",var_smtpdrcprest[16], MSG_R(F_ACTIVATECHECKBOX));
	dia.newf_str (MSG_R(F_CHKSNDACCMAPTYPEMAPNAME),str5_smtpdrcprest);//79
        dia.newf_info ("", MSG_R(X_MAPTYPEMAPNAMEEX));

	dia.setbutinfo (MENU_USR1, MSG_R(B_SETTODEFAULT), MSG_R(B_SETTODEFAULT));
	
	while (1){
		bool must_reload = 0;
		MENU_STATUS code = dia.edit(
			"Spam Control configuration"
			,""
			,help_postfix_spamctrl
			,nof
			,MENUBUT_CANCEL|MENUBUT_ACCEPT|MENUBUT_USR1);
		if (code == MENU_CANCEL || code == MENU_ESCAPE){
			break;
		}else if (code == MENU_ACCEPT){
			// validations
		
			// - - - ADDITIONAL UCE CONTROLS - - -
			// allow_untrusted_routing
			setvalue_yesno (data.getvarvariable(V_ALLOW_UNTRUSTED_ROUTING), var_alluntrout);
	
			// - - - UCE restrictions - - -
			// smtpd_etrn_restrictions
			st = data.getvarvariable(V_SMTPD_ETRN_RESTRICTIONS);
	
			{
				switch (rd_permrej_smtpdetrnrest){//check the radio status and set the inidices
					case 1:
						var_smtpdetrnrest[5]=1;
						var_smtpdetrnrest[6]=0;
						break;
					case 2:
						var_smtpdetrnrest[5]=0;
						var_smtpdetrnrest[6]=1;
						break;
					default:
						var_smtpdetrnrest[5]=0;
						var_smtpdetrnrest[6]=0;
				}
				
				SSTRING *strtmp = st; // strtmp will store the contents of variable
				strtmp->setfrom("");
				bool need_com = 0;
				if (str2_smtpdetrnrest.is_empty())
					var_smtpdetrnrest[3]=0;
				else 	var_smtpdetrnrest[3]=1;
				// parse the items of variable. For each item do its parse. The order of items is important
				for (int i=0; param_smtpdetrnrest[i]!=NULL; i++){
					if (i==2){ // check.
						// If field is filled and combo isn't check
						if (var_smtpdetrnrest[2]==0 && !str1_smtpdetrnrest.is_empty()){
							if (must_reload==0){
								nof=15;
								must_reload=1;
								xconf_notice (MSG_R(N_INVALIDDATA));
							}
						} // If combo is checked, we must fill its respective field
						if (var_smtpdetrnrest[2]==1 && str1_smtpdetrnrest.is_empty()){
							if (must_reload==0){
								nof=16;
								must_reload=1;
								xconf_notice (MSG_R(N_INVALIDDATA));
							}
						}
						
					}
					if (var_smtpdetrnrest[i]==0)
						continue;
					if (need_com)
						strtmp->append(",");
					if (i==3){
						if (strstr(str2_smtpdetrnrest.get(),":")){
							strtmp->append(str2_smtpdetrnrest.get());
							need_com = 1;
							continue;
						}else{
							if (must_reload==0){
								nof = 17;
								must_reload=1;
								xconf_notice (MSG_U(N_INVALIDDATA,"invalid data"));
							}
						}
					}
					strtmp->append(param_smtpdetrnrest[i]);
					need_com = 1;
					if (i==2 && !str1_smtpdetrnrest.is_empty()){
						if (strstr(str1_smtpdetrnrest.get(),":") && !strstr(str1_smtpdetrnrest.get(),",")){
							strtmp->append(" ");
							strtmp->append(str1_smtpdetrnrest.get());
						}else{
							if (must_reload==0){
								nof = 16;
								must_reload=1;
								xconf_notice (MSG_R(N_INVALIDDATA));
							}
						}
					}
				}
			}

			// smtpd_sender_restrictions
			st = data.getvarvariable(V_SMTPD_SENDER_RESTRICTIONS);
			{	
				switch (rd_permrej_smtpdsndrest){
					case 1:
						var_smtpdsndrest[12]=1;
						var_smtpdsndrest[13]=0;
						break;
					case 2:
						var_smtpdsndrest[12]=0;
						var_smtpdsndrest[13]=1;
						break;
					default:
						var_smtpdsndrest[12]=0;
						var_smtpdsndrest[13]=0;
				}
				
				SSTRING *strtmp = st;
				strtmp->setfrom("");
				bool need_commas = 0;
				if (str2_smtpdsndrest.is_empty())
					var_smtpdsndrest[7]=0;
				else 	var_smtpdsndrest[7]=1;
				for (int i=0; param_smtpdsndrest[i]!=NULL; i++){
					if (i==6){
						if (var_smtpdsndrest[6]==0 && !str1_smtpdsndrest.is_empty()){
							if (must_reload==0){
								nof=27;
								must_reload=1;
								xconf_notice (MSG_R(N_INVALIDDATA));
							}
						}
						if (var_smtpdsndrest[6]==1 && str1_smtpdsndrest.is_empty()){
							if (must_reload==0){
								nof=28;
								must_reload=1;
								xconf_notice (MSG_R(N_INVALIDDATA));
							}
						}
						
					}
					if (i==8){
						if (var_smtpdsndrest[8]==0 && !str3_smtpdsndrest.is_empty()){
							if (must_reload==0){
								nof=30;
								must_reload=1;
								xconf_notice (MSG_R(N_INVALIDDATA));
							}
						}
						if (var_smtpdsndrest[8]==1 && str3_smtpdsndrest.is_empty()){
							if (must_reload==0){
								nof=31;
								must_reload=1;
								xconf_notice (MSG_R(N_INVALIDDATA));
							}
						}
						
					}
					if (i==9){
						if (var_smtpdsndrest[9]==0 && !str4_smtpdsndrest.is_empty()){
							if (must_reload==0){
								nof=32;
								must_reload=1;
								xconf_notice (MSG_R(N_INVALIDDATA));
							}
						}
						if (var_smtpdsndrest[9]==1 && str4_smtpdsndrest.is_empty()){
							if (must_reload==0){
								nof=33;
								must_reload=1;
								xconf_notice (MSG_R(N_INVALIDDATA));
							}
						}
						
					}
					if (var_smtpdsndrest[i]==0)
						continue;
					if (need_commas){
						strtmp->append(",");
					}
					if (i==7){
						if (strstr(str2_smtpdsndrest.get(),":")){
							strtmp->append(str2_smtpdsndrest.get());
							need_commas = 1;
							continue;
						}else{
							if (must_reload==0){
								nof = 29;
								must_reload=1;
								xconf_notice (MSG_R(N_INVALIDDATA));
							}
						}
					}
					strtmp->append(param_smtpdsndrest[i]);
					if (i==6 && !str1_smtpdsndrest.is_empty()){
						if (strstr(str1_smtpdsndrest.get(),":") && !strstr(str1_smtpdsndrest.get(),",")){
							strtmp->append(" ");
							strtmp->append(str1_smtpdsndrest.get());
						}else{
							if (must_reload==0){
								nof = 28;
								must_reload=1;
								xconf_notice (MSG_R(N_INVALIDDATA));
							}
						}
					}
					if (i==8 && !str3_smtpdsndrest.is_empty()){
						if (strstr(str3_smtpdsndrest.get(),":") && !strstr(str3_smtpdsndrest.get(),",")){
							strtmp->append(" ");
							strtmp->append(str3_smtpdsndrest.get());
						}else{
							if (must_reload==0){
								nof = 31;
								must_reload=1;
								xconf_notice (MSG_R(N_INVALIDDATA));
							}
						}
					}
					if (i==9 && !str4_smtpdsndrest.is_empty()){
						if (strstr(str4_smtpdsndrest.get(),":") && !strstr(str4_smtpdsndrest.get(),",")){
							strtmp->append(" ");
							strtmp->append(str4_smtpdsndrest.get());
						}else{
							if (must_reload==0){
								nof = 33;
								must_reload=1;
								xconf_notice (MSG_R(N_INVALIDDATA));
							}
						}
					}
					need_commas = 1;
				}
			}

			// smtpd_client_restrictions
			st = data.getvarvariable(V_SMTPD_CLIENT_RESTRICTIONS);
			{
				switch (rd_permrej_smtpclntrest){
					case 1:
						var_smtpclntrest[5]=1;
						var_smtpclntrest[6]=0;
						break;
					case 2:
						var_smtpclntrest[5]=0;
						var_smtpclntrest[6]=1;
						break;
					default:
						var_smtpclntrest[5]=0;
						var_smtpclntrest[6]=0;
				}
				SSTRING *strtmp = st;
				strtmp->setfrom("");
				bool need_com = 0;
				if (str2_smtpclntrest.is_empty())
					var_smtpclntrest[3]=0;
				else 	var_smtpclntrest[3]=1;
				for (int i=0; param_smtpclntrest[i]!=NULL; i++){
					if (i==2){// if combo is turned off and string is filled
						if (var_smtpclntrest[2]==0 && !str1_smtpclntrest.is_empty()){
							if (must_reload==0){
								nof=40;// focus to active
								must_reload=1;
								xconf_notice (MSG_R(N_INVALIDDATA));
							}
						}// if active is turned on and string is empty
						if (var_smtpclntrest[2]==1 && str1_smtpclntrest.is_empty()){
							if (must_reload==0){
								nof=41;// focus to string
								must_reload=1;
								xconf_notice (MSG_R(N_INVALIDDATA));
							}
						}
					}
					if (var_smtpclntrest[i]==0)
						continue;
					if (need_com){
						strtmp->append(",");
					}
					if (i==3){
						if (strstr(str2_smtpclntrest.get(),":")){
							strtmp->append(str2_smtpclntrest.get());
							need_com = 1;
							continue;
						}else{
							if (must_reload==0){
								nof=42;
								must_reload=1;
								xconf_notice (MSG_R(N_INVALIDDATA));
							}
						}
					}
					strtmp->append(param_smtpclntrest[i]);
					if (i==2 && !str1_smtpclntrest.is_empty()){
						if (strstr(str1_smtpclntrest.get(),":") && !strstr(str1_smtpclntrest.get(),",")){
							strtmp->append(" ");
							strtmp->append(str1_smtpclntrest.get());
						}else{
							if (must_reload==0){
								nof=41;
								must_reload=1;
								xconf_notice (MSG_R(N_INVALIDDATA));
							}
						}
					}
					need_com = 1;
				}
			}

			// smtpd_helo_restrictions
			st = data.getvarvariable(V_SMTPD_HELO_RESTRICTIONS);
			{
				switch (rd_permrej_smtpdhelorest){
					case 1:
						var_smtpdhelorest[9]=1;
						var_smtpdhelorest[10]=0;
						break;
					case 2:
						var_smtpdhelorest[9]=0;
						var_smtpdhelorest[10]=1;
						break;
					default:
						var_smtpdhelorest[9]=0;
						var_smtpdhelorest[10]=0;
				}
				SSTRING *strtmp = st;
				strtmp->setfrom("");
				bool need_com = 0;
				if (str2_smtpdhelorest.is_empty())
					var_smtpdhelorest[7]=0;
				else 	var_smtpdhelorest[7]=1;
				for (int i=0; param_smtpdhelorest[i]!=NULL; i++){
					if (i==6){ // if combo is turned off and string is filled
						if (var_smtpdhelorest[6]==0 && !str1_smtpdhelorest.is_empty()){
							if (must_reload==0){
								nof=52; // focus to active
								must_reload=1;
								xconf_notice (MSG_R(N_INVALIDDATA));
							}
						} // if active is turned on and string is empty
						if (var_smtpdhelorest[6]==1 && str1_smtpdhelorest.is_empty()){
							if (must_reload==0){
								nof=53; // focus to string
								must_reload=1;
								xconf_notice (MSG_R(N_INVALIDDATA));
							}
						}
					}
					if (i==8){
						if (var_smtpdhelorest[8]==0 && !str3_smtpdhelorest.is_empty()){
							if (must_reload==0){
								nof=55;
								must_reload=1;
								xconf_notice (MSG_R(N_INVALIDDATA));
							}
						}
						if (var_smtpdhelorest[8]==1 && str3_smtpdhelorest.is_empty()){
							if (must_reload==0){
								nof=56;
								must_reload=1;
								xconf_notice (MSG_R(N_INVALIDDATA));
							}
						}
					}
					if (var_smtpdhelorest[i]==0)
						continue;
					if (need_com){
						strtmp->append(",");
					}
					if (i==7){
						if (strstr(str2_smtpdhelorest.get(),":")){
							strtmp->append(str2_smtpdhelorest.get());
							need_com = 1;
							continue;
						}else{
							if (must_reload==0){
								nof=54;
								must_reload=1;
								xconf_notice (MSG_R(N_INVALIDDATA));
							}
						}
					}
					strtmp->append(param_smtpdhelorest[i]);
					if (i==6 && !str1_smtpdhelorest.is_empty()){
						if (strstr(str1_smtpdhelorest.get(),":") && !strstr(str1_smtpdhelorest.get(),",")){
							strtmp->append(" ");
							strtmp->append(str1_smtpdhelorest.get());
						}else{
							if (must_reload==0){
								nof=53;
								must_reload=1;
								xconf_notice (MSG_R(N_INVALIDDATA));
							}
						}
					}
					if (i==8 && !str3_smtpdhelorest.is_empty()){
						if (strstr(str3_smtpdhelorest.get(),":") && !strstr(str3_smtpdhelorest.get(),",")){
							strtmp->append(" ");
							strtmp->append(str3_smtpdhelorest.get());
						}else{
							if (must_reload==0){
								nof=56;
								must_reload=1;
								xconf_notice (MSG_R(N_INVALIDDATA));
							}
						}
					}
					need_com = 1;
				}
			}

			// smtpd_recipient_restrictions
			st = data.getvarvariable(V_SMTPD_RECIPIENT_RESTRICTIONS);
			{
				switch (rd_permrej_smtpdrcprest){
					case 1:
						var_smtpdrcprest[20]=1;
						var_smtpdrcprest[21]=0;
						break;
					case 2:
						var_smtpdrcprest[20]=0;
						var_smtpdrcprest[21]=1;
						break;
					default:
						var_smtpdrcprest[20]=0;
						var_smtpdrcprest[21]=0;
				}
				
				SSTRING *strtmp = st;
				strtmp->setfrom("");
				bool need_commas = 0;
				if (str2_smtpdrcprest.is_empty())
					var_smtpdrcprest[13]=0;
				else 	var_smtpdrcprest[13]=1;
				for (int i=0; param_smtpdrcprest[i]!=NULL; i++){
					if (i==12){
						if (var_smtpdrcprest[12]==0 && !str1_smtpdrcprest.is_empty()){
							if (must_reload==0){
								nof=71;
								must_reload=1;
								xconf_notice (MSG_R(N_INVALIDDATA));
							}
						}
						if (var_smtpdrcprest[12]==1 && str1_smtpdrcprest.is_empty()){
							if (must_reload==0){
								nof=72;
								must_reload=1;
								xconf_notice (MSG_R(N_INVALIDDATA));
							}
						}
					}
					if (i==14){
						if (var_smtpdrcprest[14]==0 && !str3_smtpdrcprest.is_empty()){
							if (must_reload==0){
								nof=74;
								must_reload=1;
								xconf_notice (MSG_R(N_INVALIDDATA));
							}
						}
						if (var_smtpdrcprest[14]==1 && str3_smtpdrcprest.is_empty()){
							if (must_reload==0){
								nof=75;
								must_reload=1;
								xconf_notice (MSG_R(N_INVALIDDATA));
							}
						}
					}
					if (i==15){
						if (var_smtpdrcprest[15]==0 && !str4_smtpdrcprest.is_empty()){
							if (must_reload==0){
								nof=76;
								must_reload=1;
								xconf_notice (MSG_R(N_INVALIDDATA));
							}
						}
						if (var_smtpdrcprest[15]==1 && str4_smtpdrcprest.is_empty()){
							if (must_reload==0){
								nof=77;
								must_reload=1;
								xconf_notice (MSG_R(N_INVALIDDATA));
							}
						}
					}
					if (i==16){
						if (var_smtpdrcprest[16]==0 && !str5_smtpdrcprest.is_empty()){
							if (must_reload==0){
								nof=78;
								must_reload=1;
								xconf_notice (MSG_R(N_INVALIDDATA));
							}
						}
						if (var_smtpdrcprest[16]==1 && str5_smtpdrcprest.is_empty()){
							if (must_reload==0){
								nof=79;
								must_reload=1;
								xconf_notice (MSG_R(N_INVALIDDATA));
							}
						}
					}
					if (var_smtpdrcprest[i]==0)
						continue;
					if (need_commas){
						strtmp->append(",");
					}
					if (i==13){
						if (strstr(str2_smtpdrcprest.get(),":")){
							strtmp->append(str2_smtpdrcprest.get());
							need_commas = 1;
							continue;
						}else{
							if (must_reload==0){
								nof=73;
								must_reload=1;
								xconf_notice (MSG_R(N_INVALIDDATA));
							}
						}
					}
					strtmp->append(param_smtpdrcprest[i]);
					if (i==12 && !str1_smtpdrcprest.is_empty()){
						if (strstr(str1_smtpdrcprest.get(),":") && !strstr(str1_smtpdrcprest.get(),",")){
							strtmp->append(" ");
							strtmp->append(str1_smtpdrcprest.get());
						}else{
							if (must_reload==0){
								nof=72;
								must_reload=1;
								xconf_notice (MSG_R(N_INVALIDDATA));
							}
						}
					}
					if (i==14 && !str3_smtpdrcprest.is_empty()){
						if (strstr(str3_smtpdrcprest.get(),":") && !strstr(str3_smtpdrcprest.get(),",")){
							strtmp->append(" ");
							strtmp->append(str3_smtpdrcprest.get());
						}else{
							if (must_reload==0){
								nof=75;
								must_reload=1;
								xconf_notice (MSG_R(N_INVALIDDATA));
							}
						}
					}
					if (i==15 && !str4_smtpdrcprest.is_empty()){
						if (strstr(str4_smtpdrcprest.get(),":") && !strstr(str4_smtpdrcprest.get(),",")){
							strtmp->append(" ");
							strtmp->append(str4_smtpdrcprest.get());
						}else{
							if (must_reload==0){
								nof=77;
								must_reload=1;
								xconf_notice (MSG_R(N_INVALIDDATA));
							}
						}
					}
					if (i==16 && !str5_smtpdrcprest.is_empty()){
						if (strstr(str5_smtpdrcprest.get(),":") && !strstr(str5_smtpdrcprest.get(),",")){
							strtmp->append(" ");
							strtmp->append(str5_smtpdrcprest.get());
						}else{
							if (must_reload==0){
								nof=79;
								must_reload=1;
								xconf_notice (MSG_R(N_INVALIDDATA));
							}
						}
					}
					need_commas = 1;
				}
				if (var_smtpdrcprest[20]==0 && var_smtpdrcprest[6]==0 && var_smtpdrcprest[8]==0){
					if (must_reload==0){
						nof = 83;
						must_reload=1;
						xconf_notice (MSG_U(N_SMTPDRCPALERT,
								 "NOTE: YOU MUST SPECIFY AT LEAST ONE OF THE FOLLOWING RESTRICTIONS\n"
								 "OTHERWISE POSTFIX REFUSES TO RECEIVE MAIL:\n"
								 "-reject the request\n"
								 "-permit only mail to... see help\n"
								 "-reject mail unless it is sent to... see help"));
					}
				}
			}

			if (must_reload){
				must_reload = 0;
				dia.reload();
				continue;
			}
			
			ret = 1;
			break;
		}else if (code == MENU_USR1){
			if ( dialog_yesno(MSG_R(T_RESTORETODEFAULT)
					 ,MSG_R(N_RESTORETODEFAULT)
					 ,help_postfix_basic) == MENU_YES ){
				int values[]={
						V_RECIPIENT_DELIMITER,
						V_HEADER_CHECKS,
						V_BODY_CHECKS,
						V_MYNETWORKS,
						V_ALLOW_UNTRUSTED_ROUTING,
						V_MAPS_RBL_DOMAINS,
						V_RELAY_DOMAINS,
						V_RELAYHOST,
						V_SMTPD_ETRN_RESTRICTIONS,
						V_SMTPD_SENDER_RESTRICTIONS,
						V_SMTPD_CLIENT_RESTRICTIONS,
						V_SMTPD_HELO_RESTRICTIONS,
						V_SMTPD_RECIPIENT_RESTRICTIONS,
						-1
				};
				data.setdefaultvarvalues(values);
				
				// allow_untrusted_routing	nof=7
				st = data.getvarvariable(V_ALLOW_UNTRUSTED_ROUTING);
				var_alluntrout = getvalue_yesno (st);
				
				// smtpd_etrn_restrictions
				st = data.getvarvariable(V_SMTPD_ETRN_RESTRICTIONS); // set pointer to variable
				// clean the strings that will contain the maptype:mapname
				str1_smtpdetrnrest.setfrom("");
				str2_smtpdetrnrest.setfrom("");
				{
					const char *tmp_smtpdetrnrest = st->get();

					SSTRINGS *strs = data.str_popul_sstrings(tmp_smtpdetrnrest); // populate its parameters into strs
					bool need_commas = 0;
					for (int j=0; j<strs->getnb(); j++){ // copy the values, if exist, to variables
						char *p;
						const char *t = strs->getitem(j)->get();
						if ( (p = strstr(t,param_smtpdetrnrest[2])) ){
							if (*(p+19)=='\0')	continue;
							p+= 20;
							str1_smtpdetrnrest.append(p);
							continue;
						}
						if (strstr(t,":")){
							if (need_commas)
								str2_smtpdetrnrest.append(", ");
							str2_smtpdetrnrest.append(t);
							need_commas = 1;
						}
					}
					delete (strs);
					// scan paramaters vector and verify if params are find in variable
					// if yes, set the combo to 0 or 1.
					for (int i=0; param_smtpdetrnrest[i]!=NULL; i++){
						if (i==3)	continue;
						if (i==5 || i==6)
							if (data.strcheckexactly(tmp_smtpdetrnrest, param_smtpdetrnrest[i]))
								var_smtpdetrnrest[i]=1;
							else	var_smtpdetrnrest[i]=0;
						else
							if (strstr(tmp_smtpdetrnrest, param_smtpdetrnrest[i]))	var_smtpdetrnrest[i]=1;
							else	var_smtpdetrnrest[i]=0;
					}
				}
				// set the permit, request radio option. Is the permit and reject are at the same time, display an alert
				// and set none.
				if (var_smtpdetrnrest[5]==0){
					if (var_smtpdetrnrest[6]==0)
						rd_permrej_smtpdetrnrest = 0;
					else 	rd_permrej_smtpdetrnrest = 2;
				}else{
					if (var_smtpdetrnrest[6]==0)
						rd_permrej_smtpdetrnrest = 1;
					else{
						rd_permrej_smtpdetrnrest = 0;
					}
				}
					
				// smtpd_sender_restrictions
				st = data.getvarvariable(V_SMTPD_SENDER_RESTRICTIONS);
				str1_smtpdsndrest.setfrom("");
				str2_smtpdsndrest.setfrom("");
				str3_smtpdsndrest.setfrom("");
				str4_smtpdsndrest.setfrom("");
				{
					const char *tmp_smtpdsndrest = st->get();
					SSTRINGS *strs = data.str_popul_sstrings(tmp_smtpdsndrest);
					bool need_com = 0;
					for (int j=0; j<strs->getnb(); j++){
						char *p;
						const char *t = strs->getitem(j)->get();
						if ( (p = strstr(t,param_smtpdsndrest[6])) ){
							if (*(p+19)=='\0')	continue;
							p+= 20;
							str1_smtpdsndrest.append(p);
							continue;
						}
						if ( (p = strstr(t,param_smtpdsndrest[8])) ){
							if (*(p+19)=='\0')	continue;
							p+= 20;
							str3_smtpdsndrest.append(p);
							continue;
						}
						if ( (p = strstr(t,param_smtpdsndrest[9])) ){
							if (*(p+17)=='\0')	continue;
							p+= 18;
							str4_smtpdsndrest.append(p);
							continue;
						}
						if (strstr(t,":")){
							if (need_com)
								str2_smtpdsndrest.append(", ");
							str2_smtpdsndrest.append(t);
							need_com = 1;
						}
					
					}
					delete (strs);
					for (int i=0; param_smtpdsndrest[i]!=NULL; i++){
						if (i==7)	continue;
						if (i==12 || i==13)
							if (data.strcheckexactly(tmp_smtpdsndrest, param_smtpdsndrest[i]))	var_smtpdsndrest[i]=1;
							else	var_smtpdsndrest[i]=0;
						else
							if (strstr(tmp_smtpdsndrest, param_smtpdsndrest[i]))	var_smtpdsndrest[i]=1;
							else	var_smtpdsndrest[i]=0;
					}
				}
				
				if (var_smtpdsndrest[12]==0){
					if (var_smtpdsndrest[13]==0)
						rd_permrej_smtpdsndrest = 0;
					else 	rd_permrej_smtpdsndrest = 2;
				}else{
					if (var_smtpdsndrest[13]==0)
						rd_permrej_smtpdsndrest = 1;
					else{
						rd_permrej_smtpdsndrest = 0;
					}
				}
				
				// smtpd_client_restrictions
				st = data.getvarvariable(V_SMTPD_CLIENT_RESTRICTIONS);
				str1_smtpclntrest.setfrom("");
				str2_smtpclntrest.setfrom("");
				{
					const char *tmp_smtpclntrest = st->get();
					SSTRINGS *strs = data.str_popul_sstrings(tmp_smtpclntrest);
					bool need_commas = 0;
					for (int j=0; j<strs->getnb(); j++){
						char *p;
						const char *t = strs->getitem(j)->get();
						if ( (p = strstr(t,param_smtpclntrest[2])) ){
							if (*(p+19)=='\0')	continue;
							p+= 20;
							str1_smtpclntrest.append(p);
							continue;
						}
						if (strstr(t,":")){
							if (need_commas)
								str2_smtpclntrest.append(", ");
							str2_smtpclntrest.append(t);
							need_commas = 1;
						}
					}
					delete (strs);	
					for (int i=0; param_smtpclntrest[i]!=NULL; i++){
						if (i==3)	continue;
						if (i==5 || i==6)
							if (data.strcheckexactly(tmp_smtpclntrest, param_smtpclntrest[i]))	var_smtpclntrest[i]=1;
							else	var_smtpclntrest[i]=0;
						else
							if (strstr(tmp_smtpclntrest, param_smtpclntrest[i]))	var_smtpclntrest[i]=1;
							else	var_smtpclntrest[i]=0;
					}
				}
				
				if (var_smtpclntrest[5]==0){
					if (var_smtpclntrest[6]==0)
						rd_permrej_smtpclntrest = 0;
					else 	rd_permrej_smtpclntrest = 2;
				}else{
					if (var_smtpclntrest[6]==0)
						rd_permrej_smtpclntrest = 1;
					else{
						rd_permrej_smtpclntrest = 0;
					}
				}
				
				// smtpd_helo_restrictions
				st = data.getvarvariable(V_SMTPD_HELO_RESTRICTIONS);
				str1_smtpdhelorest.setfrom("");
				str2_smtpdhelorest.setfrom("");
				str3_smtpdhelorest.setfrom("");
				{
					const char *tmp_smtpdhelorest = st->get();
					SSTRINGS *strs = data.str_popul_sstrings(tmp_smtpdhelorest);
					bool need_commas = 0;
					for (int j=0; j<strs->getnb(); j++){
						char *p;
						const char *t = strs->getitem(j)->get();
						if ( (p = strstr(t,param_smtpdhelorest[6])) ){
							if (*(p+17)=='\0')	continue;
							p+= 18;
							str1_smtpdhelorest.append(p);
							continue;
						}
						if ( (p = strstr(t,param_smtpdhelorest[8])) ){
							if (*(p+19)=='\0')	continue;
							p+= 20;
							str3_smtpdhelorest.append(p);
							continue;
						}
						if (strstr(t,":")){
							if (need_commas)
								str2_smtpdhelorest.append(", ");
							str2_smtpdhelorest.append(t);
							need_commas = 1;
						}
					}
					delete (strs);	
					for (int i=0; param_smtpdhelorest[i]!=NULL; i++){
						if (i==7)	continue;
						if (i==9 || i==10)
							if (data.strcheckexactly(tmp_smtpdhelorest, param_smtpdhelorest[i]))	var_smtpdhelorest[i]=1;
							else	var_smtpdhelorest[i]=0;
						else
							if (strstr(tmp_smtpdhelorest, param_smtpdhelorest[i]))	var_smtpdhelorest[i]=1;
							else	var_smtpdhelorest[i]=0;
					}
				}
				
				if (var_smtpdhelorest[9]==0){
					if (var_smtpdhelorest[10]==0)
						rd_permrej_smtpdhelorest = 0;
					else 	rd_permrej_smtpdhelorest = 2;
				}else{
					if (var_smtpdhelorest[10]==0)
						rd_permrej_smtpdhelorest = 1;
					else{
						rd_permrej_smtpdhelorest = 0;
					}
				}
				
				// smtpd_recipient_restrictions
				st = data.getvarvariable(V_SMTPD_RECIPIENT_RESTRICTIONS);
				str1_smtpdrcprest.setfrom("");
				str2_smtpdrcprest.setfrom("");
				str3_smtpdrcprest.setfrom("");
				str4_smtpdrcprest.setfrom("");
				str5_smtpdrcprest.setfrom("");
				{
					const char *tmp_smtpdrcprest = st->get();
					SSTRINGS *strs = data.str_popul_sstrings(tmp_smtpdrcprest);
					bool need_com = 0;
					for (int j=0; j<strs->getnb(); j++){
						char *p;
						const char *t = strs->getitem(j)->get();
						if ( (p = strstr(t,param_smtpdrcprest[12])) ){
							if (*(p+22)=='\0')	continue;
							p+= 23;
							str1_smtpdrcprest.append(p);
							continue;
						}
						if ( (p = strstr(t,param_smtpdrcprest[14])) ){
							if (*(p+19)=='\0')	continue;
							p+= 20;
							str3_smtpdrcprest.append(p);
							continue;
						}
						if ( (p = strstr(t,param_smtpdrcprest[15])) ){
							if (*(p+17)=='\0')	continue;
							p+= 18;
							str4_smtpdrcprest.append(p);
							continue;
						}
						if ( (p = strstr(t,param_smtpdrcprest[16])) ){
							if (*(p+19)=='\0')	continue;
							p+= 20;
							str5_smtpdrcprest.append(p);
							continue;
						}
						if (strstr(t,":")){
							if (need_com)
								str2_smtpdrcprest.append(", ");
							str2_smtpdrcprest.append(t);
							need_com = 1;
						}
					}
					delete (strs);	
					for (int i=0; param_smtpdrcprest[i]!=NULL; i++){
						if (i==13)	continue;
						if (i==20 || i==21)
							if (data.strcheckexactly(tmp_smtpdrcprest, param_smtpdrcprest[i]))	var_smtpdrcprest[i]=1;
							else	var_smtpdrcprest[i]=0;
						else
							if (strstr(tmp_smtpdrcprest, param_smtpdrcprest[i]))	var_smtpdrcprest[i]=1;
							else	var_smtpdrcprest[i]=0;
					}
				}

				if (var_smtpdrcprest[20]==0){
					if (var_smtpdrcprest[21]==0)
						rd_permrej_smtpdrcprest = 0;
					else 	rd_permrej_smtpdrcprest = 2;
				}else{
					if (var_smtpdrcprest[21]==0)
						rd_permrej_smtpdrcprest = 1;
					else{
						rd_permrej_smtpdrcprest = 0;
					}
				}
				
				dia.reload();
			}
		}
	}
	return ret;
}
