
/* if is_new_entry!=0 then the 'del' button is not shown */
/* retuns !=0 if user confirmed, ==0 if cancelled or removed the entry */
int section_edit_prtserv_prop(VIEWITEMS &my_vitems, int which_group, int which_item, int is_new_entry)
{
    DIALOG         my_dialog;
    MENU_STATUS    my_button=MENU_NULL;
    int            my_selection=0;
    int illegal_entry_found=1;
    int did_user_accept=0; // 0 user cancelled, !=0 user confirmed

    INIT_PROPERTIES_EDITION;

    CREATE_STR_FIELD(my_servname,0,MSG_U(F_PRTSERVERNAME, "Printer server name:"));
    /* here creates the queue selector */
    SSTRING my_queuename;
    FIELD_LIST *my_queuename_fl;
    my_queuename_fl=my_dialog.newf_list(MSG_U(F_PRTSERVQUEUENAME, "Queue name:"), my_queuename);
    gimme_word_from_string(line_storage.get(), my_queuename, 1);
    {
        SSTRING my_temp, my_temp_word;
        int my_counter=0;
        while(parser_load_line(my_vitems, my_temp, 21, my_counter++)){
            gimme_word_from_string(my_temp.get(), my_temp_word, 0);
            if(*(my_temp_word.get()))
                my_queuename_fl->addopt(my_temp_word.get());
        }
    }
    /* flags */
    CREATE_BIN_FLAGSHOLDER_DEC(2);
    CREATE_BIN_CHK_FIELD(my_letbenormalusr,0,MSG_U(F_LETSRVNAMEBEUSR, "Let the server name be a \"normal\" user"));

    while(illegal_entry_found){
        illegal_entry_found=0;
        if(is_new_entry){
            my_button=my_dialog.edit(MSG_U(T_INSERTINGPRTSERV, "Inserting print server..."), "", hf_prtserver_props, my_selection, MENUBUT_ACCEPT|MENUBUT_QUIT);
        }else{
            my_button=my_dialog.edit(MSG_U(T_EDITINGPRTSERV, "Editing print server..."), "", hf_prtserver_props, my_selection, MENUBUT_ACCEPT|MENUBUT_DEL|MENUBUT_QUIT);
        }

        did_user_accept=0;
        switch(my_button){
        case MENU_DEL:
            if(askuser_for_deletion()){
                parser_remove_line(my_vitems, which_group, which_item);
                SAVE_FILE_NWSERVCONF;
                return(0);
            }
            illegal_entry_found=1;
            break;
        case MENU_ACCEPT:
            did_user_accept=1;

            illegal_entry_found|=replace_word(line_storage, my_servname.get(), 0, ILLEGAL_SPACES|ILLEGAL_EMPTYNESS|UPPERCASE_ONLY);
            illegal_entry_found|=replace_word(line_storage, my_queuename.get(), 1, ILLEGAL_SPACES|ILLEGAL_EMPTYNESS|UPPERCASE_ONLY);
            /* flags */
            set_bit_status(my_flags, 0, my_letbenormalusr);
            DUMP_BIN_FLAGSHOLDER_NOZERO_DEC(2);

            if(!illegal_entry_found){
                CLOSE_PROPERTIES_EDITION;
                SAVE_FILE_NWSERVCONF;
            }else{
                warnuser_invalid_data_entered();
            }
            break;
        default:
            break;
        }
    }
    return(did_user_accept);
}

void section_edit_prtserv(void)
{
    INIT_FILE_NWSERVCONF;

    DIALOG_RECORDS my_dialog;
    MENU_STATUS    my_button=MENU_NULL;
    int            my_selection=0;
    int which_group=22;

    my_dialog.newf_head("", MSG_U(X_PRTSERV_QUEUENM, "Print server\tQueue name"));

    while(1){
        insert_to_dialog_records(my_dialog, my_vitems, which_group, 0, 1);

        my_selection=0;
        my_button=my_dialog.editmenu(MSG_U(T_DEFINEDPRTSERVERS, "Defined print servers"), "", help_nil, my_selection, MENUBUT_QUIT|MENUBUT_ADD);

        switch(my_button){
        case MENU_QUIT:
        case MENU_ESCAPE:
            return;
        case MENU_ADD:
            /* adds item, but if used does not confirm the properties' window the item is removed */
            if(!section_edit_prtserv_prop(my_vitems, which_group, parser_add_line(my_vitems, MSG_U(X_PRTSERVNEWENTRY, "PRINTER_SERVER_NAME\tQUEUE_NAME"), which_group), 1)){
                my_vitems.remove_all();
                my_vitems.read(cf_nwservconf);
            }
            break;
        default:
            section_edit_prtserv_prop(my_vitems, which_group, my_selection, 0);
            break;
        }
    }
}


