#include <netconf.h>
#include <translat.h>
#include "inetdconf.h"
#include "inetdconf.m"
#include "inetdconfedit.h"
#include <module_apis/inetdconf_api.h>
#include <module_apis/inetdconf_apidef.h>

/*
 * Read through /etc/[x]inetd.conf and disable all services where server path
 * is invalid. netconf.log is updated.
 */
PUBLIC void server_path_check_update( )
{
	inetdconf_server_path( 1 );
}

/*
 * Read through /etc/[x]inetd.conf and log all services where server path
 * is invalid.
 */
PUBLIC void server_path_check( )
{
	inetdconf_server_path( 0 );
}

PUBLIC void *inetdconf_api_get ()
{
//fprintf(stderr,"inetdconf_api_get\n");
	INETDCONF_API *api = new INETDCONF_API;
	api->server_path_check = server_path_check;
	api->server_path_check_update = server_path_check_update;
	api->enable_service = inetdconf_enable_service;
	api->firewall_enable = firewall_enable;
	api->firewall_disable = firewall_disable;
	api->firewall_edit = firewall_edit;
	return api;
}

PUBLIC void inetdconf_api_release (void *api)
{
//fprintf(stderr,"inetdconf_api_release\n");
	delete (INETDCONF_API *)api;
}

